/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model.model;

import java.util.HashMap;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.ModelType;

public class ModelIdFactory {
    public static ModelId newInstance(ModelType modelType, String namespace, String version, String name) {
        return new ModelId(modelType, name, namespace, version);
    }

    public static ModelId newInstance(Model model) {
        return new ModelId(ModelIdFactory.getModelType(model), model.getName(), model.getNamespace(), model.getVersion());
    }

    public static ModelType getModelType(Model model) {
        if (model instanceof InformationModel) {
            return ModelType.InformationModel;
        }
        if (model instanceof FunctionblockModel) {
            return ModelType.Functionblock;
        }
        if (model instanceof Type) {
            return ModelType.Datatype;
        }
        if (model instanceof MappingModel) {
            return ModelType.Mapping;
        }
        throw new UnsupportedOperationException("ModelType not found for : " + model.getClass());
    }

    public static ModelId newInstance(ModelType modelType, Model model) {
        return new ModelId(modelType, model.getName(), model.getNamespace(), model.getVersion());
    }

    public static ModelId newInstance(ModelType modelType, ModelReference modelReference) {
        String importStr = modelReference.getImportedNamespace();
        int lastDot = importStr.lastIndexOf(".");
        String namespacePart = importStr.substring(0, lastDot);
        String namePart = importStr.substring(lastDot + 1);
        return new ModelId(modelType, namePart, namespacePart, modelReference.getVersion());
    }

    public static ModelId newInstance(String serializeStr) {
        String[] tokens = serializeStr.split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String[] pair = token.split("=");
            map.put(pair[0], pair[1]);
            ++n2;
        }
        ModelType modelType = ModelType.valueOf((String)map.get("modelType"));
        return new ModelId(modelType, (String)map.get("name"), (String)map.get("namespace"), (String)map.get("version"));
    }
}

