/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.lang.instrument.ClassFileTransformer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gemini.web.tomcat.internal.loading.ChainedClassLoader;
import org.eclipse.gemini.web.tomcat.spi.ClassLoaderCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class DelegatingClassLoaderCustomizer
implements ClassLoaderCustomizer {
    private final BundleContext context;
    private final ServiceTracker<ClassLoaderCustomizer, Object> tracker;
    private volatile Set<ClassLoaderCustomizer> delegate;

    public DelegatingClassLoaderCustomizer(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, ClassLoaderCustomizer.class.getName(), (ServiceTrackerCustomizer)new Customizer());
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    @Override
    public void addClassFileTransformer(ClassFileTransformer transformer, Bundle bundle) {
        if (this.delegate != null && this.delegate.size() > 0) {
            for (ClassLoaderCustomizer classLoaderCustomizer : this.delegate) {
                classLoaderCustomizer.addClassFileTransformer(transformer, bundle);
            }
        }
    }

    @Override
    public ClassLoader createThrowawayClassLoader(Bundle bundle) {
        if (this.delegate != null && this.delegate.size() > 0) {
            HashSet<ClassLoader> result = new HashSet<ClassLoader>();
            for (ClassLoaderCustomizer classLoaderCustomizer : this.delegate) {
                result.add(classLoaderCustomizer.createThrowawayClassLoader(bundle));
            }
            if (result.size() > 0) {
                return ChainedClassLoader.create(result.toArray(new ClassLoader[result.size()]));
            }
            return null;
        }
        return null;
    }

    @Override
    public ClassLoader[] extendClassLoaderChain(Bundle bundle) {
        if (this.delegate != null && this.delegate.size() > 0) {
            HashSet<ClassLoader> result = new HashSet<ClassLoader>();
            for (ClassLoaderCustomizer classLoaderCustomizer : this.delegate) {
                result.addAll(Arrays.asList(classLoaderCustomizer.extendClassLoaderChain(bundle)));
            }
            return result.toArray(new ClassLoader[result.size()]);
        }
        return new ClassLoader[0];
    }

    private class Customizer
    implements ServiceTrackerCustomizer<ClassLoaderCustomizer, Object> {
        private Customizer() {
        }

        public Object addingService(ServiceReference<ClassLoaderCustomizer> reference) {
            ClassLoaderCustomizer newDelegate = (ClassLoaderCustomizer)DelegatingClassLoaderCustomizer.this.context.getService(reference);
            if (DelegatingClassLoaderCustomizer.this.delegate == null) {
                DelegatingClassLoaderCustomizer.this.delegate = new HashSet();
            }
            DelegatingClassLoaderCustomizer.this.delegate.add(newDelegate);
            return newDelegate;
        }

        public void modifiedService(ServiceReference<ClassLoaderCustomizer> reference, Object service) {
        }

        public void removedService(ServiceReference<ClassLoaderCustomizer> reference, Object service) {
            if (DelegatingClassLoaderCustomizer.this.delegate != null) {
                DelegatingClassLoaderCustomizer.this.delegate.remove(DelegatingClassLoaderCustomizer.this.context.getService(reference));
            }
            DelegatingClassLoaderCustomizer.this.context.ungetService(reference);
        }
    }
}

