/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.config;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.snaps.core.internal.webapp.config.ServletNameAware;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXml;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXmlValidationException;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXmlValidator;

class StandardWebXmlValidator
implements WebXmlValidator {
    StandardWebXmlValidator() {
    }

    @Override
    public void validate(WebXml xml) throws WebXmlValidationException {
        this.validateServletMappingToServletDefinition(xml);
        this.validateFilterMappingToFilterDefintion(xml);
    }

    private void validateFilterMappingToFilterDefintion(WebXml xml) {
        Set<String> names = this.readServeltNames(xml.getServletDefinitions());
        Set<String> snameFromFilterMapping = this.readServeltNames(xml.getServletNameFilterMappingDefinitions());
        snameFromFilterMapping.removeAll(names);
        if (!snameFromFilterMapping.isEmpty()) {
            throw new WebXmlValidationException(String.format("WebXml contains filter mapping without matching servlet definition.  '%s'", snameFromFilterMapping));
        }
    }

    private void validateServletMappingToServletDefinition(WebXml xml) {
        Set<String> names = this.readServeltNames(xml.getServletDefinitions());
        Set<String> mappingNames = this.readServeltNames(xml.getServletMappingDefinitions());
        mappingNames.removeAll(names);
        if (!mappingNames.isEmpty()) {
            throw new WebXmlValidationException(String.format("WebXml contains servlet mapping(s) '%s' without matching servlet definition.", mappingNames));
        }
    }

    private Set<String> readServeltNames(ServletNameAware[] nameAware) {
        HashSet<String> names = new HashSet<String>();
        ServletNameAware[] servletNameAwareArray = nameAware;
        int n = nameAware.length;
        int n2 = 0;
        while (n2 < n) {
            ServletNameAware def = servletNameAwareArray[n2];
            names.add(def.getServletName());
            ++n2;
        }
        return names;
    }
}

