/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.virgo.snaps.core.internal.webapp.config.FilterDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.FilterDispatcherType;
import org.eclipse.virgo.snaps.core.internal.webapp.config.FilterMappingDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.ServletDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.ServletMappingDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.ServletNameFilterMappingDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.UrlPatternFilterMappingDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebComponentDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXml;

final class MutableWebXml
implements WebXml {
    private final List<ServletDefinition> servletDefinitions = new ArrayList<ServletDefinition>();
    private final List<ServletMappingDefinition> servletMappingDefinitions = new ArrayList<ServletMappingDefinition>();
    private final List<FilterDefinition> filterDefinitions = new ArrayList<FilterDefinition>();
    private final List<ServletNameFilterMappingDefinition> servletNameFilterMappingDefinitions = new ArrayList<ServletNameFilterMappingDefinition>();
    private final List<UrlPatternFilterMappingDefinition> urlPatternFilterMappingDefinitions = new ArrayList<UrlPatternFilterMappingDefinition>();

    MutableWebXml() {
    }

    @Override
    public ServletDefinition[] getServletDefinitions() {
        return this.servletDefinitions.toArray(new ServletDefinition[this.servletDefinitions.size()]);
    }

    @Override
    public ServletMappingDefinition[] getServletMappingDefinitions() {
        return this.servletMappingDefinitions.toArray(new ServletMappingDefinition[this.servletMappingDefinitions.size()]);
    }

    @Override
    public FilterDefinition[] getFilterDefinitions() {
        return this.filterDefinitions.toArray(new FilterDefinition[this.filterDefinitions.size()]);
    }

    @Override
    public ServletNameFilterMappingDefinition[] getServletNameFilterMappingDefinitions() {
        return this.servletNameFilterMappingDefinitions.toArray(new ServletNameFilterMappingDefinition[this.servletNameFilterMappingDefinitions.size()]);
    }

    @Override
    public UrlPatternFilterMappingDefinition[] getUrlPatternFilterMappingDefinitions() {
        return this.urlPatternFilterMappingDefinitions.toArray(new UrlPatternFilterMappingDefinition[this.urlPatternFilterMappingDefinitions.size()]);
    }

    public MutableServletDefinition addServletDefinition(String servletName, String servletClassName) {
        MutableServletDefinition def = new MutableServletDefinition(servletName, servletClassName);
        this.servletDefinitions.add(def);
        return def;
    }

    public void addServletMappingDefinition(String servletName, String urlPattern) {
        ImmutableServletMappingDefinition def = new ImmutableServletMappingDefinition(servletName, urlPattern);
        this.servletMappingDefinitions.add(def);
    }

    public MutableFilterDefinition addFilterDefinition(String filterName, String filterClassName) {
        MutableFilterDefinition def = new MutableFilterDefinition(filterName, filterClassName);
        this.filterDefinitions.add(def);
        return def;
    }

    public void addUrlPatternFilterMappingDefinition(String filterName, String urlPattern, Set<FilterDispatcherType> filterDispatcherTypes) {
        ImmutableUrlPatternFilterMappingDefinition definition = new ImmutableUrlPatternFilterMappingDefinition(filterName, urlPattern, filterDispatcherTypes);
        this.urlPatternFilterMappingDefinitions.add(definition);
    }

    public void addServletNameFilterMappingDefinition(String filterName, String servletName, Set<FilterDispatcherType> filterDispatcherTypes) {
        ImmutableServletNameFilterMappingDefinition definition = new ImmutableServletNameFilterMappingDefinition(filterName, servletName, filterDispatcherTypes);
        this.servletNameFilterMappingDefinitions.add(definition);
    }

    static abstract class AbstractFilterMappingDefinition
    implements FilterMappingDefinition {
        private final String filterName;
        final Set<FilterDispatcherType> dispatcherTypes;

        private AbstractFilterMappingDefinition(String filterName, Set<FilterDispatcherType> filterDispatcherTypes) {
            this.filterName = filterName;
            this.dispatcherTypes = filterDispatcherTypes;
        }

        @Override
        public String getFilterName() {
            return this.filterName;
        }

        @Override
        public Set<FilterDispatcherType> getFilterDispatcherTypes() {
            return this.dispatcherTypes;
        }
    }

    static abstract class AbstractWebComponentDefinition
    implements WebComponentDefinition {
        private final Map<String, String> initParameters = new ConcurrentHashMap<String, String>();

        AbstractWebComponentDefinition() {
        }

        @Override
        public final Map<String, String> getInitParameters() {
            return this.initParameters;
        }

        public final void addInitParameter(String name, String value) {
            this.initParameters.put(name, value);
        }
    }

    private static final class ImmutableServletMappingDefinition
    implements ServletMappingDefinition {
        private final String servletName;
        private final String urlPattern;

        public ImmutableServletMappingDefinition(String servletName, String urlPattern) {
            this.servletName = servletName;
            this.urlPattern = urlPattern;
        }

        @Override
        public String getUrlPattern() {
            return this.urlPattern;
        }

        @Override
        public String getServletName() {
            return this.servletName;
        }
    }

    private static final class ImmutableServletNameFilterMappingDefinition
    extends AbstractFilterMappingDefinition
    implements ServletNameFilterMappingDefinition {
        private final String servletName;

        public ImmutableServletNameFilterMappingDefinition(String filterName, String servletName, Set<FilterDispatcherType> filterDispatcherTypes) {
            super(filterName, filterDispatcherTypes);
            this.servletName = servletName;
        }

        @Override
        public String getServletName() {
            return this.servletName;
        }
    }

    private static final class ImmutableUrlPatternFilterMappingDefinition
    extends AbstractFilterMappingDefinition
    implements UrlPatternFilterMappingDefinition {
        private final String urlPattern;

        public ImmutableUrlPatternFilterMappingDefinition(String filterName, String urlPattern, Set<FilterDispatcherType> filterDispatcherTypes) {
            super(filterName, filterDispatcherTypes);
            this.urlPattern = urlPattern;
        }

        @Override
        public String getUrlPattern() {
            return this.urlPattern;
        }
    }

    static final class MutableFilterDefinition
    extends AbstractWebComponentDefinition
    implements FilterDefinition {
        private final String filterName;
        private final String filterClassName;

        public MutableFilterDefinition(String filterName, String filterClassName) {
            this.filterClassName = filterClassName;
            this.filterName = filterName;
        }

        @Override
        public String getFilterName() {
            return this.filterName;
        }

        @Override
        public String getFilterClassName() {
            return this.filterClassName;
        }
    }

    static final class MutableServletDefinition
    extends AbstractWebComponentDefinition
    implements ServletDefinition {
        private final String servletName;
        private final String servletClassName;

        public MutableServletDefinition(String servletName, String servletClassName) {
            this.servletClassName = servletClassName;
            this.servletName = servletName;
        }

        @Override
        public String getServletName() {
            return this.servletName;
        }

        @Override
        public String getServletClassName() {
            return this.servletClassName;
        }
    }
}

