/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.util.numbers;

import java.math.BigDecimal;
import org.eclipse.uomo.util.internal.Messages;
import org.eclipse.uomo.util.numbers.DecimalFormatOptions;
import org.eclipse.uomo.util.numbers.RealFormatOptions;
import org.eclipse.uomo.util.numbers.UOMoNumberFormatException;

class NumberValidator {
    private String source;
    private int cursor;
    private DecimalFormatOptions options;
    private String whole;
    private String decimals;
    private String exponent;

    protected NumberValidator(String source, DecimalFormatOptions options) {
        this.source = source;
        this.cursor = 0;
        this.options = options;
    }

    private boolean optionsBanExponent() {
        return this.options != null && this.options instanceof RealFormatOptions && ((RealFormatOptions)this.options).getExponent() != null && ((RealFormatOptions)this.options).getExponent() == false;
    }

    private boolean optionsRequireExponent() {
        return this.options != null && this.options instanceof RealFormatOptions && ((RealFormatOptions)this.options).getExponent() != null && ((RealFormatOptions)this.options).getExponent() != false;
    }

    private boolean optionsAllowSpecial() {
        return this.options != null && this.options instanceof RealFormatOptions && ((RealFormatOptions)this.options).isAllowSpecial();
    }

    private boolean more() {
        return this.cursor < this.source.length();
    }

    private char peek() {
        if (!this.more()) {
            return ' ';
        }
        return this.source.charAt(this.cursor);
    }

    private char next() {
        char ch = this.peek();
        ++this.cursor;
        return ch;
    }

    private String pos() {
        return Integer.toString(this.cursor);
    }

    private void start() throws UOMoNumberFormatException {
        if (this.source == null || this.source.equals("")) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, Messages.NumberValidator_Number_empty);
        }
        this.whole = null;
        this.decimals = null;
        this.exponent = null;
    }

    public long parseInteger() throws UOMoNumberFormatException {
        this.validateInteger();
        try {
            return Long.parseLong(this.whole);
        }
        catch (Exception e) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.SIZE, e.getMessage());
        }
    }

    public BigDecimal parseDecimal() throws UOMoNumberFormatException {
        this.validateDecimal();
        try {
            return new BigDecimal(String.valueOf(this.whole) + (this.decimals == null ? "" : String.valueOf(Messages.NumberValidator_DOT) + this.decimals));
        }
        catch (NumberFormatException e) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.SIZE, e.getMessage());
        }
    }

    public BigDecimal parseReal() throws UOMoNumberFormatException {
        this.validateReal();
        if (this.whole.equals((Object)UOMoNumberFormatException.Kind.NaN)) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.NaN, Messages.NumberValidator_Value_not_a_number);
        }
        if (this.whole.equals(Messages.NumberValidator_INF) || this.whole.equals(Messages.NumberValidator_plusINF)) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.PINF, Messages.NumberValidator_Value_Infinity);
        }
        if (this.whole.equals(Messages.NumberValidator_minusINF)) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.NINF, Messages.NumberValidator_Value_negative_Infinity);
        }
        try {
            return new BigDecimal(String.valueOf(this.whole) + (this.decimals == null ? "" : "." + this.decimals) + (this.exponent == null ? "" : String.valueOf(Messages.NumberValidator_E) + this.exponent));
        }
        catch (NumberFormatException e) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.SIZE, e.getLocalizedMessage());
        }
    }

    public void validateInteger() throws UOMoNumberFormatException {
        this.start();
        this.whole = this.processInteger(true, false, Messages.NumberValidator_an_Integer);
        if (this.more()) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_Content_after_Parsing_Int) + this.peek() + "' at character " + this.pos() + " after parsing integer");
        }
    }

    public void validateReal() throws UOMoNumberFormatException {
        this.start();
        this.processDecimal();
        if (this.more()) {
            if (this.peek() != 'e' && this.peek() != 'E') {
                throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_Content_at_Char_expecting_E) + this.peek() + "' at character " + this.pos() + " expecting e or E");
            }
            if (this.optionsBanExponent()) {
                throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.RULE, Messages.NumberValidator_Exponent_Format_not_allowed_in_Context);
            }
            this.next();
            this.exponent = this.processInteger(true, false, Messages.NumberValidator_an_Exponent);
            if (this.more()) {
                throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_Content_after_Parsing_Exponent) + this.peek() + "' at character " + this.pos() + " after parsing exponent");
            }
        } else if (this.optionsRequireExponent()) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.RULE, Messages.NumberValidator_Exponent_Format_required_in_Context);
        }
        this.checkDigits();
    }

    public void validateDecimal() throws UOMoNumberFormatException {
        this.start();
        this.processDecimal();
        if (this.more()) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_Content_after_Parsing_Decimal) + this.peek() + "' at character " + this.pos() + " after parsing decimal");
        }
        this.checkDigits();
    }

    private void checkDigits() throws UOMoNumberFormatException {
        if (this.options != null) {
            int len;
            if (this.options.getFractionDigits() != -1 && this.decimals != null && this.decimals.length() > this.options.getFractionDigits()) {
                throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.RULE, String.valueOf(Messages.NumberValidator_Only_Digits_after_Decimal_allowed_but_found) + Integer.toString(this.options.getFractionDigits()) + " digits after the decimal are allowed, but found " + Integer.toString(this.decimals.length()));
            }
            if (this.options.getTotalDigits() != -1 && (len = this.whole.length() + (this.decimals == null ? 0 : this.decimals.length())) > this.options.getTotalDigits()) {
                throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.RULE, "Only " + Integer.toString(this.options.getTotalDigits()) + " digits after the decimal are allowed, but found " + Integer.toString(len));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String processInteger(boolean allowSign, boolean allowComplex, String context) throws UOMoNumberFormatException {
        block7: {
            block8: {
                block6: {
                    if (!this.more()) {
                        throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_End_of_Source_looking_for) + context);
                    }
                    b = new StringBuffer();
                    if (allowSign && (this.peek() == '+' || this.peek() == '-')) {
                        if (this.peek() == '+') {
                            this.next();
                        } else {
                            b.append(this.next());
                        }
                    }
                    if (!this.more()) {
                        throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_End_of_Source_after_Sign_looking_for) + context);
                    }
                    if (!allowComplex || this.peek() != 'N') break block6;
                    this.processSequence(Messages.NumberValidator_NaN, context);
                    b.append("NaN");
                    break block7;
                }
                if (!allowComplex || this.peek() != 'I') break block8;
                this.processSequence("INF", context);
                b.append("INF");
                break block7;
            }
            if (this.peek() >= '0' && this.peek() <= '9') ** GOTO lbl29
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_Content_expecting_Start_of) + this.peek() + "' at character " + this.pos() + " expecting the start of " + context);
lbl-1000:
            // 1 sources

            {
                b.append(this.next());
lbl29:
                // 2 sources

                ** while (this.more() && this.peek() >= '0' && this.peek() <= '9')
            }
        }
        return b.toString();
    }

    private void processSequence(String mask, String context) throws UOMoNumberFormatException {
        int i = 0;
        while (i < mask.length()) {
            if (!this.more()) {
                throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_End_of_Source) + mask + "' in " + context);
            }
            char ch = this.next();
            if (ch != mask.charAt(i)) {
                throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_Content_NaN) + ch + "' at character " + this.pos() + " attempting to read 'NaN' in " + context);
            }
            ++i;
        }
        if (this.more()) {
            throw new UOMoNumberFormatException(UOMoNumberFormatException.Kind.TEXT_FORMAT, String.valueOf(Messages.NumberValidator_Unexpected_Content_following_in_Decimal) + this.peek() + "' at character " + this.pos() + " following '" + mask + "' in " + context);
        }
    }

    private void processDecimal() throws UOMoNumberFormatException {
        this.whole = this.processInteger(true, this.options == null || this.optionsAllowSpecial(), Messages.NumberValidator_a_number);
        if (this.more() && this.peek() == '.') {
            this.next();
            this.decimals = this.processInteger(false, false, Messages.NumberValidator_decimal_portion);
        }
    }
}

