/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode;

import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import systems.uom.quantity.Concentration;
import systems.uom.quantity.Consumption;
import systems.uom.quantity.Information;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.PiMultiplierConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

public final class CLDR
extends AbstractSystemOfUnits {
    private static final CLDR INSTANCE = new CLDR();
    public static final Unit<Length> METER = Units.METRE;
    public static final Unit<Length> MILLIMETER = MetricPrefix.MILLI((Unit)Units.METRE);
    public static final Unit<Length> CENTIMETER = MetricPrefix.CENTI((Unit)Units.METRE);
    public static final Unit<Length> KILOMETER = MetricPrefix.KILO((Unit)Units.METRE);
    public static final Unit<Length> FOOT = CLDR.addUnit(METER.multiply(3048.0).divide(10000.0));
    public static final Unit<Length> FURLONG = CLDR.addUnit(FOOT.multiply(660.0));
    public static final Unit<Length> YARD = CLDR.addUnit(FOOT.multiply(3.0));
    public static final Unit<Length> INCH = CLDR.addUnit(FOOT.divide(12.0));
    public static final Unit<Length> MILE = CLDR.addUnit(METER.multiply(1609344.0).divide(1000.0));
    public static final Unit<Length> ASTRONOMICAL_UNIT = CLDR.addUnit(Units.METRE.multiply(1.49597870691E11));
    public static final Unit<Length> FATHOM = CLDR.addUnit(FOOT.multiply(6.0));
    public static final Unit<Length> MILE_SCANDINAVIAN = CLDR.addUnit(KILOMETER.multiply(10.0));
    public static final Unit<Time> SECOND = CLDR.addUnit(Units.SECOND);
    public static final Unit<Time> WEEK = CLDR.addUnit(Units.WEEK);
    public static final Unit<Time> YEAR = CLDR.addUnit(Units.DAY.multiply(365.2525));
    public static final Unit<Angle> RADIAN = CLDR.addUnit(Units.RADIAN);
    public static final Unit<Angle> REVOLUTION_ANGLE = CLDR.addUnit(RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class), "rev", true);
    public static final Unit<Temperature> KELVIN = CLDR.addUnit(Units.KELVIN);
    private static final Unit<LuminousIntensity> CANDELA = CLDR.addUnit(Units.CANDELA);
    public static final Unit<Dimensionless> PI = CLDR.addUnit(AbstractUnit.ONE.transform((UnitConverter)new PiMultiplierConverter()));
    public static final Unit<Dimensionless> PERCENT = CLDR.addUnit(AbstractUnit.ONE.divide(100.0), "Percent", "%");
    private static final Unit<AmountOfSubstance> MOLE = CLDR.addUnit(Units.MOLE);
    public static final Unit<SolidAngle> STERADIAN = CLDR.addUnit(Units.STERADIAN);
    public static final Unit<Frequency> HERTZ = CLDR.addUnit(Units.HERTZ);
    public static final Unit<Force> NEWTON = CLDR.addUnit(Units.NEWTON);
    public static final Unit<Pressure> PASCAL = CLDR.addUnit(Units.PASCAL);
    private static final Unit<Pressure> METER_OF_WATER_COLUMN = MetricPrefix.KILO(PASCAL).multiply(980665.0).divide(100000.0);
    private static final Unit<Pressure> METER_OF_MERCURY_COLUMN = MetricPrefix.KILO(PASCAL).multiply(1333220.0).divide(10000.0);
    private static final Unit<Pressure> INCH_OF_WATER_COLUMN = new ProductUnit(METER_OF_WATER_COLUMN.multiply(INCH).divide(METER));
    public static final Unit<Pressure> INCH_HG = CLDR.addUnit(new ProductUnit(METER_OF_MERCURY_COLUMN.multiply(INCH).divide(METER)));
    public static final Unit<Energy> JOULE = CLDR.addUnit(Units.JOULE);
    public static final Unit<Power> WATT = CLDR.addUnit(Units.WATT);
    public static final Unit<Mass> KILOGRAM = CLDR.addUnit(Units.KILOGRAM);
    public static final Unit<ElectricCurrent> AMPERE = CLDR.addUnit(Units.AMPERE);
    public static final Unit<ElectricPotential> VOLT = CLDR.addUnit(Units.VOLT);
    public static final Unit<ElectricResistance> OHM = CLDR.addUnit(Units.OHM);
    public static final Unit<Temperature> CELSIUS = CLDR.addUnit(Units.CELSIUS);
    public static final Unit<ElectricInductance> HENRY = CLDR.addUnit(Units.HENRY);
    public static final Unit<Illuminance> LUX = CLDR.addUnit(Units.LUX);
    static final Unit<Angle> DEGREE_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 180L)));
    static final Unit<Angle> MINUTE_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 10800L)));
    static final Unit<Angle> SECOND_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 648000L)));
    public static final Unit<Angle> DEGREE = CLDR.addUnit(DEGREE_ANGLE);
    public static final Unit<Angle> ARC_MINUTE = CLDR.addUnit(MINUTE_ANGLE);
    public static final Unit<Angle> ARC_SECOND = CLDR.addUnit(SECOND_ANGLE);
    public static final Unit<Area> SQUARE_FOOT = CLDR.addUnit(new ProductUnit((Unit)((AbstractUnit)FOOT.multiply(FOOT))), "Square Foot", "sft");
    private static final Unit<Area> ARE = Units.SQUARE_METRE.multiply(100.0);
    public static final Unit<Area> HECTARE = CLDR.addUnit(ARE.multiply(100.0), "Hectare", "ha");
    public static final Unit<Area> ACRE = CLDR.addUnit(SQUARE_FOOT.multiply(43560.0));
    public static final Unit<Area> SQUARE_INCH = CLDR.addUnit(new ProductUnit(INCH.pow(2)));
    public static final Unit<Area> SQUARE_YARD = CLDR.addUnit(new ProductUnit(YARD.pow(2)));
    public static final Unit<Volume> LITER = new TransformedUnit(Units.CUBIC_METRE, (UnitConverter)new RationalConverter(1L, 1000L));
    public static final Unit<Volume> CUBIC_METER = CLDR.addUnit(Units.CUBIC_METRE);
    public static final Unit<Volume> CUBIC_INCH = CLDR.addUnit(INCH.pow(3).asType(Volume.class));
    public static final Unit<Volume> CUBIC_FOOT = CLDR.addUnit(CUBIC_INCH.multiply(1728.0));
    public static final Unit<Volume> CUBIC_MILE = CLDR.addUnit(CUBIC_FOOT.multiply(1.47197952E11));
    public static final Unit<Volume> CUBIC_YARD = CLDR.addUnit(CUBIC_FOOT.multiply(27.0));
    public static final Unit<Volume> ACRE_FOOT = CLDR.addUnit(CUBIC_FOOT.multiply(43560.0));
    public static final Unit<Volume> BUSHEL = CLDR.addUnit(CUBIC_INCH.multiply(215042.0).divide(100.0));
    public static final Unit<Volume> GALLON = CLDR.addUnit(CUBIC_INCH.multiply(231.0), "US gallon", "gal");
    public static final Unit<Volume> FLUID_OUNCE = CLDR.addUnit(GALLON.divide(128.0));
    public static final Unit<Volume> CUP = CLDR.addUnit(FLUID_OUNCE.multiply(8.0));
    public static final Unit<Volume> CUP_METRIC = CLDR.addUnit(MetricPrefix.MILLI(LITER).multiply(250.0));
    public static final Unit<Volume> PINT = CLDR.addUnit(FLUID_OUNCE.multiply(20.0), "Pint", "pt", true);
    public static final Unit<Volume> PINT_METRIC = CLDR.addUnit(MetricPrefix.MILLI(LITER).multiply(500.0), "Metric Pint", "metr. pt", true);
    public static final Unit<Volume> QUART = CLDR.addUnit(FLUID_OUNCE.multiply(40.0), "Quart", "qt");
    private static final Unit<Volume> MINIM = MetricPrefix.MICRO(LITER).multiply(61.61152);
    public static final Unit<Volume> TEASPOON = CLDR.addUnit(MINIM.multiply(80.0));
    public static final Unit<Volume> TABLESPOON = CLDR.addUnit(TEASPOON.multiply(3.0));
    public static final Unit<Time> MINUTE = CLDR.addUnit(Units.MINUTE);
    public static final Unit<Time> HOUR = CLDR.addUnit(Units.HOUR);
    public static final Unit<Time> DAY = CLDR.addUnit(Units.DAY);
    static final Unit<Time> YEAR_JULIAN = CLDR.addUnit(Units.DAY.multiply(365.25));
    public static final Unit<Time> MONTH = CLDR.addUnit(YEAR_JULIAN.divide(12.0));
    public static final Unit<Time> CENTURY = CLDR.addUnit(YEAR.multiply(100.0));
    private static final Unit<Pressure> BAR = CLDR.addUnit(Units.PASCAL.multiply(100000.0));
    public static final Unit<Mass> GRAM = CLDR.addUnit(Units.GRAM);
    public static final Unit<Mass> TONNE = CLDR.addUnit(Units.KILOGRAM.multiply(1000.0));
    private static final Unit<Mass> GRAIN = CLDR.addUnit(MetricPrefix.MILLI(GRAM).multiply(6479891.0).divide(100000.0));
    public static final Unit<Mass> POUND = CLDR.addUnit(GRAIN.multiply(7000.0));
    public static final Unit<Mass> OUNCE = CLDR.addUnit(POUND.divide(16.0), "oz", true);
    private static final Unit<Mass> PENNYWEIGHT_TROY = GRAIN.multiply(24.0);
    public static final Unit<Mass> OUNCE_TROY = CLDR.addUnit(PENNYWEIGHT_TROY.multiply(20.0));
    public static final Unit<Mass> STONE = CLDR.addUnit(POUND.multiply(14.0));
    static final Unit<Speed> C = CLDR.addUnit(Units.METRE_PER_SECOND.multiply(2.99792458E8));
    public static final Unit<Acceleration> G_FORCE = CLDR.addUnit(Units.METRE_PER_SQUARE_SECOND.multiply(9.80665));
    public static final Unit<Length> LIGHT_YEAR = CLDR.addUnit(new ProductUnit(C.multiply(YEAR_JULIAN)));
    static final Unit<Length> INCH_INTERNATIONAL = CLDR.addUnit(MetricPrefix.CENTI((Unit)Units.METRE).multiply(254.0).divide(100.0));
    static final Unit<Length> FOOT_INTERNATIONAL = CLDR.addUnit(INCH_INTERNATIONAL.multiply(12.0));
    public static final Unit<Length> NAUTICAL_MILE = CLDR.addUnit(Units.METRE.multiply(1852.0));
    public static final Unit<Speed> KNOT = CLDR.addUnit(new ProductUnit(NAUTICAL_MILE.divide(HOUR)));
    public static final Unit<Speed> METER_PER_SECOND = CLDR.addUnit(new ProductUnit(METER.divide(SECOND)), Speed.class);
    public static final Unit<Speed> MILE_PER_HOUR = CLDR.addUnit(MILE.divide(HOUR).asType(Speed.class), "Mile per hour", "mph");
    public static final Unit<Acceleration> METER_PER_SECOND_SQUARED = CLDR.addUnit(new ProductUnit(METER_PER_SECOND.divide(SECOND)), Acceleration.class);
    public static final Unit<Mass> CARAT = CLDR.addUnit(GRAM.divide(5.0));
    public static final Unit<Dimensionless> KARAT = CLDR.addUnit(AbstractUnit.ONE.divide(24.0));
    private static final Unit<Force> POUND_FORCE = POUND.multiply(G_FORCE).asType(Force.class);
    public static final Unit<Length> PARSEC = CLDR.addUnit(Units.METRE.multiply(3.085677E16));
    static final Unit<Length> LINE = INCH_INTERNATIONAL.divide(12.0);
    static final Unit<Length> POINT = LINE.divide(6.0);
    static final Unit<Length> PICA = POINT.multiply(12.0);
    static final Unit<Length> POINT_PRINTER = INCH_INTERNATIONAL.multiply(13837.0).divide(1000000.0);
    static final Unit<Length> PICA_PRINTER = POINT_PRINTER.multiply(12.0);
    public static final Unit<Temperature> FAHRENHEIT = CLDR.addUnit(KELVIN.multiply(5.0).divide(9.0).shift(459.67));
    public static final Unit<Energy> FOODCALORIE = CLDR.addUnit(JOULE.multiply(4186.8));
    private static final Unit<Energy> CALORIE_THERMOCHEMICAL = CLDR.addUnit(JOULE.multiply(4184.0).divide(1000.0));
    public static final Unit<Energy> CALORIE = CLDR.addUnit(CALORIE_THERMOCHEMICAL);
    public static final Unit<Power> HORSEPOWER = CLDR.addUnit(new ProductUnit(FOOT_INTERNATIONAL.multiply(POUND_FORCE).divide(SECOND)));
    public static final Unit<Pressure> POUND_PER_SQUARE_INCH = CLDR.addUnit(new ProductUnit(POUND_FORCE.divide(INCH_INTERNATIONAL.pow(2))));
    private static final Unit<Angle> CIRCLE = new ProductUnit(PI.multiply(RADIAN.multiply(2.0)));
    public static final Unit<SolidAngle> SPHERE = CLDR.addUnit(new ProductUnit(PI.multiply(STERADIAN.multiply(4.0))));
    public static final Unit<Information> BIT = CLDR.addUnit(new AlternateUnit((Unit)AbstractUnit.ONE, "bit"), "Bit", "bit", Information.class);
    public static final Unit<Information> BYTE = CLDR.addUnit(BIT.multiply(8.0), "Byte", "byte");
    public static final Unit<Concentration<Mass>> MILLIGRAM_PER_DECILITER = CLDR.addUnit(MetricPrefix.MILLI(GRAM).divide(MetricPrefix.DECI(LITER)).asType(Concentration.class));
    public static final Unit<Consumption<Volume>> LITER_PER_100KILOMETERS = CLDR.addUnit(KILOMETER.multiply(100.0).divide(LITER).asType(Consumption.class));
    public static final Unit<Consumption<Volume>> LITER_PER_KILOMETER = CLDR.addUnit(KILOMETER.divide(LITER).asType(Consumption.class));
    public static final Unit<Consumption<Volume>> MILE_PER_GALLON = CLDR.addUnit(MILE.divide(GALLON).asType(Consumption.class));

    private CLDR() {
    }

    public static CLDR getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return "Unicode CLDR";
    }

    private static <U extends Unit<Q>, Q extends Quantity<Q>> U addUnit(U unit) {
        CLDR.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        CLDR.INSTANCE.units.add(unit);
        CLDR.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)CLDR.INSTANCE.units, unit, (String)name);
        }
        CLDR.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return CLDR.addUnit(unit, name, text, true);
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, String name, String text, Class<? extends Quantity<?>> type) {
        CLDR.INSTANCE.quantityToUnit.put(type, unit);
        return CLDR.addUnit(unit, name, text);
    }

    private static <U extends Unit<?>> U addUnit(U unit, String text, boolean isLabel) {
        return CLDR.addUnit(unit, null, text, isLabel);
    }

    static {
        SimpleUnitFormat.getInstance().alias(BYTE, "B");
        SimpleUnitFormat.getInstance().label(CARAT, "ct");
        SimpleUnitFormat.getInstance().label(KARAT, "kt");
        SimpleUnitFormat.getInstance().label(POUND, "lb");
        SimpleUnitFormat.getInstance().label(BAR, "b");
        SimpleUnitFormat.getInstance().label(PARSEC, "pc");
        SimpleUnitFormat.getInstance().label(FOOT, "ft");
        SimpleUnitFormat.getInstance().label(SQUARE_FOOT, "sft");
    }
}

