/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.spi.p2.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalizationHelper {
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static final Locale DEFAULT_LOCALE = new Locale("df", "LT");
    private static LocalizationHelper instance = new LocalizationHelper();

    public static String getLocaleString(String filename, String prefix) {
        String localeString = null;
        if (filename.startsWith(prefix) && filename.endsWith(PROPERTIES_FILE_EXTENSION)) {
            localeString = filename.length() > prefix.length() + PROPERTIES_FILE_EXTENSION.length() ? filename.substring(prefix.length() + 1, filename.length() - PROPERTIES_FILE_EXTENSION.length()) : "";
        }
        return localeString;
    }

    public static Locale getLocale(String localeString) {
        Locale locale = DEFAULT_LOCALE;
        if (localeString.length() == 5 && localeString.indexOf(95) == 2) {
            locale = new Locale(localeString.substring(0, 2), localeString.substring(3, 5));
        } else if (localeString.length() == 2) {
            locale = new Locale(localeString.substring(0, 2));
        }
        return locale;
    }

    public static Map<Locale, Map<String, String>> getDirPropertyLocalizations(File root, String localizationPath, Locale defaultLocale, String[] propertyKeys) {
        File fullPath = new File(root, localizationPath);
        File localizationDir = fullPath.getParentFile();
        String localizationFile = fullPath.getName();
        String[] localizationFiles = LocalizationHelper.getLocalizationFiles(localizationDir, localizationFile);
        HashMap<Locale, Map<String, String>> localizations = null;
        if (localizationFiles != null && localizationFiles.length > 0) {
            localizations = new HashMap<Locale, Map<String, String>>(localizationFiles.length);
            int i = 0;
            while (i < localizationFiles.length) {
                String nextFile = localizationFiles[i];
                Locale nextLocale = LocalizationHelper.getLocale(LocalizationHelper.getLocaleString(nextFile, localizationFile));
                try {
                    Map<String, String> properties = LocalizationHelper.loadProperties(localizationDir, nextFile);
                    Map<String, String> localizedStrings = LocalizationHelper.getLocalizedProperties(propertyKeys, properties);
                    if (localizedStrings.size() > 0) {
                        localizations.put(nextLocale, localizedStrings);
                        if (DEFAULT_LOCALE.equals(nextLocale) && defaultLocale != null) {
                            localizations.put(nextLocale, localizedStrings);
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ++i;
            }
        }
        return localizations;
    }

    /*
     * Exception decompiling
     */
    public static Map<Locale, Map<String, String>> getJarPropertyLocalizations(File root, String localizationPath, Locale defaultLocale, String[] propertyKeys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 182->185)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, String> loadProperties(File root, String propertyFilename) throws IOException {
        Map map;
        block8: {
            InputStream propertyStream = null;
            try {
                try {
                    if (root.isDirectory()) {
                        propertyStream = new FileInputStream(new File(root, propertyFilename));
                    } else {
                        URLConnection connection = new URL(new StringBuffer("jar:").append(root.toURL().toExternalForm()).append("!/").append(propertyFilename).toString()).openConnection();
                        connection.setUseCaches(false);
                        propertyStream = connection.getInputStream();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Map map2 = CollectionUtils.emptyMap();
                    Object var4_6 = null;
                    if (propertyStream != null) {
                        propertyStream.close();
                    }
                    return map2;
                }
            }
            catch (Throwable throwable) {
                block9: {
                    Object var4_8 = null;
                    if (propertyStream == null) break block9;
                    propertyStream.close();
                }
                throw throwable;
            }
            map = CollectionUtils.loadProperties((InputStream)propertyStream);
            Object var4_7 = null;
            if (propertyStream == null) break block8;
            propertyStream.close();
        }
        return map;
    }

    public static Map<String, String> getLocalizedProperties(String[] propertyKeys, Map<String, String> properties) {
        HashMap<String, String> localizedProperties = new HashMap<String, String>();
        int i = 0;
        while (i < propertyKeys.length) {
            String localizedValue;
            String key = propertyKeys[i];
            if (key != null && (localizedValue = properties.get(key)) != null) {
                localizedProperties.put(key, localizedValue);
            }
            ++i;
        }
        return localizedProperties;
    }

    public static String[] getLocalizationFiles(File localizationDir, final String filenamePrefix) {
        LocalizationHelper localizationHelper = instance;
        localizationHelper.getClass();
        return localizationDir.list(new FileFilter(localizationHelper){

            public boolean accept(File directory, String filename) {
                return LocalizationHelper.getLocaleString(filename, filenamePrefix) != null;
            }
        });
    }

    private LocalizationHelper() {
    }

    private abstract class FileFilter
    implements FilenameFilter {
        public abstract boolean accept(File var1, String var2);
    }
}

