/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.AdviceFileParser;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.actions.IUpdateDescriptorAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdviceFileAdvice
extends AbstractAdvice
implements ITouchpointAdvice,
ICapabilityAdvice,
IUpdateDescriptorAdvice,
IPropertyAdvice,
IAdditionalInstallableUnitAdvice {
    public static final IPath BUNDLE_ADVICE_FILE = new Path("META-INF/p2.inf");
    private final String id;
    private final Version version;
    private Map<String, ITouchpointInstruction> touchpointInstructions;
    private IProvidedCapability[] providedCapabilities;
    private IRequirement[] requiredCapabilities;
    private IRequirement[] metaRequiredCapabilities;
    private Map<String, String> iuProperties;
    private MetadataFactory.InstallableUnitDescription[] additionalIUs;
    private IUpdateDescriptor updateDescriptor;
    private boolean containsAdvice = false;

    public AdviceFileAdvice(String id, Version version, IPath basePath, IPath adviceFilePath) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)version);
        Assert.isNotNull((Object)basePath);
        Assert.isNotNull((Object)adviceFilePath);
        this.id = id;
        this.version = version;
        Map<String, String> advice = AdviceFileAdvice.loadAdviceMap(basePath, adviceFilePath);
        if (advice.isEmpty()) {
            return;
        }
        AdviceFileParser parser = new AdviceFileParser(id, version, advice);
        try {
            parser.parse();
        }
        catch (Exception e) {
            String message = new StringBuffer("An error occured while parsing advice file: basePath=").append(basePath).append(", adviceFilePath=").append(adviceFilePath).append(".").toString();
            Status status = new Status(4, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
            return;
        }
        this.touchpointInstructions = parser.getTouchpointInstructions();
        this.providedCapabilities = parser.getProvidedCapabilities();
        this.requiredCapabilities = parser.getRequiredCapabilities();
        this.metaRequiredCapabilities = parser.getMetaRequiredCapabilities();
        this.iuProperties = parser.getProperties();
        this.additionalIUs = parser.getAdditionalInstallableUnitDescriptions();
        this.updateDescriptor = parser.getUpdateDescriptor();
        this.containsAdvice = true;
    }

    public boolean containsAdvice() {
        return this.containsAdvice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> loadAdviceMap(IPath basePath, IPath adviceFilePath) {
        Map map;
        InputStream stream;
        ZipFile jar;
        block30: {
            Map map2;
            block29: {
                Map map3;
                block27: {
                    block28: {
                        File location = basePath.toFile();
                        if (location == null) return CollectionUtils.emptyMap();
                        if (!location.exists()) {
                            return CollectionUtils.emptyMap();
                        }
                        jar = null;
                        stream = null;
                        try {
                            try {
                                if (location.isDirectory()) {
                                    File adviceFile = new File(location, adviceFilePath.toString());
                                    if (!adviceFile.isFile()) {
                                        map3 = CollectionUtils.emptyMap();
                                        Object var8_12 = null;
                                        if (stream == null) break block27;
                                        break block28;
                                    }
                                    stream = new BufferedInputStream(new FileInputStream(adviceFile));
                                } else if (location.isFile()) {
                                    jar = new ZipFile(location);
                                    ZipEntry entry = jar.getEntry(adviceFilePath.toString());
                                    if (entry == null) {
                                        map2 = CollectionUtils.emptyMap();
                                        break block29;
                                    }
                                    stream = new BufferedInputStream(jar.getInputStream(entry));
                                }
                                map = CollectionUtils.loadProperties(stream);
                                break block30;
                            }
                            catch (IOException e) {
                                String message = new StringBuffer("An error occured while reading advice file: basePath=").append(basePath).append(", adviceFilePath=").append(adviceFilePath).append(".").toString();
                                Status status = new Status(4, Activator.ID, message, (Throwable)e);
                                LogHelper.log((IStatus)status);
                                Map map4 = CollectionUtils.emptyMap();
                                Object var8_15 = null;
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (jar == null) return map4;
                                try {
                                    jar.close();
                                    return map4;
                                }
                                catch (IOException iOException) {}
                                return map4;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_16 = null;
                            if (stream != null) {
                                try {}
                                catch (IOException iOException) {}
                                stream.close();
                            }
                            if (jar == null) throw throwable;
                            try {}
                            catch (IOException iOException) {
                                throw throwable;
                            }
                            jar.close();
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException iOException) {}
                    stream.close();
                }
                if (jar == null) return map3;
                try {}
                catch (IOException iOException) {}
                jar.close();
                return map3;
            }
            Object var8_13 = null;
            if (stream != null) {
                try {}
                catch (IOException iOException) {}
                stream.close();
            }
            if (jar == null) return map2;
            try {}
            catch (IOException iOException) {}
            jar.close();
            return map2;
        }
        Object var8_14 = null;
        if (stream != null) {
            try {}
            catch (IOException iOException) {}
            stream.close();
        }
        if (jar == null) return map;
        try {}
        catch (IOException iOException) {}
        jar.close();
        return map;
    }

    @Override
    public boolean isApplicable(String configSpec, boolean includeDefault, String candidateId, Version candidateVersion) {
        return this.id.equals(candidateId) && this.version.equals(candidateVersion);
    }

    @Override
    public ITouchpointData getTouchpointData(ITouchpointData existing) {
        return MetadataFactory.mergeTouchpointData((ITouchpointData)existing, this.touchpointInstructions);
    }

    @Override
    public IProvidedCapability[] getProvidedCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.providedCapabilities;
    }

    @Override
    public IRequirement[] getRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.requiredCapabilities;
    }

    @Override
    public IRequirement[] getMetaRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.metaRequiredCapabilities;
    }

    @Override
    public MetadataFactory.InstallableUnitDescription[] getAdditionalInstallableUnitDescriptions(IInstallableUnit iu) {
        return this.additionalIUs;
    }

    @Override
    public IUpdateDescriptor getUpdateDescriptor(MetadataFactory.InstallableUnitDescription iu) {
        return this.updateDescriptor;
    }

    @Override
    public Map<String, String> getArtifactProperties(IInstallableUnit iu, IArtifactDescriptor descriptor) {
        return null;
    }

    @Override
    public Map<String, String> getInstallableUnitProperties(MetadataFactory.InstallableUnitDescription iu) {
        return this.iuProperties;
    }
}

