/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.shared;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.ui.tests.shared.IWaitCondition;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitTimeoutException;

public final class WaitUtils {
    private static final long SLEEP_INTERVAL_MS = 100L;
    private static final long UI_THREAD_SLEEP_INTERVAL_MS = 10L;
    private static final long DEFAULT_MAX_WAIT_TIME_MS = 300000L;

    private WaitUtils() {
    }

    public static void waitForJobs() {
        WaitUtils.waitUntil(new IWaitCondition(){

            @Override
            public boolean test() throws Exception {
                return Job.getJobManager().isIdle();
            }

            @Override
            public String getFailureMessage() {
                WaitUtils.printJobs();
                return "Timed out waiting for jobs to finish.";
            }
        });
    }

    public static void printJobs() {
        Job[] jobs;
        Job[] jobArray = jobs = Job.getJobManager().find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            System.err.println(job.toString() + " state: " + WaitUtils.jobStateToString(job.getState()));
            Thread thread = job.getThread();
            if (thread != null) {
                StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                int n3 = stackTraceElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    StackTraceElement stractTraceElement = stackTraceElementArray[n4];
                    System.err.println("  " + String.valueOf(stractTraceElement));
                    ++n4;
                }
            }
            System.err.println();
            ++n2;
        }
    }

    private static String jobStateToString(int jobState) {
        switch (jobState) {
            case 4: {
                return "RUNNING";
            }
            case 2: {
                return "WAITING";
            }
            case 1: {
                return "SLEEPING";
            }
            case 0: {
                return "NONE";
            }
        }
        return "UNKNOWN";
    }

    public static void waitUntil(IWaitCondition condition) {
        WaitUtils.waitUntil(condition, 300000L);
    }

    public static <E> void waitUntil(final Predicate<E> predicate, final E argument, final String failureMessage) {
        IWaitCondition condition = new IWaitCondition(){

            @Override
            public boolean test() throws Exception {
                return predicate.test(argument);
            }

            @Override
            public String getFailureMessage() {
                return failureMessage;
            }
        };
        WaitUtils.waitUntil(condition);
    }

    public static <E> void waitUntil(final Predicate<E> predicate, final E argument, final Supplier<String> failureMessage) {
        IWaitCondition condition = new IWaitCondition(){

            @Override
            public boolean test() throws Exception {
                return predicate.test(argument);
            }

            @Override
            public String getFailureMessage() {
                return (String)failureMessage.get();
            }
        };
        WaitUtils.waitUntil(condition);
    }

    public static void waitUntil(IWaitCondition condition, long maxWait) {
        long waitStart = System.currentTimeMillis();
        Display display = Display.getCurrent();
        Exception exception = null;
        while (true) {
            try {
                if (condition.test()) {
                    return;
                }
                exception = null;
            }
            catch (Exception e) {
                exception = e;
            }
            if (System.currentTimeMillis() - waitStart > maxWait) {
                if (exception != null) {
                    exception.printStackTrace();
                    throw new WaitTimeoutException("Timeout after " + maxWait + " ms: " + condition.getFailureMessage() + "\n" + String.valueOf(exception));
                }
                throw new WaitTimeoutException("Timeout after " + maxWait + " ms: " + condition.getFailureMessage());
            }
            if (display != null) {
                if (!display.readAndDispatch()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                display.update();
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static <E> void waitUntil(Predicate<E> predicate, E argument, String failureMessage, long maxWait) {
        WaitUtils.waitUntil(predicate, argument, () -> failureMessage, maxWait);
    }

    public static <E> void waitUntil(final Predicate<E> predicate, final E argument, final Supplier<String> failureMessage, long maxWait) {
        IWaitCondition condition = new IWaitCondition(){

            @Override
            public boolean test() throws Exception {
                return predicate.test(argument);
            }

            @Override
            public String getFailureMessage() {
                return (String)failureMessage.get();
            }
        };
        WaitUtils.waitUntil(condition, maxWait);
    }
}

