/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.trace;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.util.Vector;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfEventParser;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;

public class TmfEventParserStub
implements ITmfEventParser {
    private static final int NB_TYPES = 10;
    private final TmfEventType[] fTypes;
    private final ITmfTrace fEventStream;
    static final String typePrefix = "Type-";

    public TmfEventParserStub(ITmfTrace eventStream) {
        this.fEventStream = eventStream;
        this.fTypes = new TmfEventType[10];
        int i = 0;
        while (i < 10) {
            Vector<CallSite> fields = new Vector<CallSite>();
            int j = 1;
            while (j <= i) {
                String field = "Fmt-" + i + "-Fld-" + j;
                fields.add((CallSite)((Object)field));
                ++j;
            }
            String[] fieldArray = new String[i];
            ITmfEventField rootField = TmfEventField.makeRoot((String[])fields.toArray(fieldArray));
            this.fTypes[i] = new TmfEventType(typePrefix + i, rootField);
            ++i;
        }
    }

    public ITmfEvent parseEvent(ITmfContext context) {
        if (!(this.fEventStream instanceof TmfTraceStub)) {
            return null;
        }
        RandomAccessFile stream = ((TmfTraceStub)this.fEventStream).getStream();
        if (stream == null) {
            return null;
        }
        long location = 0L;
        if (context != null && context.getLocation() != null) {
            location = (Long)context.getLocation().getLocationInfo();
            try {
                stream.seek(location);
                long ts = stream.readLong();
                stream.readUTF();
                String type = stream.readUTF();
                stream.readInt();
                int typeIndex = Integer.parseInt(type.substring(typePrefix.length()));
                String[] fields = new String[typeIndex];
                int i = 0;
                while (i < typeIndex) {
                    fields[i] = stream.readUTF();
                    ++i;
                }
                StringBuffer content = new StringBuffer("[");
                if (typeIndex > 0) {
                    content.append(fields[0]);
                }
                int i2 = 1;
                while (i2 < typeIndex) {
                    content.append(", ").append(fields[i2]);
                    ++i2;
                }
                content.append("]");
                TmfEventField root = new TmfEventField(":root:", (Object)content.toString(), null);
                TmfEvent event = new TmfEvent(this.fEventStream, -1L, this.fEventStream.createTimestamp(ts * 1000000L), (ITmfEventType)this.fTypes[typeIndex], (ITmfEventField)root);
                return event;
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

