/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.parsers.custom;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.tests.parsers.custom.AbstractCustomTraceDataTest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CustomXmlTraceDataTest
extends AbstractCustomTraceDataTest {
    private static final String TRACE_PATH = TRACE_DIRECTORY + File.separator + "test.xml";
    private static final String DEFINITION_PATH = "testfiles" + File.separator + "xml" + File.separator + "testDefinition.xml";
    private static final AbstractCustomTraceDataTest.ICustomTestData CUSTOM_XML = new AbstractCustomTraceDataTest.ICustomTestData(){
        private static final int NB_EVENTS = 10;
        private CustomXmlTraceDefinition fDefinition;
        private ITmfEventAspect<?> fTimestampAspect;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public ITmfTrace getTrace() throws IOException, TmfTraceException {
            this.fDefinition = CustomXmlTraceDataTest.getDefinition(0);
            File file = new File(TRACE_PATH);
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write("<trace>");
                int i = 0;
                while (i < 10) {
                    SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
                    String eventStr = "<element time=\"" + f.format(new Date(i)) + "\">message</element>\n";
                    writer.write(eventStr);
                    ++i;
                }
                writer.write("</trace>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            CustomXmlTrace trace = new CustomXmlTrace(null, this.fDefinition, file.getPath(), 100);
            @NonNull ArrayList aspects = Lists.newArrayList((Iterable)trace.getEventAspects());
            this.fTimestampAspect = aspects.stream().filter(aspect -> aspect.getName().equals("Timestamp")).findFirst().get();
            return trace;
        }

        @Override
        public void validateEvent(ITmfEvent event) {
            Assert.assertTrue((boolean)(event instanceof CustomXmlEvent));
            String name = this.fDefinition.definitionName;
            Assert.assertEquals((String)"Event name", (Object)name, (Object)event.getName());
            Assert.assertEquals((String)"Event name and type", (Object)event.getType().getName(), (Object)event.getName());
            Assert.assertEquals((String)"Timestamp", (Object)Long.toString(event.getTimestamp().toNanos()), (Object)this.fTimestampAspect.resolve(event));
        }

        @Override
        public void validateEventCount(int eventCount) {
            Assert.assertEquals((String)"Event count", (long)10L, (long)eventCount);
        }
    };
    private static final AbstractCustomTraceDataTest.ICustomTestData CUSTOM_XML_EVENT_NAME = new AbstractCustomTraceDataTest.ICustomTestData(){
        private static final int NB_EVENTS = 10;
        private static final String DEFAULT_EVENT = "DefaultName";
        private static final String ATTRIBUTE_EVENT = "AttributeName";
        private static final String ELEMENT_EVENT = "ElementName";
        private CustomXmlTraceDefinition fDefinition;
        private ITmfEventAspect<?> fTimestampAspect;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public ITmfTrace getTrace() throws IOException, TmfTraceException {
            this.fDefinition = CustomXmlTraceDataTest.getDefinition(1);
            File file = new File(TRACE_PATH);
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write("<trace>");
                int i = 0;
                while (i < 10) {
                    String attribute = i % 5 != 0 ? String.format(" type=\"%s\"", ATTRIBUTE_EVENT) : "";
                    String element = i % 5 != 0 && i % 2 != 0 ? String.format("<type>%s</type>", ELEMENT_EVENT) : "";
                    String eventStr = String.format("<element time=\"" + i + "\"%s>%s</element>\n", attribute, element);
                    writer.write(eventStr);
                    ++i;
                }
                writer.write("</trace>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            CustomXmlTrace trace = new CustomXmlTrace(null, this.fDefinition, file.getPath(), 100);
            @NonNull ArrayList aspects = Lists.newArrayList((Iterable)trace.getEventAspects());
            this.fTimestampAspect = aspects.stream().filter(aspect -> aspect.getName().equals("Timestamp")).findFirst().get();
            return trace;
        }

        @Override
        public void validateEvent(ITmfEvent event) {
            Assert.assertTrue((boolean)(event instanceof CustomXmlEvent));
            long ts = event.getTimestamp().getValue();
            if (ts % 5L == 0L) {
                Assert.assertEquals((String)"Event name", (Object)DEFAULT_EVENT, (Object)event.getName());
            } else if (ts % 2L == 0L) {
                Assert.assertEquals((String)"Event name", (Object)ATTRIBUTE_EVENT, (Object)event.getName());
            } else {
                Assert.assertEquals((String)"Event name", (Object)ELEMENT_EVENT, (Object)event.getName());
            }
            Assert.assertEquals((String)"Event name and type", (Object)event.getType().getName(), (Object)event.getName());
            Assert.assertEquals((String)"Timestamp", (Object)TmfBaseAspects.getTimestampAspect().resolve(event), (Object)this.fTimestampAspect.resolve(event));
        }

        @Override
        public void validateEventCount(int eventCount) {
            Assert.assertEquals((String)"Event count", (long)10L, (long)eventCount);
        }
    };
    private static final AbstractCustomTraceDataTest.ICustomTestData CUSTOM_XML_EXTRA_FIELDS = new AbstractCustomTraceDataTest.ICustomTestData(){
        private static final int NB_EVENTS = 5;
        private static final String FOO = "foo";
        private static final String BAR = "bar";
        private static final String BAZ = "baz";
        private static final String MESSAGE = "message";
        private CustomXmlTraceDefinition fDefinition;

        @Override
        public ITmfTrace getTrace() throws IOException, TmfTraceException {
            this.fDefinition = CustomXmlTraceDataTest.getDefinition(2);
            File file = new File(TRACE_PATH);
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write("<trace>");
                Object eventStr = String.format("<event timestamp=\"%s\" name=\"%s\">\n", "1", MESSAGE);
                eventStr = (String)eventStr + String.format("<field name=\"%s\" value=\"%s\"/>\n", FOO, BAR);
                eventStr = (String)eventStr + "</event>\n";
                writer.write((String)eventStr);
                eventStr = String.format("<event timestamp=\"%s\" name=\"%s\">\n", "2", MESSAGE);
                eventStr = (String)eventStr + String.format("<field name=\"%s\" value=\"%s\"/>\n", FOO, BAR);
                eventStr = (String)eventStr + String.format("<field name=\"%s\" value=\"%s\"/>\n", BAR, FOO);
                eventStr = (String)eventStr + "</event>\n";
                writer.write((String)eventStr);
                eventStr = String.format("<event timestamp=\"%s\" name=\"%s\">\n", "3", MESSAGE);
                eventStr = (String)eventStr + String.format("<field name=\"Message\" value=\"%s\"/>\n", FOO);
                eventStr = (String)eventStr + "</event>\n";
                writer.write((String)eventStr);
                eventStr = String.format("<event timestamp=\"%s\" name=\"%s\">\n", "4", MESSAGE);
                eventStr = (String)eventStr + String.format("<field name=\"%s\" value=\"%s\"/>\n", FOO, BAR);
                eventStr = (String)eventStr + String.format("<field name=\"%s\" value=\"%s\"/>\n", FOO, BAZ);
                eventStr = (String)eventStr + "</event>\n";
                writer.write((String)eventStr);
                eventStr = String.format("<event timestamp=\"%s\" name=\"%s\">\n", "5", MESSAGE);
                eventStr = (String)eventStr + String.format("<fieldName value=\"%s\"/>\n", FOO);
                eventStr = (String)eventStr + String.format("<fieldValue value=\"%s\"/>\n", BAR);
                eventStr = (String)eventStr + String.format("<fieldValue value=\"%s\"/>\n", BAZ);
                eventStr = (String)eventStr + "</event>\n";
                writer.write((String)eventStr);
                writer.write("</trace>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new CustomXmlTrace(null, this.fDefinition, file.getPath(), 100);
        }

        @Override
        public void validateEvent(ITmfEvent event) {
            Assert.assertTrue((boolean)(event instanceof CustomXmlEvent));
            long ts = event.getTimestamp().getValue();
            switch ((int)ts) {
                case 1: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)BAR, (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNull((Object)event.getContent().getField(new String[]{BAR}));
                    break;
                }
                case 2: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)BAR, (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{BAR}));
                    Assert.assertEquals((Object)FOO, (Object)event.getContent().getField(new String[]{BAR}).getValue());
                    break;
                }
                case 3: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{CustomTraceDefinition.Tag.MESSAGE.toString()}));
                    Assert.assertEquals((Object)MESSAGE, (Object)event.getContent().getField(new String[]{CustomTraceDefinition.Tag.MESSAGE.toString()}).getValue());
                    break;
                }
                case 4: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)"bar | baz", (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNull((Object)event.getContent().getField(new String[]{BAR}));
                    break;
                }
                case 5: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)BAZ, (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNull((Object)event.getContent().getField(new String[]{BAR}));
                    break;
                }
                default: {
                    Assert.fail((String)("unknown timestamp " + ts));
                }
            }
            Assert.assertEquals((String)"Event name and type", (Object)event.getType().getName(), (Object)event.getName());
        }

        @Override
        public void validateEventCount(int eventCount) {
            Assert.assertEquals((String)"Event count", (long)5L, (long)eventCount);
        }
    };

    public CustomXmlTraceDataTest(String name, @NonNull AbstractCustomTraceDataTest.ICustomTestData data) {
        super(data);
    }

    private static CustomXmlTraceDefinition getDefinition(int index) {
        CustomXmlTraceDefinition[] definitions = CustomXmlTraceDefinition.loadAll((String)new File(DEFINITION_PATH).toString());
        return definitions[index];
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Base parser", CUSTOM_XML}, {"Parse with event name", CUSTOM_XML_EVENT_NAME}, {"Parse with extra fields", CUSTOM_XML_EXTRA_FIELDS});
    }
}

