/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.model;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.junit.Assert;
import org.junit.Test;

public class XmlSegmentTest {
    private static final @NonNull String TEST_TRACE5 = "test_traces/testTrace5.xml";
    private static final @NonNull String TEST_TRACE2 = "test_traces/testTrace2.xml";
    private static final @NonNull String NAME_FIELD_1 = "field1";
    private static final @NonNull String NAME_FIELD_2 = "field2";
    private static final @NonNull String NAME_FIELD_3 = "field3";
    private static final long SEGMENT_START = 1L;
    private static final long SEGMENT_TIME2 = 3L;
    private static final long SEGMENT_TIME3 = 5L;
    private static final long SEGMENT_TIME4 = 7L;
    private static final @NonNull Map<@NonNull String, @NonNull Object> SEGMENT_CONTENT_1 = ImmutableMap.of((Object)"field1", (Object)100L, (Object)"field2", (Object)"test", (Object)"field3", (Object)1);
    private static final @NonNull Map<@NonNull String, @NonNull Object> SEGMENT_CONTENT_2 = ImmutableMap.of((Object)"field1", (Object)200L, (Object)"field2", (Object)"test", (Object)"field3", (Object)1);
    private static final @NonNull TmfXmlPatternSegment SEGMENT_1 = new TmfXmlPatternSegment(1L, 1L, "test1", Collections.emptyMap());
    private static final @NonNull TmfXmlPatternSegment SEGMENT_2 = new TmfXmlPatternSegment(1L, 3L, "test2", SEGMENT_CONTENT_1);
    private static final @NonNull TmfXmlPatternSegment SEGMENT_3 = new TmfXmlPatternSegment(1L, 5L, "test1", Collections.emptyMap());
    private static final @NonNull TmfXmlPatternSegment SEGMENT_4 = new TmfXmlPatternSegment(1L, 7L, "test2", SEGMENT_CONTENT_2);
    private static final @NonNull TmfXmlPatternSegment MAPPED_SEGMENT = new TmfXmlPatternSegment(1L, 1L, "open", Collections.emptyMap());

    private static @NonNull ITmfTrace getTrace(String traceFile) {
        return XmlUtilsTest.initializeTrace(traceFile);
    }

    private static void deleteSupplementaryFiles(@NonNull ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private static @NonNull XmlPatternAnalysis initializeModule(@NonNull ITmfTrace trace, TmfXmlTestFiles xmlTestFile) throws TmfAnalysisException {
        XmlPatternAnalysis module = XmlUtilsTest.initializePatternModule(xmlTestFile);
        module.setTrace(trace);
        module.schedule();
        module.waitForCompletion();
        return module;
    }

    @Test
    public void testMappingGroup() throws TmfAnalysisException {
        ITmfTrace trace = XmlSegmentTest.getTrace(TEST_TRACE5);
        XmlPatternAnalysis module = null;
        try {
            module = XmlSegmentTest.initializeModule(trace, TmfXmlTestFiles.CONSUMING_FSM_TEST);
            XmlSegmentTest.doTestMappingGroup(module);
        }
        finally {
            if (module != null) {
                module.dispose();
            }
            XmlSegmentTest.deleteSupplementaryFiles(trace);
            trace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void doTestMappingGroup(XmlPatternAnalysis module) {
        @Nullable @NonNull ISegmentStore ss = module.getSegmentStore();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((String)"Segment store size", (long)1L, (long)ss.size());
        Object segment = ss.iterator().next();
        Assert.assertTrue((boolean)(segment instanceof TmfXmlPatternSegment));
        XmlUtilsTest.testPatternSegmentData(MAPPED_SEGMENT, (TmfXmlPatternSegment)segment);
    }

    @Test
    public void testSegmentContent() throws TmfAnalysisException {
        ITmfTrace trace = XmlSegmentTest.getTrace(TEST_TRACE2);
        XmlPatternAnalysis module = null;
        try {
            module = XmlSegmentTest.initializeModule(trace, TmfXmlTestFiles.VALID_PATTERN_SEGMENT);
            XmlSegmentTest.doTestSegmentContent(module);
            module.dispose();
            module = XmlSegmentTest.initializeModule(trace, TmfXmlTestFiles.VALID_PATTERN_SEGMENT);
            XmlSegmentTest.doTestSegmentContent(module);
        }
        finally {
            if (module != null) {
                module.dispose();
            }
            XmlSegmentTest.deleteSupplementaryFiles(trace);
            trace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void doTestSegmentContent(XmlPatternAnalysis module) {
        @Nullable @NonNull ISegmentStore ss = module.getSegmentStore();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((String)"Segment store size", (long)4L, (long)ss.size());
        @NonNull Iterator iterator = ss.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ISegment segment1 = (ISegment)iterator.next();
        Assert.assertTrue((boolean)(segment1 instanceof TmfXmlPatternSegment));
        XmlUtilsTest.testPatternSegmentData(SEGMENT_1, (TmfXmlPatternSegment)segment1);
        Assert.assertTrue((boolean)iterator.hasNext());
        ISegment segment2 = (ISegment)iterator.next();
        Assert.assertTrue((boolean)(segment2 instanceof TmfXmlPatternSegment));
        XmlUtilsTest.testPatternSegmentData(SEGMENT_2, (TmfXmlPatternSegment)segment2);
        Assert.assertTrue((boolean)iterator.hasNext());
        ISegment segment3 = (ISegment)iterator.next();
        Assert.assertTrue((boolean)(segment3 instanceof TmfXmlPatternSegment));
        XmlUtilsTest.testPatternSegmentData(SEGMENT_3, (TmfXmlPatternSegment)segment3);
        Assert.assertTrue((boolean)iterator.hasNext());
        ISegment segment4 = (ISegment)iterator.next();
        Assert.assertTrue((boolean)(segment4 instanceof TmfXmlPatternSegment));
        XmlUtilsTest.testPatternSegmentData(SEGMENT_4, (TmfXmlPatternSegment)segment4);
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)-1L, (long)segment1.compareTo(segment3));
        Assert.assertEquals((long)1L, (long)segment3.compareTo(segment1));
        Assert.assertEquals((long)-1L, (long)segment1.compareTo(segment2));
        Assert.assertEquals((long)1L, (long)segment2.compareTo(segment1));
        Assert.assertEquals((long)0L, (long)segment2.compareTo(segment2));
        Assert.assertEquals((long)-1L, (long)segment2.compareTo(segment4));
        Assert.assertEquals((long)1L, (long)segment4.compareTo(segment2));
    }
}

