/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

import java.io.File;
import java.util.Iterator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.FileOffsetMapper;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoAnalysisModule;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UstDebugInfoSourceAspect
implements ITmfEventAspect<TmfCallsite> {
    public static final UstDebugInfoSourceAspect INSTANCE = new UstDebugInfoSourceAspect();

    private UstDebugInfoSourceAspect() {
    }

    public String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_SourceAspectName);
    }

    public String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_SourceAspectHelpText);
    }

    public @Nullable TmfCallsite resolve(ITmfEvent event) {
        TmfCallsite callsite;
        UstDebugInfoAnalysisModule ustDebugModule;
        ITmfStateSystem ustDebugSsq;
        if (!(event.getTrace() instanceof LttngUstTrace)) {
            return null;
        }
        LttngUstTrace trace = (LttngUstTrace)event.getTrace();
        BinaryCallsite bc = UstDebugInfoBinaryAspect.INSTANCE.resolve(event);
        if (bc == null) {
            return null;
        }
        Iterator ustDebugModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)event.getTrace(), UstDebugInfoAnalysisModule.class).iterator();
        if (ustDebugModules.hasNext() && (ustDebugSsq = (ustDebugModule = (UstDebugInfoAnalysisModule)((Object)ustDebugModules.next())).getStateSystem()) != null) {
            String binFilePath = bc.getBinaryFilePath();
            long offset = bc.getOffset() + ustDebugSsq.getStartTime();
            try {
                int srcFileNameQuark = ustDebugSsq.getQuarkAbsolute(new String[]{binFilePath, "sourceFileName"});
                int lineNrQuark = ustDebugSsq.getQuarkAbsolute(new String[]{binFilePath, "lineNr"});
                ITmfStateInterval srcFileInterval = ustDebugSsq.querySingleState(offset, srcFileNameQuark);
                ITmfStateInterval lineNrInterval = ustDebugSsq.querySingleState(offset, lineNrQuark);
                String lineNrValue = lineNrInterval.getValueString();
                long lineNr = Long.parseLong(lineNrValue);
                String srcFileName = srcFileInterval.getValueString();
                if (srcFileName != null) {
                    return new TmfCallsite(srcFileName, Long.valueOf(lineNr));
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        if ((callsite = FileOffsetMapper.getCallsiteFromOffset(new File(bc.getBinaryFilePath()), bc.getBuildId(), bc.getOffset())) == null) {
            return null;
        }
        String pathPrefix = trace.getSymbolProviderConfig().getActualRootDirPath();
        if (pathPrefix.isEmpty()) {
            return callsite;
        }
        String fullFileName = String.valueOf(pathPrefix) + callsite.getFileName();
        return new TmfCallsite(fullFileName, callsite.getLineNo());
    }
}

