/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Optional;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStructuredBindingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDeferredFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.VariableReadWriteFlags;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;

public final class CPPVariableReadWriteFlags
extends VariableReadWriteFlags {
    private static CPPVariableReadWriteFlags INSTANCE = new CPPVariableReadWriteFlags();

    public static Optional<Integer> getReadWriteFlags(IASTName variable) {
        CPPSemantics.pushLookupPoint(variable);
        try {
            Optional<Integer> optional = INSTANCE.rwAnyNode(variable, 0);
            return optional;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }

    @Override
    protected Optional<Integer> rwAnyNode(IASTNode node, int indirection) {
        IASTNode parent = node.getParent();
        if (parent instanceof ICPPASTConstructorInitializer) {
            return this.rwInCtorInitializer(node, indirection, (ICPPASTConstructorInitializer)parent);
        }
        if (parent instanceof ICPPASTFieldDesignator) {
            return Optional.of(64);
        }
        return super.rwAnyNode(node, indirection);
    }

    @Override
    protected Optional<Integer> rwInDeclarator(IASTDeclarator parent, int indirection) {
        IType type = CPPVisitor.createType(parent);
        if (type instanceof ICPPUnknownType || type instanceof ICPPClassType && !TypeTraits.hasTrivialDefaultConstructor((ICPPClassType)type, 40)) {
            return Optional.of(64);
        }
        return super.rwInDeclarator(parent, indirection);
    }

    private Optional<Integer> rwInCtorInitializer(IASTNode node, int indirection, ICPPASTConstructorInitializer parent) {
        IASTNode grand = parent.getParent();
        if (grand instanceof IASTDeclarator || grand instanceof ICPPASTNewExpression) {
            IBinding binding;
            if (grand instanceof IASTImplicitNameOwner) {
                IASTImplicitName[] names;
                IASTImplicitName[] iASTImplicitNameArray = names = ((IASTImplicitNameOwner)grand).getImplicitNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTImplicitName in = iASTImplicitNameArray[n2];
                    IBinding b = in.resolveBinding();
                    if (b instanceof ICPPConstructor) {
                        ICPPConstructor ctor = (ICPPConstructor)b;
                        int idx = 0;
                        IASTInitializerClause[] iASTInitializerClauseArray = parent.getArguments();
                        int n3 = iASTInitializerClauseArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IASTInitializerClause child = iASTInitializerClauseArray[n4];
                            if (child == node) {
                                return this.rwArgumentForFunctionCall(ctor.getType(), idx, child, indirection);
                            }
                            ++idx;
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            if (grand instanceof IASTDeclarator && parent.getArguments().length == 1 && (binding = ((IASTDeclarator)grand).getName().getBinding()) instanceof IVariable) {
                IType type = ((IVariable)binding).getType();
                return this.rwAssignmentToType(type, indirection);
            }
        } else if (grand instanceof ICPPASTStructuredBindingDeclaration) {
            return this.rwInStructuredBinding((ICPPASTStructuredBindingDeclaration)grand);
        }
        return Optional.empty();
    }

    @Override
    protected Optional<Integer> rwInUnaryExpression(IASTNode node, IASTUnaryExpression expr, int indirection) {
        switch (expr.getOperator()) {
            case 13: {
                return Optional.of(0);
            }
        }
        return super.rwInUnaryExpression(node, expr, indirection);
    }

    @Override
    protected Optional<Integer> rwInFunctionName(IASTExpression node) {
        IType type;
        if (!(node instanceof IASTIdExpression) && (type = node.getExpressionType()) instanceof ICPPFunctionType && !((ICPPFunctionType)type).isConst()) {
            return Optional.of(96);
        }
        return Optional.of(32);
    }

    @Override
    protected Optional<Integer> rwAssignmentToType(IType type, int indirection) {
        if (CPPTemplates.isDependentType(type)) {
            return Optional.empty();
        }
        if (indirection == 0) {
            if (!(type instanceof ICPPReferenceType) || ((ICPPReferenceType)type).isRValueReference()) {
                return Optional.of(32);
            }
            type = ((ICPPReferenceType)type).getType();
        }
        while (indirection > 0 && type instanceof ITypeContainer) {
            if (type instanceof IPointerType) {
                --indirection;
            }
            type = ((ITypeContainer)type).getType();
        }
        if (indirection == 0) {
            if (type instanceof IQualifierType) {
                return ((IQualifierType)type).isConst() ? Optional.of(32) : Optional.of(96);
            }
            if (type instanceof IPointerType) {
                return ((IPointerType)type).isConst() ? Optional.of(32) : Optional.of(96);
            }
        }
        return Optional.empty();
    }

    @Override
    protected Optional<Integer> rwArgumentForFunctionCall(IASTFunctionCallExpression funcCall, IASTNode argument, int indirection) {
        ICPPDeferredFunction deferredFunc;
        ICPPFunction[] candidates;
        IBinding b;
        IASTExpression functionNameExpression = funcCall.getFunctionNameExpression();
        if (functionNameExpression instanceof IASTIdExpression && (b = ((IASTIdExpression)functionNameExpression).getName().resolveBinding()) instanceof ICPPDeferredFunction && (candidates = (deferredFunc = (ICPPDeferredFunction)b).getCandidates()) != null) {
            IASTInitializerClause[] args = funcCall.getArguments();
            int argPos = ArrayUtil.indexOf(args, argument);
            Optional<Integer> cumulative = Optional.empty();
            ICPPFunction[] iCPPFunctionArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPFunctionType type;
                ICPPFunction f = iCPPFunctionArray[n2];
                if (f != null && (type = f.getType()) instanceof IFunctionType) {
                    Optional<Integer> res = this.rwArgumentForFunctionCall(type, argPos, args[argPos], indirection);
                    cumulative = this.union(cumulative, res);
                }
                ++n2;
            }
            return cumulative;
        }
        return super.rwArgumentForFunctionCall(funcCall, argument, indirection);
    }
}

