/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core.tests;

import java.util.ArrayList;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.junit.Assert;
import org.junit.Test;

public class SegmentStoreFactoryTest {
    @Test
    public void simpleCreate() {
        Assert.assertNotNull((Object)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[0]));
    }

    @Test
    public void createFast() {
        Assert.assertNotNull((Object)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Fast}));
    }

    @Test
    public void createStable() {
        Assert.assertNotNull((Object)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Stable}));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void createDistinct() {
        @NonNull ISegmentStore fixture = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Distinct});
        Assert.assertNotNull((Object)fixture);
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)fixture);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void createDistinctFast() {
        @NonNull ISegmentStore fixture = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Distinct, SegmentStoreFactory.SegmentStoreType.Fast});
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)fixture);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void createDistinctStable() {
        @NonNull ISegmentStore fixture = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Distinct, SegmentStoreFactory.SegmentStoreType.Stable});
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)fixture);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void createDoubleDistinct() {
        @NonNull ISegmentStore fixture = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Distinct, SegmentStoreFactory.SegmentStoreType.Distinct});
        Assert.assertNotNull((Object)fixture);
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)fixture);
    }

    @Test
    public void createAllDressed() {
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Distinct, SegmentStoreFactory.SegmentStoreType.Stable, SegmentStoreFactory.SegmentStoreType.Fast}));
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Distinct, SegmentStoreFactory.SegmentStoreType.Fast, SegmentStoreFactory.SegmentStoreType.Stable}));
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Stable, SegmentStoreFactory.SegmentStoreType.Distinct, SegmentStoreFactory.SegmentStoreType.Fast}));
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Stable, SegmentStoreFactory.SegmentStoreType.Fast, SegmentStoreFactory.SegmentStoreType.Distinct}));
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Fast, SegmentStoreFactory.SegmentStoreType.Distinct, SegmentStoreFactory.SegmentStoreType.Stable}));
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Fast, SegmentStoreFactory.SegmentStoreType.Stable, SegmentStoreFactory.SegmentStoreType.Distinct}));
    }

    @Test
    public void createTortureTest() {
        Random rnd = new Random();
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SegmentStoreFactory.SegmentStoreType> args = new ArrayList<SegmentStoreFactory.SegmentStoreType>();
        rnd.setSeed(1234L);
        int nbValues = SegmentStoreFactory.SegmentStoreType.values().length;
        args.add(SegmentStoreFactory.SegmentStoreType.Distinct);
        int i = 0;
        while (i < 1000) {
            int nextInt = rnd.nextInt(nbValues);
            args.add(SegmentStoreFactory.SegmentStoreType.values()[nextInt]);
            ++i;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        SegmentStoreFactory.SegmentStoreType @NonNull [] array = args.toArray(new SegmentStoreFactory.SegmentStoreType[args.size()]);
        Assert.assertNotNull((Object)array);
        SegmentStoreFactoryTest.testDistinct((ISegmentStore<ISegment>)SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])array));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void createPreloaded() {
        Object[] data = new ISegment[]{new BasicSegment(0L, 0L)};
        @NonNull ISegmentStore segmentStore = SegmentStoreFactory.createSegmentStore((Object[])data, (SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[0]);
        Assert.assertNotNull((Object)segmentStore);
        Assert.assertEquals((long)1L, (long)segmentStore.size());
        segmentStore = SegmentStoreFactory.createSegmentStore((Object[])data, (SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Fast});
        Assert.assertNotNull((Object)segmentStore);
        Assert.assertEquals((long)1L, (long)segmentStore.size());
        segmentStore = SegmentStoreFactory.createSegmentStore((Object[])data, (SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Stable});
        Assert.assertNotNull((Object)segmentStore);
        Assert.assertEquals((long)1L, (long)segmentStore.size());
        segmentStore = SegmentStoreFactory.createSegmentStore((Object[])data, (SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Distinct});
        Assert.assertNotNull((Object)segmentStore);
        Assert.assertEquals((long)1L, (long)segmentStore.size());
    }

    private static void testDistinct(ISegmentStore<@NonNull ISegment> fixture) {
        BasicSegment seg = new BasicSegment(0L, 0L);
        fixture.add((Object)seg);
        fixture.add((Object)seg);
        Assert.assertEquals((long)1L, (long)fixture.size());
        fixture.clear();
        fixture.add((Object)new BasicSegment(0L, 0L));
        fixture.add((Object)new BasicSegment(0L, 0L));
        Assert.assertEquals((long)1L, (long)fixture.size());
    }
}

