/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.event.matching;

import java.io.File;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Test;

public class LttngExperimentIndexingBenchmark {
    private static final String TEST_ID = "org.eclipse.tracecompass.lttng2.kernel#Experiment Indexing benchmark#";
    private static final String CPU = " (cpu usage)";
    private static final String TEST_SUMMARY = "Trace Compass scalabilty - Experiment indexing benchmark";

    public static void testIndexing(String directoryPath, int loopCount) {
        File parentDirectory = new File(directoryPath);
        if (!parentDirectory.isDirectory() || parentDirectory.list() == null) {
            System.err.println(String.format("Trace directory not found !\nYou need to setup the directory path for the LttngExperimentIndexingBenchmark class. See the javadoc of this class.", new Object[0]));
            return;
        }
        File[] filesList = parentDirectory.listFiles();
        int size = filesList.length;
        String testName = "Experiment of " + Integer.toString(size) + " traces";
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + CPU);
        perf.tagAsSummary(pm, "Trace Compass scalabilty - Experiment indexing benchmark:" + testName + CPU, Dimension.CPU_TIME);
        int j = 0;
        while (j < loopCount) {
            CtfTmfTrace[] traces = new CtfTmfTrace[size];
            int i = 0;
            File[] fileArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String path = String.valueOf(file.getAbsolutePath()) + "/kernel";
                CtfTmfTrace trace = new CtfTmfTrace();
                try {
                    trace.initTrace(null, path, CtfTmfEvent.class);
                }
                catch (TmfTraceException e) {
                    e.printStackTrace();
                    break;
                }
                traces[i] = trace;
                ++i;
                ++n2;
            }
            TmfExperiment experiment = new TmfExperiment(CtfTmfEvent.class, "Test experiment", (ITmfTrace[])traces, 5000, null);
            pm.start();
            experiment.indexTrace(true);
            pm.stop();
            experiment.dispose();
            ++j;
        }
        pm.commit();
    }

    @Test
    public void runTest() {
        int loopCount = 10;
        String directoryPath = "null";
        LttngExperimentIndexingBenchmark.testIndexing(directoryPath, loopCount);
    }
}

