/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.execgraph;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.building.TmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathModule;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraph;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfBenchmarkTrace;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KernelExecutionGraphBenchmark {
    public static final String TEST_ID = "org.eclipse.tracecompass#Kernel Execution Graph#";
    private static final String CRIT_PATH_TEST_ID = "org.eclipse.tracecompass#Critical Path#";
    private static final String TEST_BUILD = "Building Graph (%s)";
    private static final String TEST_MEMORY = "Memory Usage (%s)";
    private static final int LOOP_COUNT = 25;
    private RunMethod cpu = (pm, module) -> {
        pm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        pm.stop();
    };
    private RunMethod memory = (pm, module) -> {
        System.gc();
        pm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        System.gc();
        pm.stop();
    };
    private final int fLoopCount;
    private final String fFileTracePath;
    private final String fTestName;
    private final int fThreadId;
    private final @Nullable Integer fGraphWorkerCount;
    private final @Nullable Integer fCritPathWorkerCount;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() throws IOException {
        return Arrays.asList({"Trace2", 25, FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.TRACE2.getTraceURL())).getAbsolutePath(), 2203, 169, 27}, {"ManyThreads", 25, FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.MANY_THREADS.getTraceURL())).getAbsolutePath(), 2673, 8060, 5473}, {"Django", 25, FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.DJANGO_HTTPD.getTraceURL())).getAbsolutePath(), 1089, 138, 4}, {"OS Events", 10, CtfBenchmarkTrace.ALL_OS_ANALYSES.getTracePath().toString(), 21264, 394, 98});
    }

    public KernelExecutionGraphBenchmark(String name, int loopCount, String testTrace, int threadId, @Nullable Integer graphWorkerCount, @Nullable Integer critPathWorkerCount) {
        this.fLoopCount = loopCount;
        this.fFileTracePath = testTrace;
        this.fTestName = name;
        this.fThreadId = threadId;
        this.fGraphWorkerCount = graphWorkerCount;
        this.fCritPathWorkerCount = critPathWorkerCount;
    }

    @Test
    public void runMemoryBenchmarks() {
        this.runOneBenchmark(String.format(TEST_MEMORY, this.fTestName), this.memory, Dimension.USED_JAVA_HEAP, 1);
    }

    @Test
    public void runCpuBenchmarks() {
        this.runOneBenchmark(String.format(TEST_BUILD, this.fTestName), this.cpu, Dimension.CPU_TIME, this.fLoopCount);
    }

    private void runOneBenchmark(String testName, RunMethod method, Dimension dimension, int loopCount) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName);
        PerformanceMeter pmCritPath = perf.createPerformanceMeter(CRIT_PATH_TEST_ID + testName);
        perf.tagAsSummary(pm, "Execution graph " + testName, dimension);
        int i = 0;
        while (i < loopCount) {
            block14: {
                LttngKernelTrace trace = null;
                OsExecutionGraph module = null;
                try {
                    try {
                        trace = new LttngKernelTrace();
                        module = new OsExecutionGraph();
                        module.setId("test");
                        trace.initTrace(null, this.fFileTracePath, CtfTmfEvent.class);
                        module.setTrace((ITmfTrace)trace);
                        method.execute(pm, (IAnalysisModule)module);
                        if (this.fThreadId > 0) {
                            this.benchmarkCriticalPath(testName, method, pmCritPath, trace, module);
                        }
                        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                        File[] fileArray = suppDir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            file.delete();
                            ++n2;
                        }
                    }
                    catch (TmfAnalysisException | TmfTraceException e) {
                        Assert.fail((String)e.getMessage());
                        if (module != null) {
                            module.dispose();
                        }
                        if (trace != null) {
                            trace.dispose();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    if (trace != null) {
                        trace.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
                if (trace != null) {
                    trace.dispose();
                }
            }
            ++i;
        }
        pm.commit();
        pmCritPath.commit();
    }

    private void benchmarkCriticalPath(String testName, RunMethod method, PerformanceMeter pm, @NonNull LttngKernelTrace trace, OsExecutionGraph module) {
        block11: {
            CriticalPathModule critPathModule = null;
            try {
                try {
                    TmfGraph graph = module.getGraph();
                    Assert.assertNotNull((String)"Execution graph is null!", (Object)graph);
                    IGraphWorker worker = null;
                    if (this.fGraphWorkerCount != null) {
                        Assert.assertEquals((String)"Number of execution graph workers", (long)this.fGraphWorkerCount.intValue(), (long)graph.getWorkers().size());
                    } else {
                        System.out.println("Number of execution graph workers: " + graph.getWorkers().size());
                    }
                    for (IGraphWorker graphWorker : graph.getWorkers()) {
                        if (((OsWorker)graphWorker).getHostThread().getTid() != this.fThreadId) continue;
                        worker = graphWorker;
                    }
                    Assert.assertNotNull((String)("Requested worker for critical path not found: " + this.fThreadId), worker);
                    critPathModule = new CriticalPathModule((TmfGraphBuilderModule)module, worker);
                    critPathModule.setTrace((ITmfTrace)trace);
                    method.execute(pm, (IAnalysisModule)critPathModule);
                    TmfGraph criticalPath = critPathModule.getCriticalPath();
                    Assert.assertNotNull((String)"Critical path is null!", (Object)criticalPath);
                    if (this.fCritPathWorkerCount != null) {
                        Assert.assertEquals((String)"Number of critical path workers", (long)this.fCritPathWorkerCount.intValue(), (long)criticalPath.getWorkers().size());
                        break block11;
                    }
                    System.out.println("Number of critical path workers: " + criticalPath.getWorkers().size());
                }
                catch (TmfAnalysisException e) {
                    Assert.fail((String)e.getMessage());
                    if (critPathModule != null) {
                        critPathModule.dispose();
                    }
                }
            }
            finally {
                if (critPathModule != null) {
                    critPathModule.dispose();
                }
            }
        }
    }

    private static interface RunMethod {
        public void execute(PerformanceMeter var1, IAnalysisModule var2);
    }
}

