/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.ReusableViewerLabel;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class NavigatorContentServiceLabelProvider
extends EventManager
implements ILabelProvider,
IColorProvider,
IFontProvider,
ITreePathLabelProvider,
ITableLabelProvider,
ILabelProviderListener,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IToolTipProvider {
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;
    private final ReusableViewerLabel reusableLabel = new ReusableViewerLabel();

    public NavigatorContentServiceLabelProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public Image getImage(Object anElement) {
        return this.getColumnImage(anElement, -1);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Collection<NavigatorContentExtension> contentExtensions = this.contentService.findPossibleLabelExtensions(element);
        Image image = null;
        Iterator<NavigatorContentExtension> itr = contentExtensions.iterator();
        while (itr.hasNext() && image == null) {
            image = this.findImage(itr.next(), element, columnIndex);
        }
        return image;
    }

    public String getText(Object anElement) {
        return this.getColumnText(anElement, -1);
    }

    public String getColumnText(Object anElement, int aColumn) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        if (labelProviders.length == 0) {
            return NLS.bind((String)CommonNavigatorMessages.NavigatorContentServiceLabelProvider_Error_no_label_provider_for_0_, (Object)this.makeSmallString(anElement));
        }
        String text = null;
        ILabelProvider[] iLabelProviderArray = labelProviders;
        int n = labelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider labelProvider = iLabelProviderArray[n2];
            text = labelProvider instanceof ITableLabelProvider && aColumn != -1 ? ((ITableLabelProvider)labelProvider).getColumnText(anElement, aColumn) : labelProvider.getText(anElement);
            if (text != null && text.length() > 0) {
                return text;
            }
            ++n2;
        }
        return text;
    }

    public StyledString getStyledText(Object anElement) {
        Collection<NavigatorContentExtension> extensions = this.contentService.findPossibleLabelExtensions(anElement);
        if (extensions.isEmpty()) {
            return new StyledString(NLS.bind((String)CommonNavigatorMessages.NavigatorContentServiceLabelProvider_Error_no_label_provider_for_0_, (Object)this.makeSmallString(anElement)));
        }
        StyledString text = null;
        Iterator<NavigatorContentExtension> itr = extensions.iterator();
        while (itr.hasNext() && text == null) {
            text = this.findStyledText(itr.next(), anElement);
        }
        return text != null ? text : new StyledString();
    }

    private StyledString findStyledText(NavigatorContentExtension foundExtension, Object anElement) {
        ICommonLabelProvider labelProvider = foundExtension.getLabelProvider();
        if (labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            StyledString styledText = ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider).getStyledText(anElement);
            if (styledText != null && styledText.length() > 0) {
                return styledText;
            }
        } else {
            String text = labelProvider.getText(anElement);
            if (text != null && text.length() > 0) {
                return new StyledString(text);
            }
        }
        return null;
    }

    private String makeSmallString(Object obj) {
        String str;
        if (obj == null) {
            return "null";
        }
        int len = (str = obj.toString()).length();
        return str.substring(0, len < 50 ? len : 49);
    }

    private Image findImage(NavigatorContentExtension foundExtension, Object anElement, int aColumn) {
        Image image = null;
        ICommonLabelProvider provider = foundExtension.getLabelProvider();
        image = provider instanceof ITableLabelProvider && aColumn >= 0 ? ((ITableLabelProvider)provider).getColumnImage(anElement, aColumn) : provider.getImage(anElement);
        return image;
    }

    public Font getFont(Object anElement) {
        ILabelProvider[] labelProviders;
        ILabelProvider[] iLabelProviderArray = labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int n = labelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IFontProvider fontProvider;
            Font font;
            ILabelProvider provider = iLabelProviderArray[n2];
            if (provider instanceof IFontProvider && (font = (fontProvider = (IFontProvider)provider).getFont(anElement)) != null) {
                return font;
            }
            ++n2;
        }
        return null;
    }

    public Color getForeground(Object anElement) {
        ILabelProvider[] labelProviders;
        ILabelProvider[] iLabelProviderArray = labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int n = labelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IColorProvider colorProvider;
            Color color;
            ILabelProvider provider = iLabelProviderArray[n2];
            if (provider instanceof IColorProvider && (color = (colorProvider = (IColorProvider)provider).getForeground(anElement)) != null) {
                return color;
            }
            ++n2;
        }
        return null;
    }

    public Color getBackground(Object anElement) {
        ILabelProvider[] labelProviders;
        ILabelProvider[] iLabelProviderArray = labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int n = labelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IColorProvider colorProvider;
            Color color;
            ILabelProvider provider = iLabelProviderArray[n2];
            if (provider instanceof IColorProvider && (color = (colorProvider = (IColorProvider)provider).getBackground(anElement)) != null) {
                return color;
            }
            ++n2;
        }
        return null;
    }

    public String getToolTipText(Object anElement) {
        ILabelProvider[] labelProviders;
        ILabelProvider[] iLabelProviderArray = labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int n = labelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IToolTipProvider tooltipProvider;
            String tooltip;
            ILabelProvider provider = iLabelProviderArray[n2];
            if (provider instanceof IToolTipProvider && (tooltip = (tooltipProvider = (IToolTipProvider)provider).getToolTipText(anElement)) != null && !tooltip.isEmpty()) {
                return tooltip;
            }
            ++n2;
        }
        return null;
    }

    public boolean isLabelProperty(Object anElement, String aProperty) {
        boolean result = false;
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length && !result) {
            result = labelProviders[i].isLabelProperty(anElement, aProperty);
            ++i;
        }
        return result;
    }

    public void addListener(ILabelProviderListener aListener) {
        this.addListenerObject(aListener);
    }

    public void removeListener(ILabelProviderListener aListener) {
        this.removeListenerObject(aListener);
    }

    public void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ILabelProviderListener labelProviderListener = (ILabelProviderListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    labelProviderListener.labelProviderChanged(event);
                }
            });
            ++n2;
        }
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Collection<NavigatorContentExtension> contentExtensions = this.contentService.findPossibleLabelExtensions(elementPath.getLastSegment());
        this.reusableLabel.reset(label);
        Iterator<NavigatorContentExtension> itr = contentExtensions.iterator();
        while (!(!itr.hasNext() || this.reusableLabel.isValid() && this.reusableLabel.hasChanged())) {
            this.findUpdateLabel(itr.next(), this.reusableLabel, elementPath);
        }
        this.reusableLabel.fill(label);
    }

    private void findUpdateLabel(NavigatorContentExtension foundExtension, ReusableViewerLabel label, TreePath elementPath) {
        ICommonLabelProvider labelProvider = foundExtension.getLabelProvider();
        if (labelProvider instanceof ITreePathLabelProvider) {
            ITreePathLabelProvider tplp = (ITreePathLabelProvider)labelProvider;
            tplp.updateLabel((ViewerLabel)label, elementPath);
        } else {
            label.setImage(labelProvider.getImage(elementPath.getLastSegment()));
            label.setText(labelProvider.getText(elementPath.getLastSegment()));
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.fireLabelProviderChanged(event);
    }
}

