/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.internal.ui.RemoteUIPlugin;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;

public class RemoteConnectionsLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof IRemoteConnection) {
            IRemoteConnectionType type = ((IRemoteConnection)element).getConnectionType();
            IRemoteUIConnectionService uiService = (IRemoteUIConnectionService)type.getService(IRemoteUIConnectionService.class);
            if (uiService != null) {
                return uiService.getLabelProvider().getText(element);
            }
            return ((IRemoteConnection)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        IRemoteConnection connection;
        IRemoteConnectionType type;
        IRemoteUIConnectionService uiService;
        if (element instanceof IRemoteConnection && (uiService = (IRemoteUIConnectionService)(type = (connection = (IRemoteConnection)element).getConnectionType()).getService(IRemoteUIConnectionService.class)) != null) {
            final Image baseImage = uiService.getLabelProvider().getImage(element);
            if (connection.isOpen()) {
                return baseImage;
            }
            String closedId = "closed." + type.getId();
            Image closedImage = RemoteUIPlugin.getDefault().getImageRegistry().get(closedId);
            if (closedImage == null) {
                final Image errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
                CompositeImageDescriptor desc = new CompositeImageDescriptor(){

                    protected Point getSize() {
                        Rectangle bounds = baseImage.getBounds();
                        return new Point(bounds.width, bounds.height);
                    }

                    protected void drawCompositeImage(int width, int height) {
                        this.drawImage(baseImage.getImageData(), 0, 0);
                        int y = baseImage.getBounds().height - errorImage.getBounds().height;
                        this.drawImage(errorImage.getImageData(), 0, y);
                    }
                };
                closedImage = desc.createImage();
                RemoteUIPlugin.getDefault().getImageRegistry().put(closedId, closedImage);
            }
            return closedImage;
        }
        return super.getImage(element);
    }
}

