/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart;

import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotEclipseSwtChart;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.xychart.TmfChartView;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class XYChartViewTest {
    private static final Logger fLogger = Logger.getRootLogger();
    private SWTBotView fViewBot;
    private TmfTraceStub fTrace;
    private SWTWorkbenchBot fBot;
    private TmfXYChartViewer fXyViewer;
    private static final TmfTimeRange INITIAL_WINDOW_RANGE = new TmfTimeRange(TmfTimestamp.fromNanos((long)20L), TmfTimestamp.fromNanos((long)100L));

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
    }

    @Before
    public void before() throws TmfTraceException {
        this.fBot = new SWTWorkbenchBot();
        this.fBot.closeAllEditors();
        for (SWTBotView viewBot : this.fBot.views()) {
            viewBot.close();
        }
        this.fTrace = new TmfTraceStub(){

            public @NonNull String getName() {
                return "Stub";
            }

            public TmfContext seekEvent(ITmfLocation location) {
                return new TmfContext();
            }
        };
        this.fTrace.setStartTime(TmfTimestamp.fromNanos((long)0L));
        this.fTrace.setEndTime(TmfTimestamp.fromNanos((long)180L));
        TmfTraceStub trace = this.fTrace;
        trace.initialize(null, "", ITmfEvent.class);
        Assert.assertNotNull((Object)trace);
        UIThreadRunnable.syncExec(() -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null)));
        SWTBotUtils.openView("org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart.xystub");
        this.fViewBot = this.fBot.viewById("org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart.xystub");
        this.fViewBot.show();
        TmfChartView viewPart = (TmfChartView)this.fViewBot.getViewReference().getView(true);
        this.fXyViewer = viewPart.getChartViewer();
        this.fViewBot.bot().waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return XYChartViewTest.this.fXyViewer.getSwtChart() != null;
            }

            public String getFailureMessage() {
                return "SWT Chart is null";
            }
        });
        this.resetTimeRange();
    }

    @After
    public void after() {
        TmfTraceStub trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        UIThreadRunnable.syncExec(() -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, (ITmfTrace)trace)));
        this.fViewBot.close();
        this.fBot.waitUntil(ConditionHelpers.viewIsClosed(this.fViewBot));
        this.fTrace.dispose();
    }

    @AfterClass
    public static void afterClass() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        bot.closeAllEditors();
        fLogger.removeAllAppenders();
    }

    @Test
    public void testHorizontalZoom() {
        this.fViewBot.setFocus();
        Assert.assertEquals((long)80L, (long)this.fXyViewer.getWindowDuration());
        SWTBotEclipseSwtChart xyChart = new SWTBotEclipseSwtChart(this.fViewBot.bot());
        XYChartViewTest.fireKeyInGraph(xyChart, '=', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, 52L));
        XYChartViewTest.fireKeyInGraph(xyChart, '+', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, 34L));
        XYChartViewTest.fireKeyInGraph(xyChart, '-', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, 51L));
        XYChartViewTest.fireKeyInGraph(xyChart, '-', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, 77L));
        this.resetTimeRange();
        SWTBotToolbarButton button = this.fViewBot.toolbarButton("Zoom In");
        button.click();
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, 52L));
        button = this.fViewBot.toolbarButton("Zoom Out");
        button.click();
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, 78L));
        long previousRange = this.fXyViewer.getWindowDuration();
        XYChartViewTest.fireKeyInGraph(xyChart, 'w', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesUpdatedCondition(this.fXyViewer, previousRange, false));
        previousRange = this.fXyViewer.getWindowDuration();
        XYChartViewTest.fireKeyInGraph(xyChart, 's', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesUpdatedCondition(this.fXyViewer, previousRange, true));
    }

    @Test
    public void testZoomToSelection() {
        SWTBotEclipseSwtChart xyChart = new SWTBotEclipseSwtChart(this.fViewBot.bot());
        xyChart.setFocus();
        Assert.assertEquals((long)80L, (long)this.fXyViewer.getWindowDuration());
        ITmfTimestamp selStartTime = TmfTimestamp.fromNanos((long)30L);
        ITmfTimestamp selEndTime = TmfTimestamp.fromNanos((long)80L);
        final TmfTimeRange range = new TmfTimeRange(selStartTime, selEndTime);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, selStartTime, selEndTime));
        this.fViewBot.bot().waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return XYChartViewTest.this.fXyViewer.getSelectionEndTime() - XYChartViewTest.this.fXyViewer.getSelectionBeginTime() == XYChartViewTest.getDuration(range);
            }

            public String getFailureMessage() {
                return "SWT Chart is null";
            }
        });
        XYChartViewTest.fireKeyInGraph(xyChart, 'z', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, XYChartViewTest.getDuration(range)));
    }

    @Test
    public void testKeyboardNavigation() {
        SWTBotEclipseSwtChart xyChart = new SWTBotEclipseSwtChart(this.fViewBot.bot());
        xyChart.setFocus();
        Assert.assertEquals((long)80L, (long)this.fXyViewer.getWindowDuration());
        TmfTimeRange updatedWindowRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)40L), TmfTimestamp.fromNanos((long)120L));
        XYChartViewTest.fireKeyInGraph(xyChart, 'd', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, XYChartViewTest.getDuration(updatedWindowRange)));
        XYChartViewTest.fireKeyInGraph(xyChart, 'a', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, XYChartViewTest.getDuration(INITIAL_WINDOW_RANGE)));
    }

    private static void fireKeyInGraph(SWTBotEclipseSwtChart chart, char c, int ... modifiers) {
        chart.setFocus();
        chart.moveMouseToWidget();
        int mask = 0;
        int[] nArray = modifiers;
        int n = modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            int modifier = nArray[n2];
            mask |= modifier;
            ++n2;
        }
        chart.pressShortcut(mask, c);
    }

    private static long getDuration(TmfTimeRange range) {
        return range.getEndTime().getValue() - range.getStartTime().getValue();
    }

    private void resetTimeRange() {
        TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, INITIAL_WINDOW_RANGE);
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
        this.fViewBot.bot().waitUntil((ICondition)new SeriesCondition(this.fXyViewer, XYChartViewTest.getDuration(INITIAL_WINDOW_RANGE)));
    }

    private static class SeriesCondition
    extends DefaultCondition {
        private TmfXYChartViewer fViewer;
        private long fExpectedRange;
        private Exception fExecption = null;

        public SeriesCondition(TmfXYChartViewer view, long expectedRange) {
            this.fViewer = view;
            this.fExpectedRange = expectedRange;
        }

        public boolean test() throws Exception {
            ISeriesSet set;
            block3: {
                try {
                    Chart chart = this.fViewer.getSwtChart();
                    set = chart.getSeriesSet();
                    if (set != null) break block3;
                    return false;
                }
                catch (Exception e) {
                    this.fExecption = e;
                    throw e;
                }
            }
            ISeries[] series = set.getSeries();
            return series != null && series.length > 0 && this.fExpectedRange == this.fViewer.getWindowDuration();
        }

        public String getFailureMessage() {
            return "Expected window range (" + this.fExpectedRange + ") not achieved. Actual=" + this.fViewer.getWindowDuration() + (this.fExecption == null ? "" : ". Exception: " + this.fExecption);
        }
    }

    private class SeriesUpdatedCondition
    extends DefaultCondition {
        TmfXYChartViewer fView;
        long fPreviousRange;
        boolean fIsIncreased;
        private Exception fExecption = null;

        public SeriesUpdatedCondition(TmfXYChartViewer view, long previousRange, boolean increased) {
            this.fView = view;
            this.fPreviousRange = previousRange;
            this.fIsIncreased = increased;
        }

        public boolean test() throws Exception {
            block6: {
                ISeriesSet set;
                block5: {
                    try {
                        Chart chart = this.fView.getSwtChart();
                        set = chart.getSeriesSet();
                        if (set != null) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        this.fExecption = e;
                        throw e;
                    }
                }
                ISeries[] series = set.getSeries();
                if (series != null) break block6;
                return false;
            }
            long newRange = this.fView.getWindowDuration();
            if (this.fIsIncreased) {
                return newRange > this.fPreviousRange;
            }
            return newRange < this.fPreviousRange;
        }

        public String getFailureMessage() {
            return "Window range didn't " + (this.fIsIncreased ? "increase" : "decrease") + " (previous: " + this.fPreviousRange + ", actual: " + this.fView.getWindowDuration() + ")" + (this.fExecption == null ? "" : ". Exception: " + this.fExecption);
        }
    }
}

