/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.StubEventMatching;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.junit.Assert;
import org.junit.Test;

public class EventMatchingTest {
    private static @NonNull ITmfTrace getKernelXmlTrace(String traceFile) throws TmfTraceException {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(traceFile);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        trace.initTrace(null, filePath.toOSString(), ITmfEvent.class);
        return trace;
    }

    @Test
    public void testMatching() throws TmfTraceException {
        String trace1File = "client.xml";
        String trace2File = "server.xml";
        this.testEventMatching(trace1File, trace2File);
    }

    private static void validateMatch(TmfEventDependency match, String source, String destination, long sourceTs, long destTs) {
        String title = String.valueOf(source) + '(' + sourceTs + ") -> " + destination + '(' + destTs + ')';
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((String)("Source: " + title), (Object)source, (Object)match.getSource().getTrace().getHostId());
        Assert.assertEquals((String)("Source ts: " + title), (long)sourceTs, (long)match.getSource().getTimestamp().getValue());
        Assert.assertEquals((String)("Destination: " + title), (Object)destination, (Object)match.getDestination().getTrace().getHostId());
        Assert.assertEquals((String)("Destination ts: " + title), (long)destTs, (long)match.getDestination().getTimestamp().getValue());
    }

    @Test
    public void testMatchingMultiMatchers() throws TmfTraceException {
        String trace1File = "client.xml";
        String trace2File = "server2.xml";
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new StubEventMatching(){

            @Override
            public @Nullable IEventMatchingKey getEventKey(@Nullable ITmfEvent event) {
                if (event == null) {
                    return null;
                }
                Integer fieldValue = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"otherMsgField"});
                if (fieldValue == null) {
                    return null;
                }
                return new StubEventMatching.StubEventKey(fieldValue);
            }
        });
        this.testEventMatching(trace1File, trace2File);
    }

    private void testEventMatching(String trace1File, String trace2File) throws TmfTraceException {
        ITmfTrace trace1 = null;
        ITmfTrace trace2 = null;
        TmfExperiment experiment = null;
        try {
            trace1 = EventMatchingTest.getKernelXmlTrace("testfiles/network/" + trace1File);
            trace2 = EventMatchingTest.getKernelXmlTrace("testfiles/network/" + trace2File);
            ITmfTrace[] traces = new ITmfTrace[]{trace1, trace2};
            experiment = new TmfExperiment(ITmfEvent.class, "experiment", traces, 1000, null);
            experiment.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null));
            TestMatchPu testMatchPu = new TestMatchPu();
            TmfEventMatching twoTraceMatch = new TmfEventMatching(Collections.singleton(experiment), (IMatchProcessingUnit)testMatchPu);
            Assert.assertTrue((boolean)twoTraceMatch.matchEvents());
            List<TmfEventDependency> matches = testMatchPu.getMatches();
            Assert.assertEquals((long)4L, (long)matches.size());
            EventMatchingTest.validateMatch(matches.get(0), trace1File, trace1File, 15L, 20L);
            EventMatchingTest.validateMatch(matches.get(1), trace1File, trace2File, 30L, 50L);
            EventMatchingTest.validateMatch(matches.get(2), trace2File, trace1File, 70L, 100L);
            EventMatchingTest.validateMatch(matches.get(3), trace1File, trace1File, 105L, 115L);
        }
        finally {
            if (experiment != null) {
                experiment.dispose();
            }
            if (trace1 != null) {
                trace1.dispose();
            }
            if (trace2 != null) {
                trace2.dispose();
            }
        }
    }

    private static class TestMatchPu
    implements IMatchProcessingUnit {
        private List<TmfEventDependency> fMatches = new ArrayList<TmfEventDependency>();

        private TestMatchPu() {
        }

        public void init(@NonNull Collection<@NonNull ITmfTrace> fTraces) {
        }

        public void addMatch(@NonNull TmfEventDependency match) {
            this.fMatches.add(match);
        }

        public void matchingEnded() {
        }

        public int countMatches() {
            return this.fMatches.size();
        }

        public List<TmfEventDependency> getMatches() {
            return this.fMatches;
        }
    }
}

