/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMember;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalID;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUnary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;

public class HeuristicResolver {
    public static IScope findConcreteScopeForType(IType type) {
        if (type instanceof ICPPUnknownType) {
            type = HeuristicResolver.resolveUnknownType((ICPPUnknownType)type, 13);
        }
        if ((type = SemanticUtil.getNestedType(type, 32)) instanceof ICompositeType) {
            return ((ICompositeType)type).getCompositeScope();
        }
        if (type instanceof ICPPEnumeration) {
            return ((ICPPEnumeration)type).asScope();
        }
        return null;
    }

    private static IBinding[] specializeBindings(IBinding[] bindings, ICPPClassSpecialization context) {
        IBinding[] result = new IBinding[bindings.length];
        int i = 0;
        while (i < bindings.length) {
            result[i] = context.specializeMember(bindings[i]);
            ++i;
        }
        return result;
    }

    private static IBinding[] lookInside(IType ownerType, boolean isPointerDeref, char[] name, ICPPTemplateArgument[] templateArgs, Set<HeuristicLookup> lookupSet) {
        HeuristicLookup entry;
        ownerType = SemanticUtil.getSimplifiedType(ownerType);
        if (isPointerDeref && ownerType instanceof IPointerType) {
            ownerType = ((IPointerType)ownerType).getType();
            isPointerDeref = false;
        }
        if (ownerType instanceof IQualifierType) {
            ownerType = ((IQualifierType)ownerType).getType();
        }
        IType lookupType = ownerType;
        ICPPClassSpecialization specializationContext = null;
        if (lookupType instanceof ICPPUnknownType) {
            while (true) {
                if (lookupType instanceof ICPPClassSpecialization) {
                    specializationContext = (ICPPClassSpecialization)lookupType;
                    lookupType = specializationContext.getSpecializedBinding();
                    break;
                }
                if (lookupType instanceof ICPPDeferredClassInstance) {
                    specializationContext = new CPPDependentClassInstance((ICPPDeferredClassInstance)lookupType);
                    lookupType = specializationContext.getSpecializedBinding();
                    break;
                }
                IType resolvedType = HeuristicResolver.resolveUnknownTypeOnce((ICPPUnknownType)lookupType, lookupSet);
                resolvedType = SemanticUtil.getNestedType(resolvedType, 13);
                if (isPointerDeref) {
                    if (resolvedType instanceof IPointerType) {
                        isPointerDeref = false;
                        resolvedType = ((IPointerType)resolvedType).getType();
                    } else {
                        resolvedType = null;
                    }
                }
                if ((resolvedType = SemanticUtil.getNestedType(resolvedType, 9)) == lookupType || !(resolvedType instanceof ICPPUnknownType)) {
                    lookupType = resolvedType;
                    break;
                }
                lookupType = resolvedType;
            }
        }
        IScope lookupScope = null;
        if (lookupType instanceof ICPPClassType) {
            lookupScope = ((ICPPClassType)lookupType).getCompositeScope();
        } else if (lookupType instanceof ICPPEnumeration) {
            lookupScope = ((ICPPEnumeration)lookupType).asScope();
        }
        if (lookupScope != null && lookupSet.add(entry = new HeuristicLookup(lookupScope, name))) {
            LookupData lookup = new LookupData(name, templateArgs, CPPSemantics.getCurrentLookupPoint());
            lookup.fHeuristicBaseLookup = true;
            try {
                CPPSemantics.lookup(lookup, lookupScope);
                IBinding[] foundBindings = lookup.getFoundBindings();
                if (foundBindings.length > 0) {
                    if (specializationContext != null) {
                        foundBindings = HeuristicResolver.specializeBindings(foundBindings, specializationContext);
                    }
                    return foundBindings;
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    private static IType typeForBinding(IBinding binding) {
        if (binding instanceof IType) {
            return (IType)((Object)binding);
        }
        if (binding instanceof IVariable) {
            return ((IVariable)binding).getType();
        }
        if (binding instanceof IEnumerator) {
            return ((IEnumerator)binding).getType();
        }
        if (binding instanceof IFunction) {
            return ((IFunction)binding).getType();
        }
        return null;
    }

    public static IType resolveUnknownType(ICPPUnknownType type) {
        return HeuristicResolver.resolveUnknownType(type, 9);
    }

    private static IType resolveUnknownType(ICPPUnknownType type, int unwrapOptions) {
        IType resolvedType;
        while (true) {
            HashSet<HeuristicLookup> lookupSet = new HashSet<HeuristicLookup>();
            resolvedType = HeuristicResolver.resolveUnknownTypeOnce(type, lookupSet);
            if ((resolvedType = SemanticUtil.getNestedType(resolvedType, unwrapOptions)) == type || !(resolvedType instanceof ICPPUnknownType)) break;
            type = (ICPPUnknownType)resolvedType;
        }
        return resolvedType;
    }

    private static ICPPClassTemplate chooseTemplateForDeferredInstance(ICPPDeferredClassInstance instance) {
        ICPPClassTemplate template = instance.getClassTemplate();
        if (!instance.isExplicitSpecialization()) {
            try {
                IBinding partial = CPPTemplates.selectSpecialization(template, instance.getTemplateArguments(), false);
                if (partial != null && partial instanceof ICPPTemplateInstance) {
                    return (ICPPClassTemplate)((ICPPTemplateInstance)partial).getTemplateDefinition();
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return template;
    }

    private static IType resolveEvalType(ICPPEvaluation evaluation, Set<HeuristicLookup> lookupSet) {
        if (evaluation instanceof EvalUnary) {
            IType resolved;
            IType argument;
            EvalUnary unary = (EvalUnary)evaluation;
            if (unary.getOperator() == 4 && (argument = unary.getArgument().getType()) instanceof ICPPUnknownType && (resolved = HeuristicResolver.resolveUnknownType((ICPPUnknownType)argument)) instanceof IPointerType) {
                return ((IPointerType)resolved).getType();
            }
        } else if (evaluation instanceof EvalID) {
            IType fieldOwnerType;
            IBinding[] candidates;
            EvalID id = (EvalID)evaluation;
            ICPPEvaluation fieldOwner = id.getFieldOwner();
            if (fieldOwner != null && (candidates = HeuristicResolver.lookInside(fieldOwnerType = fieldOwner.getType(), id.isPointerDeref(), id.getName(), id.getTemplateArgs(), lookupSet)).length > 0) {
                return HeuristicResolver.typeForBinding(candidates[0]);
            }
        } else {
            if (evaluation instanceof EvalFunctionCall) {
                EvalFunctionCall evalFunctionCall = (EvalFunctionCall)evaluation;
                ICPPEvaluation function = evalFunctionCall.getArguments()[0];
                IType functionType = function.getType();
                if (functionType instanceof ICPPUnknownType) {
                    functionType = HeuristicResolver.resolveUnknownType((ICPPUnknownType)functionType);
                }
                return ExpressionTypes.typeFromFunctionCall(functionType);
            }
            if (evaluation instanceof EvalMemberAccess) {
                IBinding member = ((EvalMemberAccess)evaluation).getMember();
                return HeuristicResolver.typeForBinding(member);
            }
            if (evaluation instanceof EvalTypeId) {
                EvalTypeId evalTypeId = (EvalTypeId)evaluation;
                IType result = evalTypeId.getInputType();
                if (evalTypeId.representsNewExpression()) {
                    result = new CPPPointerType(result);
                }
                return result;
            }
            if (evaluation instanceof EvalBinding) {
                return evaluation.getType();
            }
        }
        return null;
    }

    private static IType resolveUnknownTypeOnce(ICPPUnknownType type, Set<HeuristicLookup> lookupSet) {
        ICPPUnknownMemberClass member;
        IType ownerType;
        IBinding[] candidates;
        if (type instanceof ICPPDeferredClassInstance) {
            ICPPDeferredClassInstance deferredInstance = (ICPPDeferredClassInstance)type;
            return HeuristicResolver.chooseTemplateForDeferredInstance(deferredInstance);
        }
        if (type instanceof TypeOfDependentExpression) {
            ICPPEvaluation evaluation = ((TypeOfDependentExpression)type).getEvaluation();
            return HeuristicResolver.resolveEvalType(evaluation, lookupSet);
        }
        if (type instanceof ICPPUnknownMemberClass && (candidates = HeuristicResolver.lookInside(ownerType = (member = (ICPPUnknownMemberClass)type).getOwnerType(), false, member.getNameCharArray(), null, lookupSet)).length == 1 && candidates[0] instanceof IType) {
            IType result = (IType)((Object)candidates[0]);
            if (type instanceof ICPPUnknownMemberClassInstance) {
                ICPPTemplateArgument[] args = ((ICPPUnknownMemberClassInstance)type).getArguments();
                if (result instanceof ICPPClassTemplate) {
                    result = (IType)((Object)CPPTemplates.instantiate((ICPPClassTemplate)result, args));
                } else if (result instanceof ICPPAliasTemplate) {
                    result = (IType)((Object)CPPTemplates.instantiateAliasTemplate((ICPPAliasTemplate)result, args));
                }
            }
            return result;
        }
        return null;
    }

    public static IBinding[] resolveUnknownBinding(ICPPUnknownBinding binding) {
        IType resolved;
        if (binding instanceof ICPPDeferredClassInstance) {
            return new IBinding[]{HeuristicResolver.chooseTemplateForDeferredInstance((ICPPDeferredClassInstance)binding)};
        }
        if (binding instanceof ICPPUnknownMember) {
            HashSet<HeuristicLookup> lookupSet = new HashSet<HeuristicLookup>();
            return HeuristicResolver.lookInside(((ICPPUnknownMember)binding).getOwnerType(), false, binding.getNameCharArray(), null, lookupSet);
        }
        if (binding instanceof ICPPUnknownType && (resolved = HeuristicResolver.resolveUnknownType((ICPPUnknownType)((Object)binding))) != binding && resolved instanceof IBinding) {
            return new IBinding[]{(IBinding)((Object)resolved)};
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    private static class CPPDependentClassInstance
    extends CPPDeferredClassInstance
    implements ICPPClassSpecialization {
        public CPPDependentClassInstance(ICPPDeferredClassInstance deferredInstance) {
            super(HeuristicResolver.chooseTemplateForDeferredInstance(deferredInstance), deferredInstance.getTemplateArguments());
        }

        @Override
        public ICPPClassType getSpecializedBinding() {
            return (ICPPClassType)super.getSpecializedBinding();
        }

        @Override
        @Deprecated
        public IBinding specializeMember(IBinding binding, IASTNode point) {
            return this.specializeMember(binding);
        }

        @Override
        public IBinding specializeMember(IBinding binding) {
            return CPPTemplates.createSpecialization(this, binding);
        }

        @Override
        public ICPPBase[] getBases(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICPPConstructor[] getConstructors(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICPPField[] getDeclaredFields(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICPPMethod[] getMethods(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICPPMethod[] getAllDeclaredMethods(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICPPMethod[] getDeclaredMethods(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IBinding[] getFriends(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IField[] getFields(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICPPClassType[] getNestedClasses(IASTNode point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICPPUsingDeclaration[] getUsingDeclarations(IASTNode point) {
            throw new UnsupportedOperationException();
        }
    }

    private static class HeuristicLookup {
        public IScope scope;
        public char[] name;

        public HeuristicLookup(IScope scope, char[] name) {
            this.scope = scope;
            this.name = name;
        }

        public boolean equals(Object other) {
            if (!(other instanceof HeuristicLookup)) {
                return false;
            }
            HeuristicLookup otherLookup = (HeuristicLookup)other;
            return this.scope == otherLookup.scope && CharArrayUtils.equals(this.name, otherLookup.name);
        }

        public int hashCode() {
            return this.scope.hashCode() * (29 + this.name.hashCode());
        }
    }
}

