/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;

public class TmfXyModel
implements ITmfXyModel {
    @SerializedName(value="title")
    private final String fTitle;
    @SerializedName(value="series")
    private final Collection<ISeriesModel> fSeries;

    @Deprecated
    public TmfXyModel(String title, Map<String, ISeriesModel> series) {
        this.fTitle = title;
        this.fSeries = ImmutableList.copyOf(series.values());
    }

    public TmfXyModel(String title, Collection<ISeriesModel> series) {
        this.fTitle = title;
        this.fSeries = ImmutableList.copyOf(series);
    }

    @Override
    public @Nullable String getTitle() {
        return this.fTitle;
    }

    @Override
    @Deprecated
    public Map<String, ISeriesModel> getData() {
        return Maps.uniqueIndex(this.fSeries, series -> series.getName());
    }

    @Override
    public @NonNull Collection<@NonNull ISeriesModel> getSeriesData() {
        return this.fSeries;
    }

    @Override
    public boolean hasCommonXAxis() {
        return false;
    }
}

