/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliCommandLine;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliOption;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliParserException;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.ICliParser;
import org.eclipse.tracecompass.internal.tmf.cli.core.Activator;
import org.eclipse.tracecompass.internal.tmf.cli.core.parser.CliParserConfigElement;
import org.eclipse.tracecompass.internal.tmf.cli.core.parser.Messages;

public final class CliParserManager {
    private static final String CLI_ARGS_PREFIX = "--cli";
    private static @Nullable CliParserManager INSTANCE = null;
    private final Options fOptions;

    private CliParserManager() {
        Collection<@NonNull ICliParser> cliParsers = CliParserManager.getCliParsers();
        Options options = new Options();
        for (ICliParser parser : cliParsers) {
            for (CliOption option : parser.getCmdLineOptions()) {
                options.addOption(option.toCliOption());
            }
        }
        this.fOptions = options;
    }

    public static synchronized CliParserManager getInstance() {
        CliParserManager instance = INSTANCE;
        if (instance == null) {
            INSTANCE = instance = new CliParserManager();
        }
        return instance;
    }

    public static Collection<ICliParser> getCliParsers() {
        return CliParserConfigElement.getInstance().getParsers();
    }

    public @Nullable CliCommandLine parse(String[] args) throws CliParserException {
        ArrayList<String> tcArgs = new ArrayList<String>();
        boolean found = false;
        boolean addNext = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equals(CLI_ARGS_PREFIX)) {
                found = true;
            } else if (found) {
                tcArgs.add(arg);
            } else if (arg.equals("--open")) {
                System.out.println(Messages.CliParser_WarningCliPrefix);
                tcArgs.add(arg);
                addNext = true;
            } else if (addNext) {
                tcArgs.add(arg);
                addNext = false;
            }
            ++n2;
        }
        if (tcArgs.isEmpty()) {
            return null;
        }
        PosixParser cmdLineParser = new PosixParser();
        try {
            CommandLine cmdLine = cmdLineParser.parse(this.fOptions, tcArgs.toArray(new String[tcArgs.size()]), false);
            if (cmdLine != null) {
                CliCommandLine cliCommandLine = new CliCommandLine(cmdLine);
                return cliCommandLine;
            }
        }
        catch (ParseException e) {
            System.out.println(Messages.CliParser_ErrorParsingArguments);
            System.out.println((Object)e);
            System.out.println();
            this.printHelpText();
            throw new CliParserException(String.valueOf(e.getMessage()));
        }
        return null;
    }

    public void printHelpText() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(Messages.CliParser_HelpTextIntro, this.fOptions);
    }

    public static boolean applicationStartup(CliCommandLine commandLine) {
        boolean optionsHandled = false;
        for (ICliParser parser : CliParserManager.getCliParsers()) {
            optionsHandled |= parser.preStartup(commandLine);
        }
        return optionsHandled;
    }

    public static Job getWorkspaceLoadingJob(CliCommandLine commandLine) {
        return new ExecuteCliParsersJob(commandLine);
    }

    private static class ExecuteCliParsersJob
    extends Job {
        private final CliCommandLine fCommandLine;

        public ExecuteCliParsersJob(CliCommandLine commandLine) {
            super("Executing CLI parser");
            this.fCommandLine = commandLine;
        }

        protected IStatus run(@Nullable IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            Collection<ICliParser> cliParsers = CliParserManager.getCliParsers();
            subMonitor.beginTask("Executing CLI Parsers", cliParsers.size());
            for (ICliParser parser : cliParsers) {
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                subMonitor.subTask("Executing parser :" + parser.getCmdLineOptions().toString());
                IStatus status = parser.workspaceLoading(this.fCommandLine, (IProgressMonitor)subMonitor);
                if (status.isOK()) continue;
                Activator.getInstance().getLog().log(status);
            }
            return Status.OK_STATUS;
        }
    }
}

