/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenAnalysisModule;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class TmfXmlConditionTest {
    private static final @NonNull String testTrace2 = "test_traces/testTrace2.xml";
    private static final @NonNull String testTrace4 = "test_traces/testTrace4.xml";

    @Test
    public void testConditionsValidation() {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(testTrace2);
        DataDrivenAnalysisModule module = XmlUtilsTest.initializeModule(TmfXmlTestFiles.CONDITION_FILE);
        try {
            try {
                module.setTrace(trace);
                module.schedule();
                module.waitForCompletion();
                ITmfStateSystem ss = module.getStateSystem();
                Assert.assertNotNull((Object)ss);
                List quarks = ss.getQuarks(new String[]{"*"});
                Assert.assertEquals((long)5L, (long)quarks.size());
                for (Integer quark : quarks) {
                    String name;
                    switch (name = ss.getAttributeName(quark.intValue())) {
                        case "test": {
                            int[] expectedStarts = new int[]{1, 5, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueLong((long)1L), TmfStateValue.newValueLong((long)0L)};
                            XmlUtilsTest.verifyStateIntervals("test", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        case "test1": {
                            int[] expectedStarts = new int[]{1, 3, 7, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueLong((long)0L), TmfStateValue.newValueLong((long)1L)};
                            XmlUtilsTest.verifyStateIntervals("test1", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        case "checkpoint": {
                            int[] expectedStarts = new int[]{1, 5, 7, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueLong((long)0L), TmfStateValue.newValueLong((long)1L), TmfStateValue.newValueLong((long)0L)};
                            XmlUtilsTest.verifyStateIntervals("checkpoint", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        case "and_three_operands": {
                            int[] expectedStarts = new int[]{1, 5, 7, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueLong((long)1L), TmfStateValue.newValueLong((long)0L), TmfStateValue.newValueLong((long)1L)};
                            XmlUtilsTest.verifyStateIntervals("and_three_operands", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        case "not_operand": {
                            int[] expectedStarts = new int[]{1, 5, 7, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueLong((long)0L), TmfStateValue.newValueLong((long)1L), TmfStateValue.newValueLong((long)0L)};
                            XmlUtilsTest.verifyStateIntervals("not_operand", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        default: {
                            Assert.fail((String)("Wrong attribute name " + name));
                        }
                    }
                }
            }
            catch (AttributeNotFoundException | StateSystemDisposedException | TmfAnalysisException e) {
                Assert.fail((String)e.getMessage());
                module.dispose();
                trace.dispose();
            }
        }
        finally {
            module.dispose();
            trace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testConditionsPattern() {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(testTrace4);
        XmlPatternAnalysis module = XmlUtilsTest.initializePatternModule(TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE);
        try {
            try {
                module.setTrace(trace);
                module.schedule();
                module.waitForCompletion();
                @NonNull ISegmentStore segmentStore = module.getSegmentStore();
                Assert.assertNotNull((Object)segmentStore);
                Assert.assertEquals((long)1L, (long)segmentStore.size());
                Iterator<@NonNull T> elements = segmentStore.getIntersectingElements(6L).iterator();
                Assert.assertTrue((boolean)elements.hasNext());
                ISegment next = (ISegment)elements.next();
                Assert.assertEquals((long)5L, (long)next.getStart());
                Assert.assertEquals((long)2L, (long)next.getLength());
            }
            catch (TmfAnalysisException e) {
                Assert.fail((String)e.getMessage());
                module.dispose();
                trace.dispose();
            }
        }
        finally {
            module.dispose();
            trace.dispose();
        }
    }
}

