/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public class ScopeSet {
    public static final String SCOPE_DIR_NAME = "scope_sets";
    private static final String KEY_DEFAULT = "__DEFAULT__";
    public static final String EXT = ".pref";
    private String name;
    private PreferenceStore preferenceStore;
    private boolean needsSaving = true;
    private int defaultSet = -1;

    public ScopeSet() {
        this(Messages.ScopeSet_default);
        this.defaultSet = 1;
    }

    public ScopeSet(String name) {
        this.name = name;
    }

    public boolean isEditable() {
        return !this.isDefault();
    }

    public boolean isDefault() {
        if (this.defaultSet == 1) {
            return true;
        }
        return this.getPreferenceStore().getBoolean(KEY_DEFAULT);
    }

    public boolean isImplicit() {
        return false;
    }

    public ScopeSet(ScopeSet set, String name) {
        this(name);
        this.copyFrom(set);
    }

    public void copyFrom(ScopeSet set) {
        this.copy((PreferenceStore)set.getPreferenceStore());
    }

    public void dispose() {
        File file = new File(this.getFileName(this.name));
        if (file.exists()) {
            file.delete();
        }
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new PreferenceStore(this.getFileName(this.name));
            try {
                File file = new File(this.getFileName(this.name));
                if (file.exists()) {
                    this.preferenceStore.load();
                }
            }
            catch (IOException e) {
                String message = Messages.bind((String)Messages.ScopeSet_errorLoading, (Object)this.name);
                Platform.getLog(this.getClass()).error(message, (Throwable)e);
            }
        }
        return this.preferenceStore;
    }

    protected String encodeFileName(String name) {
        return name;
    }

    private String getFileName(String name) {
        IPath location = HelpUIPlugin.getDefault().getStateLocation();
        location = location.append(SCOPE_DIR_NAME);
        location = location.append(String.valueOf(this.encodeFileName(name)) + this.getExtension());
        return location.toOSString();
    }

    protected String getExtension() {
        return EXT;
    }

    private void copy(PreferenceStore store) {
        try {
            File file = File.createTempFile("sset", null);
            FileOutputStream fos = new FileOutputStream(file);
            store.save((OutputStream)fos, "");
            fos.close();
            FileInputStream fis = new FileInputStream(file);
            this.getPreferenceStore();
            this.preferenceStore.load((InputStream)fis);
            this.preferenceStore.setValue(KEY_DEFAULT, false);
            fis.close();
        }
        catch (IOException iOException) {}
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldFileName = this.getFileName(this.name);
        File oldFile = new File(oldFileName);
        if (oldFile.exists()) {
            if (this.preferenceStore == null) {
                oldFile.renameTo(new File(this.getFileName(name)));
            } else {
                oldFile.delete();
            }
        }
        if (this.preferenceStore != null) {
            this.preferenceStore.setFilename(this.getFileName(name));
            try {
                this.preferenceStore.save();
            }
            catch (IOException e) {
                String message = Messages.bind((String)Messages.ScopeSet_errorSaving, (Object)name);
                Platform.getLog(this.getClass()).error(message, (Throwable)e);
            }
        }
        this.name = name;
    }

    public void save() {
        this.getPreferenceStore();
        if (this.preferenceStore.needsSaving() || this.needsSaving) {
            try {
                if (this.defaultSet != -1) {
                    this.preferenceStore.setValue(KEY_DEFAULT, this.defaultSet > 0);
                }
                this.preferenceStore.save();
                this.needsSaving = false;
            }
            catch (IOException e) {
                String message = Messages.bind((String)Messages.ScopeSet_errorSaving, (Object)this.name);
                Platform.getLog(this.getClass()).error(message, (Throwable)e);
            }
        }
    }

    public boolean getEngineEnabled(EngineDescriptor desc) {
        String key;
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains(key = ScopeSet.getMasterKey(desc.getId()))) {
            return store.getBoolean(key);
        }
        store.setValue(key, desc.isEnabled());
        return desc.isEnabled();
    }

    public void setEngineEnabled(EngineDescriptor desc, boolean value) {
        IPreferenceStore store = this.getPreferenceStore();
        String key = ScopeSet.getMasterKey(desc.getId());
        store.setValue(key, value);
    }

    public static String getMasterKey(String id) {
        return String.valueOf(id) + ".master";
    }

    public static String getLabelKey(String id) {
        return String.valueOf(id) + ".label";
    }

    public static String getDescKey(String id) {
        return String.valueOf(id) + ".desc";
    }
}

