/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xychart;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.viewers.xychart.BaseXYPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.ui.util.SymbolHelper;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider2;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfCommonXAxisChartViewer;

public class XYChartLegendImageProvider
implements ILegendImageProvider2 {
    private static final @NonNull RGBAColor DEFAULT_COLOR = new RGBAColor(255, 255, 255);
    private static final int DEFAULT_SYMBOL_SIZE = 4;
    private final TmfCommonXAxisChartViewer fChartViewer;

    public XYChartLegendImageProvider(TmfCommonXAxisChartViewer chartViewer) {
        this.fChartViewer = chartViewer;
    }

    @Override
    public Image getLegendImage(int imageHeight, int imageWidth, @NonNull Long id) {
        OutputElementStyle appearance = this.fChartViewer.getSeriesStyle(id);
        BaseXYPresentationProvider presProvider = this.fChartViewer.getPresentationProvider();
        RGBAColor rgb = presProvider.getColorStyleOrDefault(appearance, "color", DEFAULT_COLOR);
        Color lineColor = new Color((Device)Display.getDefault(), (int)rgb.getRed(), (int)rgb.getGreen(), (int)rgb.getBlue());
        Color background = Display.getDefault().getSystemColor(1);
        PaletteData palette = new PaletteData(new RGB[]{background.getRGB(), lineColor.getRGB()});
        ImageData imageData = new ImageData(imageWidth, imageHeight, 8, palette);
        imageData.transparentPixel = 0;
        Image image = new Image((Device)Display.getDefault(), imageData);
        GC gc = new GC((Drawable)image);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, imageWidth, imageHeight);
        this.drawStyleLine(gc, lineColor, imageWidth, imageHeight, appearance);
        this.drawStyledDot(gc, lineColor, imageWidth, imageHeight, appearance);
        gc.dispose();
        lineColor.dispose();
        return image;
    }

    private void drawStyleLine(GC gc, Color lineColor, int imageWidth, int imageHeight, @NonNull OutputElementStyle appearance) {
        Color prev = gc.getForeground();
        BaseXYPresentationProvider presProvider = this.fChartViewer.getPresentationProvider();
        LineStyle lineStyle = LineStyle.valueOf((String)((String)presProvider.getStyleOrDefault(appearance, "series-style", "SOLID")));
        if (lineStyle != LineStyle.NONE) {
            gc.setForeground(lineColor);
            gc.setLineWidth(((Number)presProvider.getFloatStyleOrDefault(appearance, "width", Float.valueOf(1.0f))).intValue());
            gc.setLineStyle(lineStyle.ordinal());
            gc.drawLine(0, imageHeight / 2, imageWidth, imageHeight / 2);
            gc.setForeground(prev);
        }
    }

    private void drawStyledDot(GC gc, Color lineColor, int imageWidth, int imageHeight, @NonNull OutputElementStyle appearance) {
        BaseXYPresentationProvider presProvider = this.fChartViewer.getPresentationProvider();
        String symbolStyle = (String)presProvider.getStyleOrDefault(appearance, "symbol-type", "none");
        int symbolSize = Math.round(presProvider.getFloatStyleOrDefault(appearance, "height", Float.valueOf(1.0f)).floatValue() * 4.0f);
        int centerX = imageWidth / 2;
        int centerY = imageHeight / 2;
        Color prevBg = gc.getBackground();
        Color prevFg = gc.getForeground();
        switch (symbolStyle) {
            case "circle": {
                SymbolHelper.drawCircle(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "diamond": {
                SymbolHelper.drawDiamond(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "square": {
                SymbolHelper.drawSquare(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "cross": {
                SymbolHelper.drawCross(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "plus": {
                SymbolHelper.drawPlus(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "inverted-triangle": {
                SymbolHelper.drawInvertedTriangle(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "triangle": {
                SymbolHelper.drawTriangle(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
        }
        gc.setForeground(prevFg);
        gc.setBackground(prevBg);
    }
}

