/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class EvalBinding
extends CPPDependentEvaluation {
    private ICPPFunction fParameterOwner;
    private int fParameterPosition;
    private IBinding fBinding;
    private final boolean fFixedType;
    private IType fType;
    private boolean fCheckedIsValueDependent;
    private boolean fIsValueDependent;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalBinding(IBinding binding, IType type, IASTNode pointOfDefinition) {
        this(binding, type, EvalBinding.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalBinding(IBinding binding, IType type, IBinding templateDefinition) {
        super(templateDefinition);
        this.fParameterPosition = -1;
        this.fBinding = binding;
        this.fType = type;
        this.fFixedType = type != null;
    }

    public EvalBinding(ICPPFunction parameterOwner, int parameterPosition, IType type, IASTNode pointOfDefinition) {
        this(parameterOwner, parameterPosition, type, EvalBinding.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalBinding(ICPPFunction parameterOwner, int parameterPosition, IType type, IBinding templateDefinition) {
        super(templateDefinition);
        this.fParameterOwner = parameterOwner;
        this.fParameterPosition = parameterPosition;
        this.fType = type;
        this.fFixedType = type != null;
    }

    public IBinding getBinding() {
        ICPPParameter[] parameters;
        if (this.fBinding == null && (parameters = this.fParameterOwner.getParameters()).length > this.fParameterPosition) {
            this.fBinding = parameters[this.fParameterPosition];
        }
        return this.fBinding;
    }

    public int getFunctionParameterPosition() {
        if (this.fParameterPosition < 0) {
            if (this.fBinding instanceof CPPParameter) {
                this.fParameterPosition = ((CPPParameter)this.fBinding).getParameterPosition();
            } else {
                ICPPFunction parameterOwner = this.getParameterOwner();
                if (parameterOwner != null) {
                    Object[] parameters = this.fParameterOwner.getParameters();
                    this.fParameterPosition = EvalBinding.findInArray(parameters, this.fBinding);
                }
            }
        }
        return this.fParameterPosition;
    }

    private static int findInArray(Object[] array, Object obj) {
        int i = 0;
        while (i < array.length) {
            if (obj == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ICPPFunction getParameterOwner() {
        IBinding owner;
        if (this.fParameterOwner == null && this.fBinding instanceof ICPPParameter && (owner = this.fBinding.getOwner()) instanceof ICPPFunction) {
            this.fParameterOwner = (ICPPFunction)owner;
        }
        return this.fParameterOwner;
    }

    public int getTemplateParameterID() {
        return this.fBinding instanceof ICPPTemplateParameter ? ((ICPPTemplateParameter)this.fBinding).getParameterID() : -1;
    }

    public IType getFixedType() {
        return this.fFixedType ? this.fType : null;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = this.computeIsTypeDependent();
        }
        return this.fIsTypeDependent;
    }

    private boolean computeIsTypeDependent() {
        IType t = null;
        if (this.fFixedType) {
            t = this.fType;
        } else {
            IBinding binding = this.getBinding();
            if (binding instanceof IEnumerator) {
                t = ((IEnumerator)binding).getType();
            } else if (binding instanceof ICPPTemplateNonTypeParameter) {
                t = ((ICPPTemplateNonTypeParameter)binding).getType();
            } else if (binding instanceof IVariable) {
                t = ((IVariable)binding).getType();
            } else {
                if (binding instanceof ICPPUnknownBinding) {
                    return true;
                }
                if (binding instanceof IFunction) {
                    t = ((IFunction)binding).getType();
                } else {
                    return false;
                }
            }
        }
        return CPPTemplates.isDependentType(t);
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedIsValueDependent) {
            this.fCheckedIsValueDependent = true;
            this.fIsValueDependent = this.computeIsValueDependent();
        }
        return this.fIsValueDependent;
    }

    private boolean computeIsValueDependent() {
        if (this.fBinding instanceof IEnumerator) {
            return IntegralValue.isDependentValue(((IEnumerator)this.fBinding).getValue());
        }
        if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            return true;
        }
        if (this.fBinding instanceof ICPPUnknownBinding) {
            return true;
        }
        if (this.fBinding instanceof IVariable) {
            return IntegralValue.isDependentValue(((IVariable)this.fBinding).getInitialValue());
        }
        if (this.fBinding instanceof IFunction) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression() {
        if (this.fBinding instanceof IEnumerator || this.fBinding instanceof ICPPFunction) {
            return true;
        }
        if (this.fBinding instanceof ICPPVariable) {
            if (!EvalBinding.isConstexprValue(((IVariable)this.fBinding).getInitialValue())) {
                return false;
            }
            ICPPVariable var = (ICPPVariable)this.fBinding;
            if (var.isConstexpr()) {
                return true;
            }
            IType type = SemanticUtil.getNestedType(var.getType(), 5);
            if (ExpressionTypes.isConst(type)) {
                if (var instanceof ICPPField) {
                    if (var.isStatic()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalBinding)) {
            return false;
        }
        EvalBinding o = (EvalBinding)other;
        if (this.fBinding != null) {
            return this.fBinding == o.fBinding;
        }
        return this.fParameterOwner == o.fParameterOwner && this.fParameterPosition == o.fParameterPosition;
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            this.fType = this.computeType();
        }
        return this.fType;
    }

    private IType computeType() {
        IBinding binding = this.getBinding();
        if (binding instanceof IEnumerator) {
            return ((IEnumerator)binding).getType();
        }
        if (binding instanceof ICPPTemplateNonTypeParameter) {
            IType type = ((ICPPTemplateNonTypeParameter)binding).getType();
            if (type instanceof ICPPParameterPackType) {
                type = ((ICPPParameterPackType)type).getType();
            }
            return ExpressionTypes.prvalueType(type);
        }
        if (binding instanceof IVariable) {
            IType type = ((IVariable)binding).getType();
            IASTNode point = CPPSemantics.getCurrentLookupPoint();
            if (type instanceof IArrayType && ((IArrayType)type).getSize() == null && binding instanceof IIndexBinding && point != null) {
                IASTName[] definitions;
                IASTTranslationUnit ast = point.getTranslationUnit();
                IASTName[] iASTNameArray = definitions = ast.getDefinitionsInAST(binding);
                int n = definitions.length;
                int n2 = 0;
                while (n2 < n) {
                    IType localType;
                    IASTName definition = iASTNameArray[n2];
                    IASTDeclarator declarator = ASTQueries.findAncestorWithType(definition, IASTDeclarator.class);
                    if (declarator != null && (localType = CPPVisitor.createType(declarator)) instanceof IArrayType && ((IArrayType)localType).getSize() != null) {
                        type = localType;
                        break;
                    }
                    ++n2;
                }
            }
            return SemanticUtil.mapToAST(ExpressionTypes.glvalueType(type));
        }
        if (binding instanceof IFunction) {
            IFunctionType type = ((IFunction)binding).getType();
            return SemanticUtil.mapToAST(type);
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue() {
        if (this.isValueDependent()) {
            return DependentValue.create(this);
        }
        IValue value = null;
        if (this.fBinding instanceof ICPPVariable) {
            ICPPEvaluation valueEval = EvalUtil.getVariableValue((ICPPVariable)this.fBinding, new ActivationRecord());
            if (valueEval != null) {
                value = valueEval.getValue();
            }
        } else if (this.fBinding instanceof IEnumerator) {
            value = ((IEnumerator)this.fBinding).getValue();
        }
        if (value == null) {
            value = IntegralValue.UNKNOWN;
        }
        return value;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            return IASTExpression.ValueCategory.PRVALUE;
        }
        if (this.fBinding instanceof IFunction || this.fBinding instanceof IVariable || this.fBinding == null) {
            return IASTExpression.ValueCategory.LVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 3;
        ICPPFunction parameterOwner = this.getParameterOwner();
        if (parameterOwner != null) {
            buffer.putShort((short)35);
            buffer.marshalBinding(parameterOwner);
            buffer.putInt(this.getFunctionParameterPosition());
        } else {
            buffer.putShort(firstBytes);
            buffer.marshalBinding(this.fBinding);
        }
        buffer.marshalType(this.fFixedType ? this.fType : null);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        if ((firstBytes & 0x20) != 0) {
            IBinding paramOwnerBinding = buffer.unmarshalBinding();
            if (paramOwnerBinding instanceof IProblemBinding) {
                CCorePlugin.log("An EvalBinding had a parameter owner that could not be stored in the index");
                return EvalFixed.INCOMPLETE;
            }
            ICPPFunction parameterOwner = (ICPPFunction)paramOwnerBinding;
            int parameterPosition = buffer.getInt();
            IType type = buffer.unmarshalType();
            IBinding templateDefinition = buffer.unmarshalBinding();
            return new EvalBinding(parameterOwner, parameterPosition, type, templateDefinition);
        }
        IBinding binding = buffer.unmarshalBinding();
        IType type = buffer.unmarshalType();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalBinding(binding, type, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        IVariable newBinding;
        IBinding origBinding = this.getBinding();
        CPPTemplateParameterMap tpMap = (CPPTemplateParameterMap)context.getParameterMap();
        int packOffset = context.getPackOffset();
        IVariable iVariable = newBinding = tpMap == null ? null : (IVariable)context.getInstantiatedLocal(origBinding);
        if (newBinding != null) {
            IType instantiatedType;
            IType origType = ((IVariable)origBinding).getType();
            EvalBinding newBindingEval = null;
            if (origType instanceof ICPPParameterPackType && (origType = ((ICPPParameterPackType)origType).getType()) != (instantiatedType = CPPTemplates.instantiateType(origType, context))) {
                newBindingEval = new EvalBinding((IBinding)newBinding, instantiatedType, this.getTemplateDefinition());
            }
            if (newBindingEval == null) {
                newBindingEval = new EvalBinding((IBinding)newBinding, newBinding.getType(), this.getTemplateDefinition());
            }
            if (context.hasPackOffset()) {
                return new EvalCompositeAccess(newBindingEval, packOffset);
            }
            return newBindingEval;
        }
        if (origBinding instanceof ICPPTemplateNonTypeParameter) {
            ICPPTemplateArgument argument = context.getArgument((ICPPTemplateNonTypeParameter)origBinding);
            if (argument != null && argument.isNonTypeValue()) {
                return argument.getNonTypeEvaluation();
            }
        } else if (origBinding instanceof ICPPParameter) {
            IType instantiatedType;
            ICPPParameter parameter = (ICPPParameter)origBinding;
            IType origType = parameter.getType();
            if (origType instanceof ICPPParameterPackType && context.hasPackOffset()) {
                origType = ((ICPPParameterPackType)origType).getType();
            }
            if (origType != (instantiatedType = CPPTemplates.instantiateType(origType, context))) {
                return new EvalFixed(instantiatedType, IASTExpression.ValueCategory.LVALUE, DependentValue.create(this));
            }
        } else {
            IBinding instantiatedBinding = EvalBinding.instantiateBinding(origBinding, context, maxDepth);
            if (instantiatedBinding != origBinding) {
                return new EvalBinding(instantiatedBinding, null, this.getTemplateDefinition());
            }
        }
        return this;
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation eval = record.getVariable(this.getBinding());
        if (eval != null) {
            return eval;
        }
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        IBinding binding = this.getBinding();
        if (binding instanceof IEnumerator) {
            return CPPTemplates.determinePackSize(((IEnumerator)binding).getValue(), tpMap);
        }
        if (binding instanceof ICPPUnknownBinding) {
            return CPPTemplates.determinePackSize((ICPPUnknownBinding)binding, tpMap);
        }
        if (binding instanceof ICPPParameter && ((ICPPParameter)binding).isParameterPack()) {
            ICPPParameterPackType type = (ICPPParameterPackType)((ICPPParameter)binding).getType();
            return CPPTemplates.determinePackSize(type.getType(), tpMap);
        }
        if (binding instanceof ICPPSpecialization) {
            binding = ((ICPPSpecialization)binding).getSpecializedBinding();
        }
        int r = Integer.MAX_VALUE;
        if (binding instanceof ICPPTemplateDefinition) {
            ICPPTemplateParameter[] parameters;
            ICPPTemplateParameter[] iCPPTemplateParameterArray = parameters = ((ICPPTemplateDefinition)binding).getTemplateParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateParameter param = iCPPTemplateParameterArray[n2];
                r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize((ICPPUnknownBinding)((Object)param), tpMap));
                ++n2;
            }
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fBinding instanceof ICPPTemplateParameter;
    }

    public String toString() {
        return this.getBinding().toString();
    }

    @Override
    public boolean isNoexcept() {
        return true;
    }
}

