/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.nio.ByteOrder;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;

public final class ByteOrderParser
implements ICommonTreeParser {
    public static final ByteOrderParser INSTANCE = new ByteOrderParser();
    private static final String INVALID_VALUE_FOR_BYTE_ORDER = "Invalid value for byte order";

    private ByteOrderParser() {
    }

    @Override
    public final ByteOrder parse(CommonTree byteOrderTree, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        CTFTrace trace = ((Param)param).fTrace;
        CommonTree firstChild = (CommonTree)byteOrderTree.getChild(0);
        if (TsdlUtils.isUnaryString(firstChild)) {
            String strval = TsdlUtils.concatenateUnaryStrings(byteOrderTree.getChildren());
            if (strval.equals("le")) {
                return ByteOrder.LITTLE_ENDIAN;
            }
            if (strval.equals("be") || strval.equals("network")) {
                return ByteOrder.BIG_ENDIAN;
            }
            if (strval.equals("native")) {
                ByteOrder byteOrder = trace.getByteOrder();
                return byteOrder == null ? ByteOrder.nativeOrder() : byteOrder;
            }
            throw new ParseException(INVALID_VALUE_FOR_BYTE_ORDER);
        }
        throw new ParseException(INVALID_VALUE_FOR_BYTE_ORDER);
    }

    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFTrace fTrace;

        public Param(CTFTrace trace) {
            this.fTrace = trace;
        }
    }
}

