/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfTraceAdapterFactory
implements IAdapterFactory {
    private final Table<ITmfTrace, Class<?>, Object> fAdapters = HashBasedTable.create();

    public AbstractTmfTraceAdapterFactory() {
        TmfSignalManager.register(this);
    }

    public synchronized void dispose() {
        TmfSignalManager.deregister(this);
        AbstractTmfTraceAdapterFactory.disposeAdapters(this.fAdapters.values());
        this.fAdapters.clear();
    }

    private static void disposeAdapters(Collection<Object> adapters) {
        for (Object adapter : adapters) {
            if (!(adapter instanceof IDisposableAdapter)) continue;
            ((IDisposableAdapter)adapter).dispose();
        }
    }

    public synchronized <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof ITmfTrace) {
            ITmfTrace trace = (ITmfTrace)adaptableObject;
            Object adapter = this.fAdapters.get((Object)trace, adapterType);
            if (adapter == null) {
                adapter = this.getTraceAdapter(trace, adapterType);
            }
            if (adapter != null) {
                this.fAdapters.put((Object)trace, adapterType, adapter);
                return adapterType.cast(adapter);
            }
        }
        return null;
    }

    protected abstract <T> @Nullable T getTraceAdapter(@NonNull ITmfTrace var1, Class<T> var2);

    @TmfSignalHandler
    public synchronized void traceClosed(TmfTraceClosedSignal signal) {
        Map row = this.fAdapters.row((Object)signal.getTrace());
        AbstractTmfTraceAdapterFactory.disposeAdapters(row.values());
        row.clear();
    }

    public static interface IDisposableAdapter {
        public void dispose();
    }
}

