/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.synchronization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinear;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinearFast;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TsTransformFastTest {
    private static final long ts = 1361657893526374091L;
    private static final IFastTransformFactory fNewObject = (a, b) -> new TmfTimestampTransformLinearFast(a, b);
    private static final IFastTransformFactory fDeserialized = (a, b) -> {
        Throwable throwable;
        String filePath;
        block31: {
            TmfTimestampTransformLinearFast tt = new TmfTimestampTransformLinearFast(a, b);
            filePath = null;
            try {
                File temp = File.createTempFile("serialSyncAlgo", ".tmp");
                filePath = temp.getAbsolutePath();
            }
            catch (IOException e) {
                Assert.fail((String)"Could not create temporary file for serialization");
            }
            Assert.assertNotNull(filePath);
            try {
                Throwable e = null;
                throwable = null;
                try {
                    FileOutputStream fileOut = new FileOutputStream(filePath);
                    try {
                        try (ObjectOutputStream out = new ObjectOutputStream(fileOut);){
                            out.writeObject(tt);
                        }
                        if (fileOut == null) break block31;
                    }
                    catch (Throwable throwable2) {
                        if (e == null) {
                            e = throwable2;
                        } else if (e != throwable2) {
                            e.addSuppressed(throwable2);
                        }
                        if (fileOut == null) throw e;
                        fileOut.close();
                        throw e;
                    }
                    fileOut.close();
                }
                catch (Throwable throwable3) {
                    if (e == null) {
                        e = throwable3;
                        throw e;
                    }
                    if (e == throwable3) throw e;
                    e.addSuppressed(throwable3);
                    throw e;
                }
            }
            catch (IOException e) {
                Assert.fail((String)("Error serializing the synchronization algorithm " + e.getMessage()));
            }
        }
        TmfTimestampTransformLinearFast deserialTt = null;
        try {
            throwable = null;
            Object var8_13 = null;
            try {
                FileInputStream fileIn = new FileInputStream(filePath);
                try {
                    try (ObjectInputStream in = new ObjectInputStream(fileIn);){
                        deserialTt = (TmfTimestampTransformLinearFast)in.readObject();
                    }
                    if (fileIn == null) return deserialTt;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fileIn == null) throw throwable;
                    fileIn.close();
                    throw throwable;
                }
                fileIn.close();
                return deserialTt;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            Assert.fail((String)("Error de-serializing the synchronization algorithm " + e.getMessage()));
        }
        return deserialTt;
    };
    private final IFastTransformFactory fTransformFactory;

    public TsTransformFastTest(String name, IFastTransformFactory factory) {
        this.fTransformFactory = factory;
    }

    @Parameterized.Parameters(name="Factory={0}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({"Object", fNewObject}, {"Deserialized", fDeserialized});
    }

    @Test
    public void testFLTRepeatability() {
        TmfTimestampTransformLinearFast fast = this.fTransformFactory.create(Math.PI, 0.0);
        long deltaMax = fast.getDeltaMax();
        long timestamp = 1361657893526374091L - 1361657893526374091L % deltaMax;
        fast.transform(timestamp);
        long tsMiss = timestamp + deltaMax;
        long tsNoMiss = timestamp + deltaMax - 1L;
        long tsTNoMiss = fast.transform(tsNoMiss);
        Assert.assertEquals((long)1L, (long)fast.getCacheMisses());
        fast.transform(tsMiss);
        Assert.assertEquals((long)2L, (long)fast.getCacheMisses());
        long tsTAfterMiss = fast.transform(tsNoMiss);
        Assert.assertEquals((long)tsTNoMiss, (long)tsTAfterMiss);
    }

    @Test
    public void testFLTEquivalence() {
        TmfTimestampTransformLinearFast fast = this.fTransformFactory.create(Math.PI, 0.0);
        TmfTimestampTransformLinearFast fast2 = this.fTransformFactory.create(Math.PI, 0.0);
        long deltaMax = fast.getDeltaMax();
        long start = 1361657893526374091L - 1361657893526374091L % deltaMax - 10L;
        TsTransformFastTest.checkTime((ITmfTimestampTransform)fast, (ITmfTimestampTransform)fast2, 20, start, 1L);
    }

    @Test
    public void testFastTransformPrecision() {
        int[] directions;
        TmfTimestampTransformLinear precise = new TmfTimestampTransformLinear(Math.PI, 0.0);
        TmfTimestampTransformLinearFast fast = this.fTransformFactory.create(Math.PI, 0.0);
        int samples = 100;
        long start = (long)Math.pow(10.0, 18.0);
        long end = Long.MAX_VALUE;
        int step = (int)((double)(end - start) / ((double)samples * Math.PI));
        TsTransformFastTest.checkTime((ITmfTimestampTransform)precise, (ITmfTimestampTransform)fast, samples, start, step);
        Assert.assertEquals((long)samples, (long)fast.getCacheMisses());
        samples = 1000;
        int[] nArray = directions = new int[]{1, -1};
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer direction = nArray[n2];
            int i = 0;
            while (i <= 30) {
                fast.resetScaleStats();
                step = (1 << i) * direction;
                TsTransformFastTest.checkTime((ITmfTimestampTransform)precise, (ITmfTimestampTransform)fast, samples, start, step);
                Assert.assertTrue((String)String.format("samples: %d scale misses: %d", samples, fast.getCacheMisses()), ((long)samples >= fast.getCacheMisses() ? 1 : 0) != 0);
                ++i;
            }
            ++n2;
        }
    }

    @Test
    public void testFastTransformSlope() {
        int[] dir = new int[]{1, -1};
        long start = 0x40000000L;
        int ex = -9;
        while (ex <= 9) {
            int d = 0;
            while (d < dir.length) {
                double slope = Math.pow(10.0, ex);
                TmfTimestampTransformLinear precise = new TmfTimestampTransformLinear(slope, 0.0);
                TmfTimestampTransformLinearFast fast = this.fTransformFactory.create(slope, 0.0);
                TsTransformFastTest.checkTime((ITmfTimestampTransform)precise, (ITmfTimestampTransform)fast, 1000, start, dir[d]);
                ++d;
            }
            ++ex;
        }
    }

    @Test
    public void testFastTransformSlopeAndOffset() {
        double offset = 54321.0;
        double slope = Math.pow(10.0, 4.0);
        int ex = 0;
        while (ex <= 63) {
            long start = 1 << ex;
            TmfTimestampTransformLinear precise = new TmfTimestampTransformLinear(slope, offset);
            TmfTimestampTransformLinearFast fast = this.fTransformFactory.create(slope, offset);
            TsTransformFastTest.checkTime((ITmfTimestampTransform)precise, (ITmfTimestampTransform)fast, 5, start, 1L);
            ++ex;
        }
    }

    @Test
    public void testFastTransformArguments() {
        double[] slopes;
        double[] dArray = slopes = new double[]{-1.0, 2.147483648E9, 1.0E-10};
        int n = slopes.length;
        int n2 = 0;
        while (n2 < n) {
            double slope = dArray[n2];
            IllegalArgumentException exception = null;
            try {
                this.fTransformFactory.create(slope, 0.0);
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            Assert.assertNotNull((Object)exception);
            ++n2;
        }
    }

    private static void checkTime(ITmfTimestampTransform precise, ITmfTimestampTransform fast, int samples, long start, long step) {
        long prev = 0L;
        int i = 0;
        while (i < samples) {
            long time = start + (long)i * step;
            long exp = precise.transform(time);
            long act = fast.transform(time);
            long err = act - exp;
            Assert.assertTrue((String)("start: " + start + " [" + err + "]"), (Math.abs(err) < 3L ? 1 : 0) != 0);
            if (i > 0) {
                if (step > 0L) {
                    Assert.assertTrue((String)("monotonic error" + act + " " + prev), (act >= prev ? 1 : 0) != 0);
                } else if (step < 0L) {
                    Assert.assertTrue((String)"monotonic ", (act <= prev ? 1 : 0) != 0);
                }
            }
            prev = act;
            ++i;
        }
    }

    private static interface IFastTransformFactory {
        public TmfTimestampTransformLinearFast create(double var1, double var3);
    }
}

