/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model.tree;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfTreeDataModelTest {
    private static final String TO_STRING = "toString";
    private static final String HASH_CODE = "hashCode";
    private static final String EQUALS = "equals";
    private static final @NonNull List<@NonNull String> LABELS0 = Arrays.asList("label1, label2, label3");
    private static final long ID0 = 0L;
    private static final long PARENT_ID0 = -1L;
    private static final OutputElementStyle STYLE0 = null;
    private static final @NonNull List<@NonNull String> LABELS1 = Arrays.asList("label4, label5, label6", "label7");
    private static final long ID1 = 1L;
    private static final long PARENT_ID1 = 0L;
    private static final boolean HAS_MODEL1 = false;
    private static final @NonNull OutputElementStyle STYLE1 = new OutputElementStyle("1");
    private static final long ID2 = 0L;
    private static final long PARENT_ID2 = -1L;
    private static final OutputElementStyle STYLE3 = null;
    private static final String NAME = "Name";
    private TmfTreeDataModel fModel0 = null;
    private TmfTreeDataModel fModel1 = null;

    @Before
    public void setUp() {
        this.fModel0 = TmfTreeDataModelTest.createModel(0);
        this.fModel1 = TmfTreeDataModelTest.createModel(1);
    }

    @Test
    public void testConstructors() {
        TmfTreeDataModel model0 = TmfTreeDataModelTest.createModel(0);
        Assert.assertEquals((long)0L, (long)model0.getId());
        Assert.assertEquals((long)-1L, (long)model0.getParentId());
        Assert.assertEquals((Object)LABELS0.get(0), (Object)model0.getName());
        Assert.assertEquals(LABELS0, (Object)model0.getLabels());
        Assert.assertTrue((boolean)model0.hasRowModel());
        Assert.assertEquals((Object)STYLE0, (Object)model0.getStyle());
        TmfTreeDataModel model1 = TmfTreeDataModelTest.createModel(1);
        Assert.assertEquals((long)1L, (long)model1.getId());
        Assert.assertEquals((long)0L, (long)model1.getParentId());
        Assert.assertEquals((Object)LABELS1.get(0), (Object)model1.getName());
        Assert.assertEquals(LABELS1, (Object)model1.getLabels());
        Assert.assertFalse((boolean)model1.hasRowModel());
        Assert.assertEquals((Object)STYLE1, (Object)model1.getStyle());
        TmfTreeDataModel model2 = TmfTreeDataModelTest.createModel(2);
        Assert.assertEquals((long)0L, (long)model2.getId());
        Assert.assertEquals((long)-1L, (long)model2.getParentId());
        Assert.assertEquals((Object)NAME, (Object)model2.getName());
        Assert.assertEquals((long)1L, (long)model2.getLabels().size());
        Assert.assertEquals((Object)NAME, model2.getLabels().get(0));
        Assert.assertTrue((boolean)model2.hasRowModel());
        Assert.assertEquals((Object)STYLE3, (Object)model2.getStyle());
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)EQUALS, (boolean)this.fModel0.equals((Object)this.fModel0));
        Assert.assertTrue((String)EQUALS, (boolean)this.fModel1.equals((Object)this.fModel1));
        Assert.assertTrue((String)EQUALS, (!this.fModel0.equals((Object)this.fModel1) ? 1 : 0) != 0);
        Assert.assertTrue((String)EQUALS, (!this.fModel1.equals((Object)this.fModel0) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        TmfTreeDataModel model0 = TmfTreeDataModelTest.createModel(0);
        TmfTreeDataModel model1 = TmfTreeDataModelTest.createModel(1);
        Assert.assertTrue((String)EQUALS, (boolean)model0.equals((Object)this.fModel0));
        Assert.assertTrue((String)EQUALS, (boolean)this.fModel0.equals((Object)model0));
        Assert.assertTrue((String)EQUALS, (boolean)model1.equals((Object)this.fModel1));
        Assert.assertTrue((String)EQUALS, (boolean)this.fModel1.equals((Object)model1));
    }

    @Test
    public void testEqualsTransivity() {
        TmfTreeDataModel model0 = TmfTreeDataModelTest.createModel(0);
        TmfTreeDataModel model1 = TmfTreeDataModelTest.createModel(0);
        TmfTreeDataModel model2 = TmfTreeDataModelTest.createModel(0);
        Assert.assertTrue((String)EQUALS, (boolean)model0.equals((Object)model1));
        Assert.assertTrue((String)EQUALS, (boolean)model1.equals((Object)model2));
        Assert.assertTrue((String)EQUALS, (boolean)model0.equals((Object)model2));
    }

    @Test
    public void testEqualsNull() {
        Object model0 = null;
        Assert.assertFalse((String)EQUALS, (boolean)this.fModel0.equals(model0));
        Assert.assertFalse((String)EQUALS, (boolean)this.fModel1.equals(model0));
    }

    @Test
    public void testHashCode() {
        TmfTreeDataModel model0 = TmfTreeDataModelTest.createModel(0);
        TmfTreeDataModel model1 = TmfTreeDataModelTest.createModel(1);
        Assert.assertTrue((String)HASH_CODE, (this.fModel0.hashCode() == model0.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)HASH_CODE, (this.fModel1.hashCode() == model1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)HASH_CODE, (this.fModel0.hashCode() != model1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)HASH_CODE, (this.fModel1.hashCode() != model0.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)TO_STRING, (Object)"<name=[label1, label2, label3] id=0 parentId=-1 style=null hasRowModel=true>", (Object)this.fModel0.toString());
        Assert.assertEquals((String)TO_STRING, (Object)"<name=[label4, label5, label6, label7] id=1 parentId=0 style=Style [1, {}] hasRowModel=false>", (Object)this.fModel1.toString());
        TmfTreeDataModel model2 = TmfTreeDataModelTest.createModel(2);
        Assert.assertEquals((String)TO_STRING, (Object)"<name=[Name] id=0 parentId=-1 style=null hasRowModel=true>", (Object)model2.toString());
    }

    private static TmfTreeDataModel createModel(int i) {
        switch (i) {
            case 0: {
                return new TmfTreeDataModel(0L, -1L, LABELS0);
            }
            case 1: {
                return new TmfTreeDataModel(1L, 0L, LABELS1, false, STYLE1);
            }
            case 2: {
                return new TmfTreeDataModel(0L, -1L, NAME);
            }
        }
        return new TmfTreeDataModel(0L, -1L, LABELS0);
    }
}

