/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis;

import com.google.common.collect.Multimap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysisParameterProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AnalysisParameterProviderTest {
    private static final @NonNull String MODULE_ID = "org.eclipse.linuxtools.tmf.core.tests.analysis.testParamProvider";

    private static IAnalysisModuleHelper getModuleHelper(@NonNull String moduleId) {
        Multimap helpers = TmfAnalysisManager.getAnalysisModules();
        Assert.assertEquals((long)1L, (long)helpers.get((Object)moduleId).size());
        return (IAnalysisModuleHelper)helpers.get((Object)moduleId).iterator().next();
    }

    @After
    public void cleanupTrace() {
        TmfTestTrace.A_TEST_10K.dispose();
    }

    @Test
    public void testProviderTmfTrace() {
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        IAnalysisModuleHelper helper = AnalysisParameterProviderTest.getModuleHelper(MODULE_ID);
        Assert.assertNotNull((Object)helper);
        IAnalysisModule module = null;
        IAnalysisModule module2 = null;
        try {
            try {
                module = helper.newModule(trace);
                Assert.assertNotNull((Object)module);
                Assert.assertEquals((Object)10, (Object)module.getParameter("test"));
                Set providers = TmfAnalysisManager.getParameterProvidersForModule((IAnalysisModule)module, (ITmfTrace)trace);
                Assert.assertEquals((long)1L, (long)providers.size());
                TestAnalysisParameterProvider provider = (TestAnalysisParameterProvider)((Object)providers.iterator().next());
                provider.setValue(5);
                Assert.assertEquals((Object)5, (Object)module.getParameter("test"));
                module2 = helper.newModule(trace);
                Assert.assertNotNull((Object)module2);
                Assert.assertTrue((module != module2 ? 1 : 0) != 0);
                providers = TmfAnalysisManager.getParameterProvidersForModule((IAnalysisModule)module2, (ITmfTrace)trace);
                Assert.assertEquals((long)1L, (long)providers.size());
                TestAnalysisParameterProvider provider2 = (TestAnalysisParameterProvider)((Object)providers.iterator().next());
                Assert.assertTrue((provider == provider2 ? 1 : 0) != 0);
            }
            catch (TmfAnalysisException e) {
                Assert.fail((String)e.getMessage());
                if (module != null) {
                    module.dispose();
                }
                if (module2 != null) {
                    module2.dispose();
                }
            }
        }
        finally {
            if (module != null) {
                module.dispose();
            }
            if (module2 != null) {
                module2.dispose();
            }
        }
    }
}

