/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.ui.swtbot.stubs;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartModel;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.ui.chart.IChartViewer;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.ui.dialog.ChartMakerDialog;
import org.eclipse.tracecompass.tmf.chart.core.model.IDataChartProvider;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

@NonNullByDefault
public class CustomChartStubView
extends TmfView {
    public static final String ID = "org.eclipse.tracecompass.tmf.chart.ui.swtbot.view.stub";
    public static final String MENU_TITLE = "Create custom chart";
    private static final String VIEW_NAME = "Stub View for Chart Tests";
    private static @Nullable IDataChartProvider<StubObject> sfChartProvider = null;
    private @Nullable Composite fContainer;

    public static void setChartProvider(IDataChartProvider<StubObject> provider) {
        sfChartProvider = provider;
    }

    public CustomChartStubView() {
        super(VIEW_NAME);
    }

    public void setFocus() {
    }

    public void createPartControl(@Nullable Composite parent) {
        super.createPartControl(parent);
        SashForm sf = new SashForm(parent, 0);
        this.fContainer = sf;
        NewChartAction addChart = new NewChartAction();
        addChart.setText(MENU_TITLE);
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        menuMgr.add((IAction)addChart);
    }

    private @Nullable Composite getContainer() {
        return this.fContainer;
    }

    private class NewChartAction
    extends Action {
        private NewChartAction() {
        }

        public void run() {
            Composite composite = CustomChartStubView.this.getContainer();
            if (composite == null) {
                return;
            }
            IDataChartProvider chartProvider = sfChartProvider;
            if (chartProvider == null) {
                throw new NullPointerException("no chart provider set. Need to call CustomChartStubView.setChartProvider() before clicking the menu item");
            }
            ChartMakerDialog dialog = new ChartMakerDialog((Shell)NonNullUtils.checkNotNull((Object)composite.getShell()), chartProvider);
            if (dialog.open() != 0) {
                return;
            }
            ChartData data = dialog.getDataSeries();
            ChartModel model = dialog.getChartModel();
            if (data == null || model == null) {
                return;
            }
            IChartViewer.createChart((Composite)composite, (ChartData)data, (ChartModel)model);
        }
    }
}

