/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.fsm.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IBaseQuarkProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventField;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventName;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueQuery;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueScript;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class TmfXmlStateValueCuTest {
    private static final @NonNull AnalysisCompilationData ANALYSIS_DATA = new AnalysisCompilationData();
    private static final DataDrivenValue QUERY_VALUE = new DataDrivenValueQuery(null, ITmfStateValue.Type.NULL, new DataDrivenStateSystemPath((List)ImmutableList.of((Object)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"queryPath")), IBaseQuarkProvider.IDENTITY_BASE_QUARK));
    private final String fXmlString;
    private final @Nullable Object fCompiles;
    private final String fTestName;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        Object[][] objectArrayArray = new Object[24][];
        objectArrayArray[0] = new Object[]{"Null state value", "<stateValue type=\"null\" />", TmfXmlTestUtils.NULL_VALUE};
        objectArrayArray[1] = new Object[]{"Valid integer 1", "<stateValue type=\"int\" value=\"42\" />", new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)42)};
        objectArrayArray[2] = new Object[]{"Valid integer 2 with forced type", "<stateValue type=\"int\" value=\"42\" increment=\"bla\" forcedType=\"long\"/>", new DataDrivenValueConstant(null, ITmfStateValue.Type.LONG, (Object)42)};
        Object[] objectArray = new Object[3];
        objectArray[0] = "Invalid integer";
        objectArray[1] = "<stateValue type=\"int\" value=\"abc\" />";
        objectArrayArray[3] = objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "Int no value";
        objectArray2[1] = "<stateValue type=\"int\" />";
        objectArrayArray[4] = objectArray2;
        objectArrayArray[5] = new Object[]{"Valid long 1", "<stateValue type=\"long\" value=\"4242424242\" />", new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)4242424242L)};
        objectArrayArray[6] = new Object[]{"Valid long 2", "<stateValue type=\"long\" value=\"42\" increment=\"bla\" update=\"oui\"/>", new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)42L)};
        Object[] objectArray3 = new Object[3];
        objectArray3[0] = "Invalid long";
        objectArray3[1] = "<stateValue type=\"long\" value=\"abc\" />";
        objectArrayArray[7] = objectArray3;
        Object[] objectArray4 = new Object[3];
        objectArray4[0] = "Long no value";
        objectArray4[1] = "<stateValue type=\"long\" />";
        objectArrayArray[8] = objectArray4;
        objectArrayArray[9] = new Object[]{"Valid string 1", "<stateValue type=\"string\" value=\"hello there my friend!\" />", new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"hello there my friend!")};
        objectArrayArray[10] = new Object[]{"Valid string 2", "<stateValue type=\"string\" value=\"oh! hello!\" increment=\"bla\" forcedType=\"int\"/>", new DataDrivenValueConstant(null, ITmfStateValue.Type.INTEGER, (Object)"oh! hello!")};
        objectArrayArray[11] = new Object[]{"String no value", "<stateValue type=\"string\" />", new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"")};
        objectArrayArray[12] = new Object[]{"Delete value", "<stateValue type=\"delete\" />", TmfXmlTestUtils.NULL_VALUE};
        objectArrayArray[13] = new Object[]{"Delete value with ignored params", "<stateValue type=\"delete\" forcedType=\"null\" id=\"ignored\" />", TmfXmlTestUtils.NULL_VALUE};
        objectArrayArray[14] = new Object[]{"Event name", "<stateValue type=\"eventName\" forcedType=\"null\" id=\"ignored\" />", new DataDrivenValueEventName(null)};
        objectArrayArray[15] = new Object[]{"Event name with params", "<stateValue type=\"eventName\" value=\"null\" id=\"ignored\" stack=\"push\"/>", new DataDrivenValueEventName(null)};
        objectArrayArray[16] = new Object[]{"Event field", "<stateValue type=\"eventField\" value=\"field\" forcedType=\"int\" />", new DataDrivenValueEventField(null, ITmfStateValue.Type.INTEGER, "field")};
        Object[] objectArray5 = new Object[3];
        objectArray5[0] = "Unknown mapping group";
        objectArray5[1] = "<stateValue type=\"eventField\" value=\"field\" mappingGroup=\"undefined\" />";
        objectArrayArray[17] = objectArray5;
        objectArrayArray[18] = new Object[]{"Valid script", "<stateValue type=\"script\" value=\"a + b\" />", new DataDrivenValueScript(null, ITmfStateValue.Type.NULL, Collections.emptyMap(), "a + b", "nashorn")};
        objectArrayArray[19] = new Object[]{"Script with children", "<stateValue type=\"script\" value=\"a + b\" ><stateValue id=\"a\" type=\"null\"/></stateValue>", new DataDrivenValueScript(null, ITmfStateValue.Type.NULL, (Map)ImmutableMap.of((Object)"a", (Object)TmfXmlTestUtils.NULL_VALUE), "a + b", "nashorn")};
        Object[] objectArray6 = new Object[3];
        objectArray6[0] = "Script with invalid children";
        objectArray6[1] = "<stateValue type=\"script\" value=\"a + b\" ><stateValue id=\"a\" type=\"int\" value=\"not int\"/></stateValue>";
        objectArrayArray[20] = objectArray6;
        objectArrayArray[21] = new Object[]{"Query", "<stateValue type=\"query\" ><stateAttribute type=\"constant\" value=\"queryPath\"/></stateValue>", QUERY_VALUE};
        Object[] objectArray7 = new Object[3];
        objectArray7[0] = "Query no children";
        objectArray7[1] = "<stateValue type=\"query\" />";
        objectArrayArray[22] = objectArray7;
        Object[] objectArray8 = new Object[3];
        objectArray8[0] = "Query with invalid children";
        objectArray8[1] = "<stateValue type=\"query\" ><stateAttribute type=\"constant\" /></stateValue>";
        objectArrayArray[23] = objectArray8;
        return Arrays.asList(objectArrayArray);
    }

    public TmfXmlStateValueCuTest(String testName, String xmlString, @Nullable Object generated) {
        this.fTestName = testName;
        this.fXmlString = xmlString;
        this.fCompiles = generated;
    }

    @Test
    public void testStateValueCompilation() throws SAXException, IOException, ParserConfigurationException {
        Element xmlElement = TmfXmlTestUtils.getXmlElement("stateValue", this.fXmlString);
        Assert.assertNotNull((Object)xmlElement);
        TmfXmlStateValueCu compiledValue = TmfXmlStateValueCu.compileValue((AnalysisCompilationData)ANALYSIS_DATA, (Element)xmlElement);
        if (this.fCompiles == null) {
            Assert.assertNull((Object)compiledValue);
            return;
        }
        Assert.assertNotNull((Object)compiledValue);
        Assert.assertEquals((String)this.fTestName, (Object)this.fCompiles, (Object)compiledValue.generate());
    }
}

