/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.tests.perf.cygprofile;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfBenchmarkTrace;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CallStackAndGraphBenchmark {
    public static final String TEST_ID = "org.eclipse.tracecompass.lttng2.ust#CallStack#";
    private static final String TEST_CALLSTACK_BUILD = "Building Callstack (%s)";
    private static final String TEST_CALLSTACK_PARSESEGSTORE = "Callstack segment store (%s)";
    private static final String TEST_CALLGRAPH_BUILD = "Building CallGraph (%s)";
    private static final int LOOP_COUNT = 25;
    private final String fName;
    private final String fTestTrace;
    private final int fLoopCount;

    private static String getPathFromCtfTestTrace(@NonNull CtfTestTrace testTrace) {
        CtfTmfTrace ctftrace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace);
        String path = Objects.requireNonNull(ctftrace.getPath());
        ctftrace.dispose();
        return path;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({CtfTestTrace.CYG_PROFILE.name(), CallStackAndGraphBenchmark.getPathFromCtfTestTrace(CtfTestTrace.CYG_PROFILE), 25}, {CtfBenchmarkTrace.UST_QMLSCENE.name(), CtfBenchmarkTrace.UST_QMLSCENE.getTracePath().toString(), 25}, {CtfBenchmarkTrace.UST_VLC.name(), CtfBenchmarkTrace.UST_VLC.getTracePath().toString(), 5});
    }

    public CallStackAndGraphBenchmark(String name, String tracePath, int loopCount) {
        this.fName = name;
        this.fTestTrace = tracePath;
        this.fLoopCount = loopCount;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void runCpuBenchmark() throws TmfTraceException {
        Performance perf = Performance.getDefault();
        PerformanceMeter callStackBuildPm = Objects.requireNonNull(perf.createPerformanceMeter(TEST_ID + String.format(TEST_CALLSTACK_BUILD, this.fName)));
        perf.tagAsSummary(callStackBuildPm, String.format(TEST_CALLSTACK_BUILD, this.fName), Dimension.CPU_TIME);
        PerformanceMeter callStackSegStorePm = Objects.requireNonNull(perf.createPerformanceMeter(TEST_ID + String.format(TEST_CALLSTACK_PARSESEGSTORE, this.fName)));
        perf.tagAsSummary(callStackSegStorePm, String.format(TEST_CALLSTACK_PARSESEGSTORE, this.fName), Dimension.CPU_TIME);
        PerformanceMeter callgraphBuildPm = Objects.requireNonNull(perf.createPerformanceMeter(TEST_ID + String.format(TEST_CALLGRAPH_BUILD, this.fName)));
        perf.tagAsSummary(callgraphBuildPm, String.format(TEST_CALLGRAPH_BUILD, this.fName), Dimension.CPU_TIME);
        int i = 0;
        while (i < this.fLoopCount) {
            TmfTrace trace = null;
            try {
                trace = this.getTrace();
                trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
                CallStackAnalysis callStackModule = (CallStackAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, CallStackAnalysis.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.callstack");
                Assert.assertNotNull((Object)callStackModule);
                callStackModule.triggerAutomatically(false);
                callStackBuildPm.start();
                TmfTestHelper.executeAnalysis((IAnalysisModule)callStackModule);
                callStackBuildPm.stop();
                @NonNull ISegmentStore segmentStore = callStackModule.getSegmentStore();
                Assert.assertNotNull((Object)segmentStore);
                callStackSegStorePm.start();
                Iterator iterator = segmentStore.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
                callStackSegStorePm.stop();
                ICallGraphProvider callGraphModule = callStackModule.getCallGraph();
                Assert.assertTrue((boolean)(callGraphModule instanceof CallGraphAnalysis));
                callgraphBuildPm.start();
                TmfTestHelper.executeAnalysis((IAnalysisModule)((CallGraphAnalysis)callGraphModule));
                callgraphBuildPm.stop();
                File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                File[] fileArray = suppDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
            finally {
                if (trace != null) {
                    trace.dispose();
                }
            }
            ++i;
        }
        callStackBuildPm.commit();
        callgraphBuildPm.commit();
    }

    private TmfTrace getTrace() throws TmfTraceException {
        LttngUstTrace trace = new LttngUstTrace();
        trace.initTrace(null, this.fTestTrace, ITmfEvent.class);
        return trace;
    }
}

