/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.compatibility.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Activator;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Messages;
import org.eclipse.equinox.internal.p2.discovery.compatibility.util.CacheManager;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryTransport;

public class TransportUtil {
    public static void downloadResource(URI location, File target, IProgressMonitor monitor) throws IOException, CoreException {
        CacheManager cm = Activator.getDefault().getCacheManager();
        File cacheFile = cm.createCache(location, monitor);
        if (cacheFile == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery.compatibility", Messages.TransportUtil_InternalError));
        }
        TransportUtil.copyStream(new BufferedInputStream(new FileInputStream(cacheFile)), true, new BufferedOutputStream(new FileOutputStream(target)), true);
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    public static void readResource(URI location, TextContentProcessor processor, IProgressMonitor monitor) throws IOException, CoreException {
        CacheManager cm = Activator.getDefault().getCacheManager();
        File cacheFile = cm.createCache(location, monitor);
        if (cacheFile == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery.compatibility", Messages.TransportUtil_InternalError));
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(cacheFile));){
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            processor.process(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean verifyAvailability(List<? extends URI> locations, boolean one, IProgressMonitor monitor) throws IOException, CoreException {
        if (locations.isEmpty() || locations.size() > 5) {
            throw new IllegalArgumentException();
        }
        int countFound = 0;
        for (URI uRI : locations) {
            block5: {
                try {
                    new RepositoryTransport().getLastModified(uRI, monitor);
                    if (!one) break block5;
                    return true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (one) continue;
                    return false;
                }
            }
            ++countFound;
        }
        return countFound == locations.size();
    }

    public static String getFileNameFor(String bundleUrl) {
        if (bundleUrl.charAt(bundleUrl.length() - 1) == '/') {
            bundleUrl = bundleUrl.substring(0, bundleUrl.length() - 1);
        }
        if (bundleUrl.lastIndexOf(47) != -1) {
            bundleUrl = bundleUrl.substring(bundleUrl.lastIndexOf(47) + 1);
        }
        return bundleUrl.replaceAll("[^a-zA-Z0-9_\\.]", "_");
    }

    public static interface TextContentProcessor {
        public void process(Reader var1) throws IOException;
    }
}

