/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class SelectElementTypeContributionItem
extends CompoundContributionItem {
    private static final Comparator<IContributionItem> ITEM_COMPARATOR = new ItemComparator();
    private static final ImageDescriptor SELECTED_ICON = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/bullet.gif");
    private static final String TYPE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.type";
    private static final String SELECT_TRACE_TYPE_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.select_trace_type";

    protected IContributionItem[] getContributionItems() {
        HashSet<String> selectedTraceTypes = new HashSet<String>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ISelection selection = page.getSelection();
        boolean forTraces = false;
        boolean forExperiments = false;
        if (selection instanceof StructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                if (element instanceof TmfTraceElement) {
                    TmfTraceElement trace = (TmfTraceElement)element;
                    selectedTraceTypes.add(trace.getTraceType());
                    forTraces = true;
                    continue;
                }
                if (!(element instanceof TmfExperimentElement)) continue;
                TmfExperimentElement exp = (TmfExperimentElement)element;
                selectedTraceTypes.add(exp.getTraceType());
                forExperiments = true;
            }
        }
        if (forTraces && forExperiments) {
            throw new RuntimeException("You must select only experiments or only traces to set the element type");
        }
        return this.getContributionItems(selectedTraceTypes, forExperiments);
    }

    protected IContributionItem[] getContributionItems(Set<String> selectedTraceTypes, boolean forExperiments) {
        LinkedList list = new LinkedList();
        HashMap categoriesMap = new HashMap();
        TmfTraceType.getTraceTypeHelpers().forEach(traceTypeHelper -> {
            String traceTypeId = traceTypeHelper.getTraceTypeId();
            boolean selected = selectedTraceTypes.contains(traceTypeId);
            if ((traceTypeHelper.isEnabled() || selected) && forExperiments == traceTypeHelper.isExperimentType()) {
                String categoryName = traceTypeHelper.getCategoryName().replaceAll("&", "&&");
                MenuManager subMenu = null;
                if (!categoryName.isEmpty() && (subMenu = (MenuManager)categoriesMap.get(categoryName)) == null) {
                    subMenu = new MenuManager(categoryName);
                    categoriesMap.put(categoryName, subMenu);
                    list.add(subMenu);
                }
                String label = traceTypeHelper.getName().replaceAll("&", "&&");
                if (selected && subMenu != null) {
                    subMenu.setImageDescriptor(SELECTED_ICON);
                }
                this.addContributionItem(list, traceTypeId, label, selected, subMenu);
            }
        });
        Collections.sort(list, ITEM_COMPARATOR);
        return list.toArray(new IContributionItem[list.size()]);
    }

    protected String getContributionItemCommandId() {
        return SELECT_TRACE_TYPE_COMMAND_ID;
    }

    private void addContributionItem(List<IContributionItem> list, String traceTypeId, String label, boolean selected, MenuManager subMenu) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(TYPE_PARAMETER, traceTypeId);
        ImageDescriptor icon = null;
        if (selected) {
            icon = SELECTED_ICON;
        }
        CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "my.parameterid", this.getContributionItemCommandId(), 8);
        param.parameters = params;
        param.icon = icon;
        param.disabledIcon = icon;
        param.hoverIcon = icon;
        param.label = label;
        param.visibleEnabled = true;
        if (subMenu != null) {
            CommandContributionItem item = new CommandContributionItem(param);
            int i = Collections.binarySearch(Arrays.asList(subMenu.getItems()), item, ITEM_COMPARATOR);
            i = i >= 0 ? i : -i - 1;
            subMenu.insert(i, (IContributionItem)item);
        } else {
            list.add((IContributionItem)new CommandContributionItem(param));
        }
    }

    private static final class ItemComparator
    implements Comparator<IContributionItem> {
        private ItemComparator() {
        }

        @Override
        public int compare(IContributionItem o1, IContributionItem o2) {
            if (o1 instanceof MenuManager) {
                if (o2 instanceof MenuManager) {
                    MenuManager m1 = (MenuManager)o1;
                    MenuManager m2 = (MenuManager)o2;
                    return m1.getMenuText().compareTo(m2.getMenuText());
                }
                return -1;
            }
            if (o2 instanceof MenuManager) {
                return 1;
            }
            CommandContributionItem c1 = (CommandContributionItem)o1;
            CommandContributionItem c2 = (CommandContributionItem)o2;
            return c1.getData().label.compareTo(c2.getData().label);
        }
    }
}

