/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.actions.StatusLineCLabelContribution;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public abstract class StatusLineContributionGroup
extends ActionGroup {
    private static final String INCOMING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.incoming";
    private static final String OUTGOING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.outgoing";
    private static final String CONFLICTING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.conflicting";
    private static final String TOTALS_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.totals";
    private static final int TEXT_FIELD_MAX_SIZE = 25;
    private StatusLineCLabelContribution incoming;
    private StatusLineCLabelContribution outgoing;
    private StatusLineCLabelContribution conflicting;
    private StatusLineCLabelContribution totalChanges;
    private Image incomingImage = TeamUIPlugin.getImageDescriptor("elcl16/incom_synch.png").createImage();
    private Image outgoingImage = TeamUIPlugin.getImageDescriptor("elcl16/outgo_synch.png").createImage();
    private Image conflictingImage = TeamUIPlugin.getImageDescriptor("elcl16/conflict_synch.png").createImage();
    private ISynchronizePageConfiguration configuration;

    public StatusLineContributionGroup(Shell shell, ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        if (this.isThreeWay()) {
            this.incoming = this.createStatusLineContribution(INCOMING_ID, 1, "0", this.incomingImage);
            this.outgoing = this.createStatusLineContribution(OUTGOING_ID, 2, "0", this.outgoingImage);
            this.conflicting = this.createStatusLineContribution(CONFLICTING_ID, 8, "0", this.conflictingImage);
        } else {
            this.totalChanges = new StatusLineCLabelContribution(TOTALS_ID, 25);
        }
        this.updateCounts();
    }

    private boolean isThreeWay() {
        return this.configuration.getComparisonType() == "three-way";
    }

    private StatusLineCLabelContribution createStatusLineContribution(String id, int mode, String label, Image image) {
        StatusLineCLabelContribution item = new StatusLineCLabelContribution(id, 15);
        item.addListener(3, event -> this.configuration.setMode(mode));
        item.setText(label);
        item.setImage(image);
        return item;
    }

    public void dispose() {
        if (this.isThreeWay()) {
            this.incomingImage.dispose();
            this.outgoingImage.dispose();
            this.conflictingImage.dispose();
        }
    }

    protected void updateCounts() {
        int total = this.getChangeCount();
        int supportedModes = this.configuration.getSupportedModes();
        int workspaceConflicting = (supportedModes & 8) != 0 ? this.countFor(12) : 0;
        int workspaceOutgoing = (supportedModes & 2) != 0 ? this.countFor(4) : 0;
        int workspaceIncoming = (supportedModes & 1) != 0 ? this.countFor(8) : 0;
        TeamUIPlugin.getStandardDisplay().asyncExec(() -> {
            if (this.isThreeWay()) {
                this.conflicting.setText(Integer.valueOf(workspaceConflicting).toString());
                this.incoming.setText(Integer.valueOf(workspaceIncoming).toString());
                this.outgoing.setText(Integer.valueOf(workspaceOutgoing).toString());
                this.conflicting.setTooltip(NLS.bind((String)TeamUIMessages.StatisticsPanel_numbersTooltip, (Object[])new String[]{TeamUIMessages.StatisticsPanel_conflicting}));
                this.outgoing.setTooltip(NLS.bind((String)TeamUIMessages.StatisticsPanel_numbersTooltip, (Object[])new String[]{TeamUIMessages.StatisticsPanel_outgoing}));
                this.incoming.setTooltip(NLS.bind((String)TeamUIMessages.StatisticsPanel_numbersTooltip, (Object[])new String[]{TeamUIMessages.StatisticsPanel_incoming}));
            } else if (total == 1) {
                this.totalChanges.setText(NLS.bind((String)TeamUIMessages.StatisticsPanel_numberTotalSingular, (Object[])new String[]{Integer.toString(total)}));
            } else {
                this.totalChanges.setText(NLS.bind((String)TeamUIMessages.StatisticsPanel_numberTotalPlural, (Object[])new String[]{Integer.toString(total)}));
            }
        });
    }

    protected abstract int getChangeCount();

    protected abstract int countFor(int var1);

    public void fillActionBars(IActionBars actionBars) {
        IStatusLineManager mgr = actionBars.getStatusLineManager();
        if (this.isThreeWay()) {
            mgr.add((IContributionItem)this.incoming);
            mgr.add((IContributionItem)this.outgoing);
            mgr.add((IContributionItem)this.conflicting);
        } else {
            mgr.add((IContributionItem)this.totalChanges);
        }
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }
}

