/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.FileSystemSelectionArea;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class ProjectContentsLocationArea {
    private static String BROWSE_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_browseLabel;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String FILE_SCHEME = "file";
    private static final String SAVED_LOCATION_ATTR = "OUTSIDE_LOCATION";
    private Label locationLabel;
    private Text locationPathField;
    private Button browseButton;
    private IErrorMessageReporter errorReporter;
    private String projectName = "";
    private String userPath = "";
    private Button useDefaultsButton;
    private IProject existingProject;
    private FileSystemSelectionArea fileSystemSelectionArea;

    public ProjectContentsLocationArea(IErrorMessageReporter reporter, Composite composite, IProject startProject) {
        this.errorReporter = reporter;
        this.projectName = startProject.getName();
        this.existingProject = startProject;
        this.createContents(composite, false);
    }

    public void setExistingProject(IProject existingProject) {
        this.projectName = existingProject.getName();
        this.existingProject = existingProject;
    }

    public ProjectContentsLocationArea(IErrorMessageReporter reporter, Composite composite) {
        this.errorReporter = reporter;
        this.createContents(composite, true);
    }

    private void createContents(Composite composite, boolean defaultEnabled) {
        int columns = 4;
        Composite projectGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.useDefaultsButton = new Button(projectGroup, 131104);
        this.useDefaultsButton.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_useDefaultLabel);
        this.useDefaultsButton.setSelection(defaultEnabled);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = columns;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserEntryArea(projectGroup, defaultEnabled);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = ProjectContentsLocationArea.this.useDefaultsButton.getSelection();
                if (useDefaults) {
                    ProjectContentsLocationArea.this.userPath = ProjectContentsLocationArea.this.locationPathField.getText();
                    ProjectContentsLocationArea.this.locationPathField.setText(TextProcessor.process((String)ProjectContentsLocationArea.this.getDefaultPathDisplayString()));
                } else {
                    ProjectContentsLocationArea.this.locationPathField.setText(TextProcessor.process((String)ProjectContentsLocationArea.this.userPath));
                }
                String error = ProjectContentsLocationArea.this.checkValidLocation();
                ProjectContentsLocationArea.this.errorReporter.reportError(error, error != null && error.equals(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty));
                ProjectContentsLocationArea.this.setUserAreaEnabled(!useDefaults);
            }
        });
        this.setUserAreaEnabled(!defaultEnabled);
    }

    public boolean isDefault() {
        return this.useDefaultsButton.getSelection();
    }

    private void createUserEntryArea(Composite composite, boolean defaultEnabled) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationLabel);
        this.locationPathField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.locationPathField.setLayoutData((Object)data);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectContentsLocationArea.this.handleLocationBrowseButtonPressed();
            }
        });
        this.createFileSystemSelection(composite);
        if (defaultEnabled) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        } else if (this.existingProject == null) {
            this.locationPathField.setText("");
        } else {
            this.locationPathField.setText(TextProcessor.process((String)this.existingProject.getLocation().toOSString()));
        }
        this.locationPathField.addModifyListener(e -> this.errorReporter.reportError(this.checkValidLocation(), false));
    }

    private void createFileSystemSelection(Composite composite) {
        if (FileSystemSupportRegistry.getInstance().hasOneFileSystem()) {
            return;
        }
        new Label(composite, 0);
        this.fileSystemSelectionArea = new FileSystemSelectionArea();
        this.fileSystemSelectionArea.createContents(composite);
    }

    private String getDefaultPathDisplayString() {
        URI defaultURI = null;
        if (this.existingProject != null) {
            defaultURI = this.existingProject.getLocationURI();
        }
        if (defaultURI == null || defaultURI.getScheme().equals(FILE_SCHEME)) {
            return Platform.getLocation().append(this.projectName).toOSString();
        }
        return defaultURI.toString();
    }

    private void setUserAreaEnabled(boolean enabled) {
        this.locationLabel.setEnabled(enabled);
        this.locationPathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        if (this.fileSystemSelectionArea != null) {
            this.fileSystemSelectionArea.setEnabled(enabled);
        }
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings ideDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = ideDialogSettings.getSection(this.getClass().getName());
        if (result == null) {
            result = ideDialogSettings.addNewSection(this.getClass().getName());
        }
        return result;
    }

    private void handleLocationBrowseButtonPressed() {
        FileSystemConfiguration config;
        String selectedDirectory = null;
        String dirName = this.getPathFromLocationField();
        if (!dirName.equals("")) {
            IFileInfo info = IDEResourceInfoUtils.getFileInfo(dirName);
            if (info == null || !info.exists()) {
                dirName = "";
            }
        } else {
            String value = this.getDialogSettings().get(SAVED_LOCATION_ATTR);
            if (value != null) {
                dirName = value;
            }
        }
        if ((config = this.getSelectedConfiguration()) == null || config.equals(FileSystemSupportRegistry.getInstance().getDefaultConfiguration())) {
            DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell(), 0x10000000);
            dialog.setMessage(IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel);
            dialog.setFilterPath(dirName);
            selectedDirectory = dialog.open();
        } else {
            URI uri = this.getSelectedConfiguration().getContributor().browseFileSystem(dirName, this.browseButton.getShell());
            if (uri != null) {
                selectedDirectory = uri.toString();
            }
        }
        if (selectedDirectory != null) {
            this.updateLocationField(selectedDirectory);
            this.getDialogSettings().put(SAVED_LOCATION_ATTR, selectedDirectory);
        }
    }

    private void updateLocationField(String selectedPath) {
        this.locationPathField.setText(TextProcessor.process((String)selectedPath));
    }

    private String getPathFromLocationField() {
        URI fieldURI;
        try {
            fieldURI = new URI(this.locationPathField.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.locationPathField.getText();
        }
        String path = fieldURI.getPath();
        return path != null ? path : this.locationPathField.getText();
    }

    public String checkValidLocation() {
        IStatus locationStatus;
        URI projectPath;
        String locationFieldContents = this.locationPathField.getText();
        if (locationFieldContents.isEmpty()) {
            return IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty;
        }
        URI newPath = this.getProjectLocationURI();
        if (newPath == null) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationError;
        }
        if (this.existingProject != null && (projectPath = this.existingProject.getLocationURI()) != null && URIUtil.equals((URI)projectPath, (URI)newPath)) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationIsSelf;
        }
        if (!this.isDefault() && !(locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocationURI(this.existingProject, newPath)).isOK()) {
            return locationStatus.getMessage();
        }
        return null;
    }

    public URI getProjectLocationURI() {
        FileSystemConfiguration configuration = this.getSelectedConfiguration();
        if (configuration == null) {
            return null;
        }
        return configuration.getContributor().getURI(this.locationPathField.getText());
    }

    private FileSystemConfiguration getSelectedConfiguration() {
        if (this.fileSystemSelectionArea == null) {
            return FileSystemSupportRegistry.getInstance().getDefaultConfiguration();
        }
        return this.fileSystemSelectionArea.getSelectedConfiguration();
    }

    public void updateProjectName(String newName) {
        this.projectName = newName;
        if (this.isDefault()) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        }
    }

    public String getProjectLocation() {
        if (this.isDefault()) {
            return Platform.getLocation().toOSString();
        }
        return this.locationPathField.getText();
    }

    public static interface IErrorMessageReporter {
        public void reportError(String var1, boolean var2);
    }
}

