/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.tasks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.provisional.tasks.IFileTaskScanner;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.parser.XMLLineTokenizer;

public class XMLStreamingFileTaskScanner
extends XMLLineTokenizer
implements IFileTaskScanner,
IExecutableExtension {
    private static final boolean DEBUG_TASKSPERF = false;
    protected List<Map<String, Object>> fNewMarkerAttributeMaps = null;
    private long time0;
    private String runtimeMarkerType;

    protected Map<String, Object> createInitialMarkerAttributes(String text, int documentLine, int startOffset, int length, int priority) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(6);
        attributes.put("lineNumber", new Integer(documentLine + 1));
        attributes.put("org.eclipse.core.resources.taskmarker", this.getMarkerType());
        attributes.put("charStart", new Integer(startOffset));
        attributes.put("charEnd", new Integer(startOffset + length));
        attributes.put("message", text);
        attributes.put("userEditable", Boolean.FALSE);
        switch (priority) {
            case 2: {
                attributes.put("priority", new Integer(2));
                break;
            }
            case 0: {
                attributes.put("priority", new Integer(0));
                break;
            }
            default: {
                attributes.put("priority", new Integer(1));
            }
        }
        return attributes;
    }

    String detectCharset(IFile file) {
        if (file.getType() == 1 && file.isAccessible()) {
            try {
                return file.getCharset(true);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return ResourcesPlugin.getEncoding();
    }

    /*
     * Loose catch block
     */
    void findTasks(IFile file, TaskTag[] taskTags, IProgressMonitor monitor) {
        block33: {
            String charset = this.detectCharset(file);
            monitor.beginTask("", -1);
            DefaultLineTracker lineTracker = new DefaultLineTracker();
            String[] searchTags = new String[taskTags.length];
            int i2222 = 0;
            while (i2222 < searchTags.length) {
                searchTags[i2222] = taskTags[i2222].getTag().toLowerCase(Locale.ENGLISH);
                ++i2222;
            }
            try {
                Throwable i2222 = null;
                Object var8_13 = null;
                try (InputStream contents = file.getContents(true);){
                    this.reset(new BufferedReader(new InputStreamReader(contents, charset)));
                    while (!this.isEOF()) {
                        String regionType = this.primGetNextToken();
                        if (!this.isCommentType(regionType)) continue;
                        String comment = this.yytext();
                        lineTracker.set(comment);
                        int lineNumber = 0;
                        while (lineNumber < lineTracker.getNumberOfLines()) {
                            IRegion line = lineTracker.getLineInformation(lineNumber);
                            String lineComment = comment.substring(line.getOffset(), line.getOffset() + line.getLength());
                            String lowercaseText = lineComment.toLowerCase(Locale.ENGLISH);
                            int i3 = 0;
                            while (i3 < taskTags.length) {
                                int tagIndex = lowercaseText.indexOf(searchTags[i3]);
                                if (tagIndex >= 0) {
                                    String markerDescription = lineComment.substring(tagIndex);
                                    int markerOffset = this.getOffset() + line.getOffset() + tagIndex;
                                    int markerLength = line.getLength() - tagIndex;
                                    this.fNewMarkerAttributeMaps.add(this.createInitialMarkerAttributes(markerDescription, lineNumber + this.getLine(), markerOffset, markerLength, taskTags[i3].getPriority()));
                                }
                                ++i3;
                            }
                            ++lineNumber;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (i2222 == null) {
                        i2222 = throwable;
                    } else if (i2222 != throwable) {
                        i2222.addSuppressed(throwable);
                    }
                    throw i2222;
                }
            }
            catch (IOException e) {
                Logger.logException("IOException reading file " + file.getFullPath().toString(), e);
                try {
                    this.yyclose();
                }
                catch (IOException iOException) {}
                break block33;
            }
            catch (CoreException e) {
                Logger.logException(e);
                try {
                    this.yyclose();
                }
                catch (IOException iOException) {}
                break block33;
            }
            catch (BadLocationException e) {
                Logger.logException(e);
                {
                    catch (Throwable throwable) {
                        try {
                            this.yyclose();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    this.yyclose();
                }
                catch (IOException iOException) {}
                break block33;
            }
            try {
                this.yyclose();
            }
            catch (IOException iOException) {}
        }
        monitor.done();
    }

    public String getMarkerType() {
        if (this.runtimeMarkerType != null) {
            return this.runtimeMarkerType;
        }
        return "org.eclipse.core.resources.taskmarker";
    }

    protected boolean isCommentType(String regionType) {
        return "XML_COMMENT_TEXT".equals(regionType);
    }

    public synchronized Map<String, Object>[] scan(IFile file, TaskTag[] taskTags, IProgressMonitor monitor) {
        this.fNewMarkerAttributeMaps = new ArrayList<Map<String, Object>>();
        if (monitor.isCanceled() || !this.shouldScan((IResource)file)) {
            return new Map[0];
        }
        if (taskTags.length > 0) {
            this.findTasks(file, taskTags, monitor);
        }
        return this.fNewMarkerAttributeMaps.toArray(new Map[this.fNewMarkerAttributeMaps.size()]);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null && data instanceof String) {
            this.runtimeMarkerType = data.toString();
        }
        if (data != null && data instanceof Map) {
            this.runtimeMarkerType = ((Map)data).get("runtimeMarkerType").toString();
        }
    }

    boolean shouldScan(IResource r) {
        return true;
    }

    public void shutdown(IProject project) {
    }

    public void startup(IProject project) {
    }
}

