/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.PE;

@Deprecated
public class PEArchive
implements AutoCloseable {
    protected String filename;
    protected RandomAccessFile rfile;
    protected long strtbl_pos = -1L;
    private ARHeader[] headers;

    @Override
    public void close() {
        this.dispose();
    }

    public void dispose() {
        try {
            if (this.rfile != null) {
                this.rfile.close();
                this.rfile = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public static boolean isARHeader(byte[] ident) {
        return ident != null && ident.length >= 7 && ident[0] == 33 && ident[1] == 60 && ident[2] == 97 && ident[3] == 114 && ident[4] == 99 && ident[5] == 104 && ident[6] == 62;
    }

    public PEArchive(String filename) throws IOException {
        this.filename = filename;
        this.rfile = new RandomAccessFile(filename, "r");
        String hdr = this.rfile.readLine();
        if (hdr == null || hdr.compareTo("!<arch>") != 0) {
            this.rfile.close();
            throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
        }
    }

    private void loadHeaders() throws IOException {
        if (this.headers != null) {
            return;
        }
        Vector<ARHeader> v = new Vector<ARHeader>();
        try {
            while (this.rfile.getFilePointer() < this.rfile.length()) {
                ARHeader header = new ARHeader();
                String name = header.getObjectName();
                long pos = this.rfile.getFilePointer();
                if (name.charAt(0) != '/') {
                    v.add(header);
                }
                if (name.compareTo("//") == 0) {
                    this.strtbl_pos = pos;
                }
                if ((pos += header.getSize()) % 2L != 0L) {
                    ++pos;
                }
                this.rfile.seek(pos);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.headers = v.toArray(new ARHeader[0]);
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.headers;
    }

    private boolean stringInStrings(String str, String[] set) {
        String[] stringArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (str.compareTo(element) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] extractFiles(String outdir, String[] names) throws IOException {
        Vector<String> names_used = new Vector<String>();
        this.loadHeaders();
        int count = 0;
        ARHeader[] aRHeaderArray = this.headers;
        int n = this.headers.length;
        int n2 = 0;
        while (n2 < n) {
            ARHeader header = aRHeaderArray[n2];
            String object_name = header.getObjectName();
            if (names == null || this.stringInStrings(object_name, names)) {
                object_name = count + "_" + object_name;
                ++count;
                byte[] data = header.getObjectData();
                File output = new File(outdir, object_name);
                names_used.add(object_name);
                RandomAccessFile rfile = new RandomAccessFile(output, "rw");
                rfile.write(data);
                rfile.close();
            }
            ++n2;
        }
        return names_used.toArray(new String[0]);
    }

    public String[] extractFiles(String outdir) throws IOException {
        return this.extractFiles(outdir, null);
    }

    public class ARHeader {
        private String object_name;
        private long size;
        private long elf_offset;

        private String removeBlanks(String str) {
            while (str.charAt(str.length() - 1) == ' ') {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }

        private String nameFromStringTable(long offset) throws IOException {
            StringBuilder name = new StringBuilder(0);
            long pos = PEArchive.this.rfile.getFilePointer();
            try {
                if (PEArchive.this.strtbl_pos != -1L) {
                    byte temp;
                    PEArchive.this.rfile.seek(PEArchive.this.strtbl_pos + offset);
                    while ((temp = PEArchive.this.rfile.readByte()) != 10) {
                        name.append((char)temp);
                    }
                }
            }
            finally {
                PEArchive.this.rfile.seek(pos);
            }
            return name.toString();
        }

        public ARHeader() throws IOException {
            int len;
            byte[] object_name = new byte[16];
            byte[] modification_time = new byte[12];
            byte[] uid = new byte[6];
            byte[] gid = new byte[6];
            byte[] mode = new byte[8];
            byte[] size = new byte[10];
            byte[] trailer = new byte[2];
            PEArchive.this.rfile.read(object_name);
            PEArchive.this.rfile.read(modification_time);
            PEArchive.this.rfile.read(uid);
            PEArchive.this.rfile.read(gid);
            PEArchive.this.rfile.read(mode);
            PEArchive.this.rfile.read(size);
            PEArchive.this.rfile.read(trailer);
            this.elf_offset = PEArchive.this.rfile.getFilePointer();
            this.object_name = this.removeBlanks(new String(object_name));
            this.size = Long.parseLong(this.removeBlanks(new String(size)));
            if (PEArchive.this.strtbl_pos != -1L && this.object_name.length() > 1 && this.object_name.charAt(0) == '/') {
                try {
                    long offset = Long.parseLong(this.object_name.substring(1));
                    this.object_name = this.nameFromStringTable(offset);
                }
                catch (Exception offset) {
                    // empty catch block
                }
            }
            if ((len = this.object_name.length()) > 2 && this.object_name.charAt(len - 1) == '/') {
                this.object_name = this.object_name.substring(0, len - 1);
            }
        }

        public String getObjectName() {
            return this.object_name;
        }

        public long getSize() {
            return this.size;
        }

        public PE getPE() throws IOException {
            return new PE(PEArchive.this.filename, this.elf_offset);
        }

        public PE getPE(boolean filter_on) throws IOException {
            return new PE(PEArchive.this.filename, this.elf_offset, filter_on);
        }

        public byte[] getObjectData() throws IOException {
            byte[] temp = new byte[(int)this.size];
            PEArchive.this.rfile.seek(this.elf_offset);
            PEArchive.this.rfile.read(temp);
            return temp;
        }
    }
}

