/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.rewrite;

import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;

public class TypeHelper {
    private TypeHelper() {
    }

    public static boolean shouldBePassedByReference(IType type, IASTTranslationUnit ast) {
        if ((type = SemanticUtil.getNestedType(type, 9)) instanceof ICompositeType) {
            try {
                ICPPClassType classType;
                CPPSemantics.pushLookupPoint(ast);
                if (!(!(type instanceof ICPPClassType) || TypeTraits.hasTrivialCopyCtor(classType = (ICPPClassType)type) && TypeTraits.hasTrivialDestructor(classType))) {
                    return true;
                }
                SizeofCalculator calc = ((ASTTranslationUnit)ast).getSizeofCalculator();
                SizeofCalculator.SizeAndAlignment sizeofPointer = calc.sizeAndAlignmentOfPointer();
                long maxSize = sizeofPointer != null ? sizeofPointer.size : 4L;
                SizeofCalculator.SizeAndAlignment sizeofType = calc.sizeAndAlignment(type);
                if (sizeofType == null || sizeofType.size > maxSize) {
                    return true;
                }
            }
            finally {
                CPPSemantics.popLookupPoint();
            }
        }
        return false;
    }

    public static IType createType(IASTDeclarator declarator) {
        if (declarator.getTranslationUnit() instanceof ICPPASTTranslationUnit) {
            return CPPVisitor.createType(declarator);
        }
        return CVisitor.createType(declarator);
    }
}

