/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.ui.Activator;
import org.eclipse.remote.internal.jsch.ui.messages.Messages;
import org.eclipse.remote.internal.jsch.ui.wizards.JSchConnectionWizard;
import org.eclipse.remote.ui.AbstractRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class JSchUIConnectionService
extends AbstractRemoteUIConnectionService {
    private final IRemoteConnectionType fConnectionType;

    public JSchUIConnectionService(IRemoteConnectionType connectionType) {
        this.fConnectionType = connectionType;
    }

    public IRemoteConnectionType getConnectionType() {
        return this.fConnectionType;
    }

    public IRemoteUIConnectionWizard getConnectionWizard(Shell shell) {
        return new JSchConnectionWizard(shell, this.fConnectionType);
    }

    public void openConnectionWithProgress(Shell shell, IRunnableContext context, final IRemoteConnection connection) {
        if (!connection.isOpen()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        connection.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        throw new InvocationTargetException(e);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                if (context != null) {
                    context.run(true, true, op);
                } else {
                    new ProgressMonitorDialog(shell).run(true, true, op);
                }
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.JSchUIConnectionManager_Connection_Error, (String)Messages.JSchUIConnectionManager_Could_not_open_connection, (IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getCause().getMessage()));
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.JSchUIConnectionManager_Connection_Error, (String)Messages.JSchUIConnectionManager_Could_not_open_connection, (IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
            }
        }
    }

    public ILabelProvider getLabelProvider() {
        return new AbstractRemoteUIConnectionService.DefaultLabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("org.eclipse.remote.jsch.ui.connectionType");
            }
        };
    }

    public static class Factory
    implements IRemoteConnectionType.Service.Factory {
        public <T extends IRemoteConnectionType.Service> T getService(IRemoteConnectionType connectionType, Class<T> service) {
            if (IRemoteUIConnectionService.class.equals(service)) {
                return (T)((Object)new JSchUIConnectionService(connectionType));
            }
            return null;
        }
    }
}

