/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.search.internal.ui.text.FileMatch;

public class LineItem {
    IFile f;
    String line;
    int lineNumber;
    int lineOffset;

    public LineItem(IFile f, String line, int lineNumber, int lineOffset) {
        this.f = f;
        this.line = line;
        this.lineNumber = lineNumber;
        this.lineOffset = lineOffset;
    }

    public LineItem(FileMatch match) {
        this.f = match.getFile();
        this.line = match.getLineElement().getContents();
        this.lineNumber = match.getLineElement().getLine();
        this.lineOffset = match.getLineElement().getOffset();
    }

    public String toString() {
        return String.valueOf(this.lineNumber) + ": " + this.line + "  (" + this.f.getProjectRelativePath() + ")";
    }

    public String getText() {
        return this.line;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IFile getFile() {
        return this.f;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
        result = 31 * result + this.lineNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineItem other = (LineItem)obj;
        if (this.f == null ? other.f != null : !this.f.equals((Object)other.f)) {
            return false;
        }
        return this.lineNumber == other.lineNumber;
    }

    public int getOffset() {
        return this.lineOffset;
    }
}

