/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class IUColumnConfig {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_VERSION = 2;
    public static final int COLUMN_SIZE = 3;
    public static final int COLUMN_PROVIDER = 4;
    public static final int COLUMN_DESCRIPTION = 5;
    private String columnTitle;
    private int columnType;
    private int columnWidth;
    private int columnWidthInPixels;

    public IUColumnConfig(String title, int columnType, int columnWidthInChars) {
        this.columnTitle = title;
        this.columnType = columnType;
        this.columnWidth = columnWidthInChars;
        this.columnWidthInPixels = -1;
    }

    public String getColumnTitle() {
        return this.columnTitle;
    }

    public void setColumnTitle(String title) {
        this.columnTitle = title;
    }

    public int getWidthInChars() {
        return this.columnWidth;
    }

    public void setWidthInChars(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getWidthInPixels(Control control) {
        if (this.columnWidthInPixels >= 0) {
            return this.columnWidthInPixels;
        }
        GC gc = new GC((Drawable)control);
        FontMetrics fm = gc.getFontMetrics();
        this.columnWidthInPixels = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)this.columnWidth);
        gc.dispose();
        return this.columnWidthInPixels;
    }

    public void setWidthInPixels(int width) {
        this.columnWidthInPixels = width;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public void setColumnType(int type) {
        this.columnType = type;
    }
}

