/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.tree;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.IElementResolver;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfDataModelSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ICheckboxTreeViewerListener;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.MultiTreePatternFilter;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TriStateFilteredCheckboxTree;

@Deprecated
public abstract class AbstractSelectTreeViewer
extends AbstractTmfTreeViewer {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(AbstractSelectTreeViewer.class);
    private static final AtomicInteger INSTANCE_ID_SEQUENCE = new AtomicInteger(0);
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final char SEP = ':';
    private static final @NonNull String CHECKED_ELEMENTS = ".CHECKED_ELEMENTS";
    private static final @NonNull String FILTER_STRING = ".FILTER_STRING";
    private static final @NonNull String UPDATE_CONTENT_JOB_NAME = "AbstractSelectTreeViewer#updateContent Job";
    private static final String FAILED_TO_SLEEP_PREFIX = "Failed to sleep the ";
    private static final String LOG_CATEGORY_SUFFIX = " Tree viewer";
    private final String fId;
    private final @NonNull String fLogCategory;
    private final int fInstanceId;
    private static final ViewerComparator COMPARATOR = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            TmfTreeViewerEntry entry1 = (TmfTreeViewerEntry)e1;
            TmfTreeViewerEntry entry2 = (TmfTreeViewerEntry)e2;
            String name1 = entry1.getName();
            String name2 = entry2.getName();
            Long longValue1 = Longs.tryParse((String)name1);
            Long longValue2 = Longs.tryParse((String)name2);
            return longValue1 == null || longValue2 == null ? name1.compareTo(name2) : longValue1.compareTo(longValue2);
        }
    };
    private ILegendImageProvider fLegendImageProvider;
    private Set<ICheckboxTreeViewerListener> fTreeListeners = new HashSet<ICheckboxTreeViewerListener>();
    private TriStateFilteredCheckboxTree fCheckboxTree;
    private final int fLegendIndex;

    private AbstractSelectTreeViewer(Composite parent, TriStateFilteredCheckboxTree checkboxTree, int legendIndex, String id) {
        super(parent, checkboxTree.getViewer());
        TreeViewer treeViewer = checkboxTree.getViewer();
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.setComparator(COMPARATOR);
        if (treeViewer instanceof CheckboxTreeViewer) {
            ((CheckboxTreeViewer)treeViewer).addCheckStateListener((ICheckStateListener)new CheckStateChangedListener());
        }
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeViewerSelectionListener());
        checkboxTree.getFilterControl().addModifyListener(e -> this.saveViewContext());
        this.fCheckboxTree = checkboxTree;
        this.fLegendIndex = legendIndex;
        this.fId = id;
        this.fLogCategory = String.valueOf(this.fId) + LOG_CATEGORY_SUFFIX;
        this.setLabelProvider((IBaseLabelProvider)new DataProviderTreeLabelProvider());
        this.fInstanceId = INSTANCE_ID_SEQUENCE.incrementAndGet();
    }

    public AbstractSelectTreeViewer(Composite parent, int legendIndex, String id) {
        this(parent, new TriStateFilteredCheckboxTree(parent, 65794, new MultiTreePatternFilter(), true, false), legendIndex, id);
    }

    @Deprecated
    public void setTreeListener(ICheckboxTreeViewerListener listener) {
        this.addTreeListener(listener);
    }

    public void addTreeListener(ICheckboxTreeViewerListener listener) {
        this.fTreeListeners.add(listener);
    }

    public void removeTreeListener(ICheckboxTreeViewerListener listener) {
        this.fTreeListeners.remove(listener);
    }

    public void setLegendImageProvider(ILegendImageProvider legendImageProvider) {
        this.fLegendImageProvider = legendImageProvider;
    }

    public boolean isChecked(Object element) {
        return this.fCheckboxTree.getChecked(element);
    }

    @Override
    protected void contentChanged(ITmfTreeViewerEntry rootEntry) {
        Object filterString;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(trace);
        Set ids = (Set)ctx.getData(this.getDataContextId(CHECKED_ELEMENTS));
        if (ids != null && rootEntry != null) {
            ArrayList<ITmfTreeViewerEntry> checkedElements = new ArrayList<ITmfTreeViewerEntry>();
            this.checkEntries(ids, rootEntry, checkedElements);
            this.internalSetCheckedElements(checkedElements.toArray());
        }
        if ((filterString = ctx.getData(this.getDataContextId(FILTER_STRING))) instanceof String) {
            this.fCheckboxTree.setFilterText((String)filterString);
        } else {
            this.fCheckboxTree.setFilterText("");
        }
        this.getTreeViewer().refresh();
    }

    protected void setCheckedElements(Object[] checkedElements) {
        this.internalSetCheckedElements(checkedElements);
        this.getTreeViewer().refresh();
    }

    private void internalSetCheckedElements(Object[] checkedElements) {
        this.fCheckboxTree.setCheckedElements(checkedElements);
        this.saveViewContext();
        for (ICheckboxTreeViewerListener listener : this.fTreeListeners) {
            listener.handleCheckStateChangedEvent(this.getCheckedViewerEntries());
        }
    }

    private Collection<ITmfTreeViewerEntry> getCheckedViewerEntries() {
        Object[] checkedElements = this.fCheckboxTree.getCheckedElements();
        return Lists.newArrayList((Iterable)Iterables.filter(Arrays.asList(checkedElements), ITmfTreeViewerEntry.class));
    }

    private void checkEntries(Set<Long> ids, ITmfTreeViewerEntry root, List<ITmfTreeViewerEntry> checkedElements) {
        if (root instanceof TmfGenericTreeEntry && ids.contains(((TmfGenericTreeEntry)root).getModel().getId())) {
            checkedElements.add(root);
        }
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : root.getChildren()) {
            this.checkEntries(ids, iTmfTreeViewerEntry, checkedElements);
        }
    }

    @Override
    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.saveViewContext();
        this.restorePatternFilter(signal.getTrace());
        this.fCheckboxTree.setCheckedElements(new Object[0]);
        super.traceOpened(signal);
    }

    @Override
    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (this.getTrace() != signal.getTrace()) {
            this.saveViewContext();
            this.restorePatternFilter(signal.getTrace());
            this.fCheckboxTree.setCheckedElements(new Object[0]);
        }
        super.traceSelected(signal);
    }

    @Override
    public void reset() {
        this.fCheckboxTree.setCheckedElements(new Object[0]);
        this.fCheckboxTree.setFilterText("");
        super.reset();
    }

    @Override
    protected void updateContent(final long start, final long end, final boolean isSelection) {
        Throwable throwable = null;
        Object var7_6 = null;
        try (final TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, UPDATE_CONTENT_JOB_NAME, new Object[0]).setCategory(this.fLogCategory).build();){
            final ITmfTrace trace = this.getTrace();
            if (trace == null) {
                return;
            }
            Job thread = new Job(UPDATE_CONTENT_JOB_NAME){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public IStatus run(IProgressMonitor monitor) {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (TraceCompassLogUtils.FlowScopeLog runScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractSelectTreeViewer#updateContent Job run", new Object[0]).setParentScope(scope).build();){
                        ITmfTreeDataProvider<@NonNull ITmfTreeDataModel> provider = AbstractSelectTreeViewer.this.getProvider(trace);
                        if (provider == null) {
                            return Status.OK_STATUS;
                        }
                        Map<String, Object> parameters = AbstractSelectTreeViewer.this.getParameters(start, end, isSelection);
                        if (parameters.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        boolean isComplete = false;
                        do {
                            TmfModelResponse response;
                            Throwable throwable2 = null;
                            Object var10_13 = null;
                            try (TraceCompassLogUtils.FlowScopeLog iterScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractSelectTreeViewer#updateContent Job query", new Object[0]).setParentScope(scope).build();){
                                response = provider.fetchTree(parameters, monitor);
                                @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
                                if (model != null) {
                                    AbstractSelectTreeViewer.this.updateTree(trace, start, end, model.getEntries());
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                            ITmfResponse.Status status = response.getStatus();
                            if (status == ITmfResponse.Status.COMPLETED) {
                                isComplete = true;
                                continue;
                            }
                            if (status == ITmfResponse.Status.FAILED || status == ITmfResponse.Status.CANCELLED) {
                                isComplete = true;
                                continue;
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                runScope.addData(AbstractSelectTreeViewer.FAILED_TO_SLEEP_PREFIX + this.getName(), (Object)e);
                                Thread.currentThread().interrupt();
                                if (runScope != null) {
                                    runScope.close();
                                }
                                return new Status(4, "org.eclipse.tracecompass.tmf.ui", AbstractSelectTreeViewer.FAILED_TO_SLEEP_PREFIX + this.getName());
                            }
                        } while (!isComplete);
                        return Status.OK_STATUS;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
            };
            thread.setSystem(true);
            thread.schedule();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateTree(ITmfTrace trace, long start, long end, List<@NonNull ITmfTreeDataModel> model) {
        Throwable throwable = null;
        Object var8_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog parentScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractSelectTreeViewer:TreeUpdateRequested", new Object[0]).setCategory(this.fLogCategory).build();){
            ITmfTreeViewerEntry newRootEntry = this.modelToTree(start, end, model);
            if (newRootEntry != null) {
                Display.getDefault().asyncExec(() -> {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractSelectTreeViewer:TreeUpdate", new Object[0]).setParentScope(parentScope).build();){
                        if (!trace.equals(this.getTrace())) {
                            return;
                        }
                        TreeViewer treeViewer = this.getTreeViewer();
                        if (treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        Object currentRootEntry = treeViewer.getInput();
                        if (!(currentRootEntry instanceof ITmfTreeViewerEntry) || !this.treeEquals(newRootEntry, (ITmfTreeViewerEntry)currentRootEntry)) {
                            this.updateTreeUI(treeViewer, newRootEntry);
                        } else {
                            treeViewer.refresh();
                        }
                        TreeColumn[] treeColumnArray = treeViewer.getTree().getColumns();
                        int n = treeColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn column = treeColumnArray[n2];
                            column.pack();
                            ++n2;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                });
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean treeEquals(ITmfTreeViewerEntry entry1, ITmfTreeViewerEntry entry2) {
        if (!Objects.equals(entry1.getName(), entry2.getName())) {
            return false;
        }
        if (entry1 instanceof TmfGenericTreeEntry && entry2 instanceof TmfGenericTreeEntry) {
            Object model1 = ((TmfGenericTreeEntry)entry1).getModel();
            Object model2 = ((TmfGenericTreeEntry)entry2).getModel();
            if (model1 != null && model2 != null && !model1.getLabels().equals(model2.getLabels())) {
                return false;
            }
        }
        List<@NonNull ? extends ITmfTreeViewerEntry> children1 = entry1.getChildren();
        List<@NonNull ? extends ITmfTreeViewerEntry> children2 = entry2.getChildren();
        if (children1.size() != children2.size()) {
            return false;
        }
        int size = children1.size();
        int i = 0;
        while (i < size) {
            if (!this.treeEquals(children1.get(i), children2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void saveViewContext() {
        ITmfTrace previousTrace = this.getTrace();
        if (previousTrace != null) {
            Object[] checkedElements = this.fCheckboxTree.getCheckedElements();
            HashSet<Long> ids = new HashSet<Long>();
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedElement = objectArray[n2];
                if (checkedElement instanceof TmfGenericTreeEntry) {
                    ids.add(((TmfGenericTreeEntry)checkedElement).getModel().getId());
                }
                ++n2;
            }
            Text filterControl = this.fCheckboxTree.getFilterControl();
            String filterString = filterControl != null ? filterControl.getText() : null;
            TmfTraceManager.getInstance().updateTraceContext(previousTrace, builder -> builder.setData(this.getDataContextId(CHECKED_ELEMENTS), (Object)ids).setData(this.getDataContextId(FILTER_STRING), (Object)filterString));
        }
    }

    private @NonNull String getDataContextId(String baseKey) {
        return String.valueOf(this.getClass().getName()) + ':' + this.fInstanceId + baseKey;
    }

    private void restorePatternFilter(ITmfTrace trace) {
        if (trace == null) {
            this.fCheckboxTree.getPatternFilter().setPattern(null);
            return;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(trace);
        Object filterString = ctx.getData(this.getClass() + FILTER_STRING);
        if (filterString instanceof String) {
            this.fCheckboxTree.getPatternFilter().setPattern((String)filterString);
        } else {
            this.fCheckboxTree.getPatternFilter().setPattern(null);
        }
    }

    protected Image getLegendImage(@NonNull String name) {
        ILegendImageProvider legendImageProvider = this.fLegendImageProvider;
        int legendColumnIndex = this.fLegendIndex;
        if (legendImageProvider != null && legendColumnIndex >= 0) {
            Tree tree = this.getTreeViewer().getTree();
            int imageWidth = tree.getColumn(legendColumnIndex).getWidth();
            int imageHeight = tree.getItemHeight() - 1;
            if (imageHeight > 0 && imageWidth > 0) {
                return legendImageProvider.getLegendImage(imageHeight, imageWidth, name);
            }
        }
        return null;
    }

    protected Image getLegendImage(@NonNull Long id) {
        ILegendImageProvider legendImageProvider = this.fLegendImageProvider;
        int legendColumnIndex = this.fLegendIndex;
        if (legendImageProvider != null && legendColumnIndex >= 0) {
            Tree tree = this.getTreeViewer().getTree();
            int imageWidth = tree.getColumn(legendColumnIndex).getWidth();
            int imageHeight = tree.getItemHeight() - 1;
            if (imageHeight > 0 && imageWidth > 0) {
                return legendImageProvider.getLegendImage(imageHeight, imageWidth, id);
            }
        }
        return null;
    }

    @Override
    protected ITmfTreeViewerEntry updateElements(ITmfTrace trace, long start, long end, boolean isSelection) {
        throw new UnsupportedOperationException("This method should not be called for AbstractSelectTreeViewers");
    }

    protected ITmfTreeDataProvider<@NonNull ITmfTreeDataModel> getProvider(@NonNull ITmfTrace trace) {
        return DataProviderManager.getInstance().getDataProvider(trace, this.fId, ITmfTreeDataProvider.class);
    }

    @Override
    protected void initializeDataSource(@NonNull ITmfTrace trace) {
        this.getProvider(trace);
    }

    protected @NonNull Map<String, Object> getParameters(long start, long end, boolean isSelection) {
        return FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(Long.min(start, end), Long.max(start, end), 2));
    }

    protected ITmfTreeViewerEntry modelToTree(long start, long end, List<ITmfTreeDataModel> model) {
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        HashMap<Long, TmfTreeViewerEntry> map = new HashMap<Long, TmfTreeViewerEntry>();
        map.put(-1L, root);
        for (ITmfTreeDataModel entry : model) {
            TmfGenericTreeEntry<ITmfTreeDataModel> viewerEntry = new TmfGenericTreeEntry<ITmfTreeDataModel>(entry);
            map.put(entry.getId(), viewerEntry);
            TmfTreeViewerEntry parent = (TmfTreeViewerEntry)map.get(entry.getParentId());
            if (parent == null || parent.getChildren().contains(viewerEntry)) continue;
            parent.addChild(viewerEntry);
        }
        return root;
    }

    protected static <T extends TmfGenericTreeEntry<? extends TmfTreeDataModel>> @NonNull TmfTreeColumnData createColumn(String text, final Comparator<T> comparator) {
        TmfTreeColumnData column = new TmfTreeColumnData(text);
        column.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return comparator.compare((TmfGenericTreeEntry)e1, (TmfGenericTreeEntry)e2);
            }
        });
        return column;
    }

    @Deprecated
    protected static @NonNull String getFullPath(TmfGenericTreeEntry<TmfTreeDataModel> entry) {
        StringBuilder path = new StringBuilder(entry.getName());
        ITmfTreeViewerEntry parent = entry.getParent();
        while (parent instanceof TmfGenericTreeEntry) {
            path.insert(0, String.valueOf(parent.getName()) + '/');
            parent = parent.getParent();
        }
        return path.toString();
    }

    public TriStateFilteredCheckboxTree getTriStateFilteredCheckboxTree() {
        return this.fCheckboxTree;
    }

    private final class CheckStateChangedListener
    implements ICheckStateListener {
        private CheckStateChangedListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            AbstractSelectTreeViewer.this.saveViewContext();
            if (!AbstractSelectTreeViewer.this.fTreeListeners.isEmpty()) {
                Collection entries = AbstractSelectTreeViewer.this.getCheckedViewerEntries();
                for (ICheckboxTreeViewerListener listener : AbstractSelectTreeViewer.this.fTreeListeners) {
                    listener.handleCheckStateChangedEvent(entries);
                }
                AbstractSelectTreeViewer.this.refresh();
            }
        }
    }

    protected class DataProviderTreeLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected DataProviderTreeLabelProvider() {
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            TmfGenericTreeEntry genericEntry;
            TmfTreeDataModel model;
            if (columnIndex == AbstractSelectTreeViewer.this.fLegendIndex && element instanceof TmfGenericTreeEntry && AbstractSelectTreeViewer.this.isChecked(element) && (model = (TmfTreeDataModel)(genericEntry = (TmfGenericTreeEntry)element).getModel()).hasRowModel()) {
                return AbstractSelectTreeViewer.this.getLegendImage(((TmfTreeDataModel)genericEntry.getModel()).getId());
            }
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TmfGenericTreeEntry) {
                TmfGenericTreeEntry genericEntry;
                Object model;
                if (columnIndex == AbstractSelectTreeViewer.this.fLegendIndex) {
                    return "";
                }
                int index = AbstractSelectTreeViewer.this.fLegendIndex < 0 || columnIndex < AbstractSelectTreeViewer.this.fLegendIndex ? columnIndex : columnIndex - 1;
                if (index < (model = (genericEntry = (TmfGenericTreeEntry)element).getModel()).getLabels().size()) {
                    return (String)model.getLabels().get(index);
                }
                return "";
            }
            return super.getColumnText(element, columnIndex);
        }
    }

    private class TreeViewerSelectionListener
    implements ISelectionChangedListener {
        private TreeViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Multimap metadata;
            Object model;
            IStructuredSelection selection = event.getStructuredSelection();
            Object entry = selection.getFirstElement();
            if (entry instanceof TmfGenericTreeEntry && (model = ((TmfGenericTreeEntry)entry).getModel()) instanceof IElementResolver && !(metadata = ((IElementResolver)model).getMetadata()).isEmpty()) {
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfDataModelSelectedSignal((Object)AbstractSelectTreeViewer.this, metadata));
            }
        }
    }
}

