/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.pcap.core.event;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.stream.PacketStream;
import org.eclipse.tracecompass.internal.pcap.core.stream.PacketStreamBuilder;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEvent;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.TmfPacketStream;
import org.eclipse.tracecompass.internal.tmf.pcap.core.protocol.TmfPcapProtocol;
import org.eclipse.tracecompass.internal.tmf.pcap.core.util.ProtocolConversion;

public class TmfPacketStreamBuilder {
    private final PacketStreamBuilder fBuilder;

    public TmfPacketStreamBuilder(TmfPcapProtocol protocol) {
        this.fBuilder = new PacketStreamBuilder(ProtocolConversion.unwrap(protocol));
    }

    public synchronized void addEventToStream(PcapEvent event) {
        Packet packet = event.getPacket().getPacket(PcapProtocol.PCAP);
        if (!(packet instanceof PcapPacket)) {
            return;
        }
        PcapPacket pcapPacket = (PcapPacket)packet;
        this.fBuilder.addPacketToStream(pcapPacket);
    }

    public synchronized int getNbStreams() {
        return this.fBuilder.getNbStreams();
    }

    public synchronized Iterable<TmfPacketStream> getStreams() {
        return StreamSupport.stream(this.fBuilder.getStreams().spliterator(), false).map(e -> new TmfPacketStream((PacketStream)e)).collect(Collectors.toCollection(ArrayList::new));
    }
}

