/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStructuredBindingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPStructuredBindingComposite
extends CPPImplicitVariable {
    private static final char[] GET_NAME = "get".toCharArray();
    private static final IStructuredBindingNameEvaluationStrategy INCOMPLETE_INITIALIZER = new IStructuredBindingNameEvaluationStrategy(){

        @Override
        public ICPPEvaluation getEvaluation(int nameIndex) {
            return EvalFixed.INCOMPLETE;
        }
    };
    private IStructuredBindingNameEvaluationStrategy evaluationStrategy = null;
    private ICPPASTStructuredBindingDeclaration declaration;

    public CPPStructuredBindingComposite(IASTImplicitName name, ICPPEvaluation initializerEvaluation) {
        super(name, initializerEvaluation);
        IASTNode nameParent = name.getParent();
        assert (nameParent instanceof ICPPASTStructuredBindingDeclaration);
        this.declaration = (ICPPASTStructuredBindingDeclaration)nameParent;
    }

    public ICPPEvaluation getEvaluationForName(IASTName name) {
        int index = ArrayUtil.indexOf(this.declaration.getNames(), name);
        return this.getNameEvaluationStrategy().getEvaluation(index);
    }

    private IStructuredBindingNameEvaluationStrategy getNameEvaluationStrategy() {
        if (this.evaluationStrategy == null) {
            this.evaluationStrategy = this.createEvaluationStrategy(this.declaration);
        }
        return this.evaluationStrategy;
    }

    private IStructuredBindingNameEvaluationStrategy createEvaluationStrategy(ICPPASTStructuredBindingDeclaration structuredBinding) {
        IASTInitializer initializer = structuredBinding.getInitializer();
        ICPPEvaluation initializerEvaluation = this.getInitializerEvaluation();
        if (initializer != null && initializerEvaluation != null) {
            IType initializerType = this.getType();
            IType unwrappedType = SemanticUtil.getNestedType(initializerType, 20);
            if (unwrappedType instanceof IArrayType) {
                return new ArrayElement(initializer, initializerEvaluation);
            }
            if (unwrappedType instanceof ICPPClassType) {
                IASTName[] definedNames = structuredBinding.getNames();
                long numberOfNames = definedNames.length;
                ICPPClassType classType = (ICPPClassType)unwrappedType;
                if (numberOfNames > 0L) {
                    ICPPScope scope = CPPSemantics.getLookupScope(definedNames[0]);
                    Optional<ICPPClassSpecialization> tupleSizeInstance = CPPVisitor.findTupleSizeWithValueMember(unwrappedType, scope, structuredBinding);
                    if (tupleSizeInstance.isPresent()) {
                        if (CPPVisitor.hasConstexprStaticIntegralValueField(tupleSizeInstance.get(), numberOfNames)) {
                            return new TupleElement(initializer, initializerEvaluation, classType);
                        }
                    } else {
                        return new MemberElement(initializer, initializerEvaluation, classType);
                    }
                }
            }
        }
        return INCOMPLETE_INITIALIZER;
    }

    private class ArrayElement
    extends IStructuredBindingNameEvaluationStrategy {
        private IASTInitializer initializer;
        private ICPPEvaluation initializerEvaluation;

        private ArrayElement(IASTInitializer initializer, ICPPEvaluation initializerEvaluation) {
            this.initializer = initializer;
            this.initializerEvaluation = initializerEvaluation;
        }

        @Override
        public ICPPEvaluation getEvaluation(int nameIndex) {
            EvalFixed indexEvaluation = new EvalFixed(CPPBasicType.UNSIGNED_INT, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(nameIndex));
            return new EvalBinary(127, this.initializerEvaluation, (ICPPEvaluation)indexEvaluation, this.initializer);
        }
    }

    private static abstract class IStructuredBindingNameEvaluationStrategy {
        private IStructuredBindingNameEvaluationStrategy() {
        }

        public abstract ICPPEvaluation getEvaluation(int var1);
    }

    private class MemberElement
    extends IStructuredBindingNameEvaluationStrategy {
        private IASTInitializer initializer;
        private ICPPEvaluation initializerEvaluation;
        private ICPPClassType initializerType;

        private MemberElement(IASTInitializer initializer, ICPPEvaluation initializerEvaluation, ICPPClassType initializerType) {
            this.initializer = initializer;
            this.initializerEvaluation = initializerEvaluation;
            this.initializerType = initializerType;
        }

        @Override
        public ICPPEvaluation getEvaluation(int nameIndex) {
            IField[] nonStaticFields = (IField[])Arrays.stream(ClassTypeHelper.getFields(this.initializerType)).filter(CPPVisitor.IS_STATIC_VARIABLE.negate()).toArray(IField[]::new);
            if (nameIndex >= 0 && nameIndex < nonStaticFields.length) {
                IField boundField = nonStaticFields[nameIndex];
                return new EvalMemberAccess((IType)this.initializerType, this.initializerEvaluation.getValueCategory(), (IBinding)boundField, this.initializerEvaluation, false, this.initializer);
            }
            return EvalFixed.INCOMPLETE;
        }
    }

    private class TupleElement
    extends IStructuredBindingNameEvaluationStrategy {
        private IASTInitializer initializer;
        private ICPPEvaluation initializerEvaluation;
        private ICPPClassType initializerType;

        private TupleElement(IASTInitializer initializer, ICPPEvaluation initializerEvaluation, ICPPClassType initializerType) {
            this.initializer = initializer;
            this.initializerEvaluation = initializerEvaluation;
            this.initializerType = initializerType;
        }

        @Override
        public ICPPEvaluation getEvaluation(int nameIndex) {
            EvalFixed indexEvaluation = new EvalFixed(CPPBasicType.UNSIGNED_INT, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(nameIndex));
            IBinding resolvedFunction = this.resolveGetFunction(this.initializerType, this.initializer, this.initializerEvaluation, indexEvaluation);
            if (resolvedFunction instanceof ICPPMethod) {
                EvalMemberAccess eExpressionEvaluation = new EvalMemberAccess((IType)this.initializerType, this.initializerEvaluation.getValueCategory(), resolvedFunction, this.initializerEvaluation, false, this.initializer);
                return new EvalFunctionCall(new ICPPEvaluation[]{eExpressionEvaluation}, null, this.initializer);
            }
            if (resolvedFunction instanceof ICPPFunction) {
                EvalBinding functionEvaluation = new EvalBinding(resolvedFunction, (IType)((ICPPFunction)resolvedFunction).getType(), this.initializer);
                return new EvalFunctionCall(new ICPPEvaluation[]{functionEvaluation, this.initializerEvaluation}, null, this.initializer);
            }
            return EvalFixed.INCOMPLETE;
        }

        private IBinding resolveGetFunction(ICompositeType classType, IASTNode point, ICPPEvaluation argument, ICPPEvaluation index) {
            IBinding[] allGetBindings = CPPSemantics.findBindings(classType.getCompositeScope(), GET_NAME, false, point);
            ICPPFunction[] functions = (ICPPFunction[])Arrays.stream(allGetBindings).filter(IFunction.class::isInstance).map(IFunction.class::cast).toArray(ICPPFunction[]::new);
            ICPPTemplateArgument[] arguments = new ICPPTemplateArgument[]{new CPPTemplateNonTypeArgument(index)};
            LookupData lookupGet = new LookupData(GET_NAME, arguments, point);
            lookupGet.setFunctionArguments(true, argument);
            try {
                return CPPSemantics.resolveFunction(lookupGet, functions, true, true);
            }
            catch (DOMException e) {
                return null;
            }
        }
    }
}

