/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.internal.tmf.ui.widgets.timegraph.model.TimeLineEvent;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.StubPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;

public class TimeGraphViewStub
extends AbstractTimeGraphView {
    public static final String ID = "org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.timegraph.stub";
    public static final int HAT = 0;
    public static final int SKIN = 1;
    public static final int HAIR = 2;
    public static final int EYE = 3;
    public static final int PIE = 4;
    private static final String MARKER_GROUP = "sample";
    private final List<@NonNull TimeGraphEntry> fEntries = new ArrayList<TimeGraphEntry>();
    private final Map<String, List<@NonNull ITimeEvent>> fEvents = new HashMap<String, List<ITimeEvent>>();
    private final @NonNull TimeGraphEntry fRow2;
    private final @NonNull TimeGraphEntry fHead1;
    private final @NonNull TimeGraphEntry fRow4;
    private StubPresentationProvider fPresentationProvider = (StubPresentationProvider)super.getPresentationProvider();
    private String fFilterRegex;

    public TimeGraphViewStub() {
        super(ID, (TimeGraphPresentationProvider)new StubPresentationProvider());
        TimeGraphEntry hero1 = new TimeGraphEntry("Plumber guy", 0L, 120L);
        TimeGraphEntry hat1 = new TimeGraphEntry("Hat1", 0L, 120L);
        TimeGraphEntry hat2 = new TimeGraphEntry("Hat2", 0L, 120L);
        this.fHead1 = new TimeGraphEntry("Head1", 0L, 120L);
        TimeGraphEntry head2 = new TimeGraphEntry("Head2", 0L, 120L);
        TimeGraphEntry head3 = new TimeGraphEntry("Head3", 0L, 120L);
        TimeGraphEntry head4 = new TimeGraphEntry("Head4", 0L, 120L);
        TimeGraphEntry neck = new TimeGraphEntry("Neck", 0L, 120L);
        TimeGraphEntry hero2 = new TimeGraphEntry("Hungry pie chart", 80L, 160L);
        TimeGraphEntry row1 = new TimeGraphEntry("row1", 80L, 160L);
        this.fRow2 = new TimeGraphEntry("row2", 80L, 160L);
        TimeGraphEntry row3 = new TimeGraphEntry("row3", 80L, 160L);
        this.fRow4 = new TimeGraphEntry("row4", 80L, 160L);
        TimeGraphEntry row5 = new TimeGraphEntry("row5", 80L, 160L);
        TimeGraphEntry row6 = new TimeGraphEntry("row6", 80L, 160L);
        TimeGraphEntry row7 = new TimeGraphEntry("row7", 80L, 160L);
        TimeGraphEntry pulse = TimeGraphEntry.create((TimeGraphEntryModel)new TimeGraphEntryModel(444L, -1L, Collections.singletonList("pulse"), -1L, Long.MAX_VALUE), (ITimeGraphEntry.DisplayStyle)ITimeGraphEntry.DisplayStyle.LINE);
        this.fEntries.add(hero1);
        hero1.addChild(hat1);
        hero1.addChild(hat2);
        hero1.addChild(this.fHead1);
        hero1.addChild(head2);
        hero1.addChild(head3);
        hero1.addChild(head4);
        hero1.addChild(neck);
        this.fEntries.add(hero2);
        hero2.addChild(row1);
        hero2.addChild(this.fRow2);
        hero2.addChild(row3);
        hero2.addChild(this.fRow4);
        hero2.addChild(row5);
        hero2.addChild(row6);
        hero2.addChild(row7);
        this.fEntries.add(pulse);
        this.fEvents.put(hero1.getName(), Arrays.asList(new NullTimeEvent((ITimeGraphEntry)hero1, 0L, 120L)));
        this.fEvents.put(hat1.getName(), Arrays.asList(new NullTimeEvent((ITimeGraphEntry)hat1, 0L, 30L), new TimeEvent((ITimeGraphEntry)hat1, 30L, 50L, 0), new NullTimeEvent((ITimeGraphEntry)hat1, 80L, 40L)));
        this.fEvents.put(hat2.getName(), Arrays.asList(new NullTimeEvent((ITimeGraphEntry)hat2, 0L, 20L), new TimeEvent((ITimeGraphEntry)hat2, 20L, 90L, 0), new NullTimeEvent((ITimeGraphEntry)hat2, 110L, 10L)));
        this.fEvents.put(this.fHead1.getName(), Arrays.asList(new NullTimeEvent((ITimeGraphEntry)this.fHead1, 0L, 20L), new TimeEvent((ITimeGraphEntry)this.fHead1, 20L, 30L, 2), new TimeEvent((ITimeGraphEntry)this.fHead1, 50L, 20L, 1), new TimeEvent((ITimeGraphEntry)this.fHead1, 70L, 10L, 3), new TimeEvent((ITimeGraphEntry)this.fHead1, 80L, 10L, 1), new NullTimeEvent((ITimeGraphEntry)this.fHead1, 90L, 30L)));
        this.fEvents.put(head2.getName(), Arrays.asList(new NullTimeEvent((ITimeGraphEntry)head2, 0L, 10L), new TimeEvent((ITimeGraphEntry)head2, 10L, 10L, 2), new TimeEvent((ITimeGraphEntry)head2, 20L, 10L, 1), new TimeEvent((ITimeGraphEntry)head2, 30L, 10L, 2), new TimeEvent((ITimeGraphEntry)head2, 40L, 30L, 1), new TimeEvent((ITimeGraphEntry)head2, 70L, 10L, 3), new TimeEvent((ITimeGraphEntry)head2, 80L, 30L, 1), new NullTimeEvent((ITimeGraphEntry)head2, 110L, 10L)));
        this.fEvents.put(head3.getName(), Arrays.asList(new NullTimeEvent((ITimeGraphEntry)head3, 0L, 10L), new TimeEvent((ITimeGraphEntry)head3, 10L, 10L, 2), new TimeEvent((ITimeGraphEntry)head3, 20L, 10L, 1), new TimeEvent((ITimeGraphEntry)head3, 30L, 20L, 2), new TimeEvent((ITimeGraphEntry)head3, 50L, 30L, 1), new TimeEvent((ITimeGraphEntry)head3, 80L, 10L, 2), new TimeEvent((ITimeGraphEntry)head3, 90L, 30L, 1)));
        this.fEvents.put(head4.getName(), Arrays.asList(new NullTimeEvent((ITimeGraphEntry)head4, 0L, 10L), new TimeEvent((ITimeGraphEntry)head4, 10L, 20L, 2), new TimeEvent((ITimeGraphEntry)head4, 30L, 40L, 1), new TimeEvent((ITimeGraphEntry)head4, 70L, 40L, 2), new TimeEvent((ITimeGraphEntry)head4, 110L, 10L)));
        this.fEvents.put(neck.getName(), Arrays.asList(new NullTimeEvent((ITimeGraphEntry)neck, 0L, 30L), new TimeEvent((ITimeGraphEntry)neck, 30L, 70L, 1), new NullTimeEvent((ITimeGraphEntry)neck, 100L, 20L)));
        this.fEvents.put(row1.getName(), Arrays.asList(new TimeEvent((ITimeGraphEntry)row1, 110L, 30L, 4)));
        this.fEvents.put(this.fRow2.getName(), Arrays.asList(new TimeEvent((ITimeGraphEntry)this.fRow2, 90L, 60L, 4)));
        this.fEvents.put(row3.getName(), Arrays.asList(new TimeEvent((ITimeGraphEntry)row3, 80L, 50L, 4)));
        this.fEvents.put(this.fRow4.getName(), Arrays.asList(new TimeEvent((ITimeGraphEntry)this.fRow4, 80L, 30L, 4)));
        this.fEvents.put(row5.getName(), Arrays.asList(new TimeEvent((ITimeGraphEntry)row5, 80L, 50L, 4)));
        this.fEvents.put(row6.getName(), Arrays.asList(new TimeEvent((ITimeGraphEntry)row6, 90L, 60L, 4)));
        this.fEvents.put(row7.getName(), Arrays.asList(new TimeEvent((ITimeGraphEntry)row7, 110L, 30L, 4)));
        ArrayList<TimeLineEvent> events = new ArrayList<TimeLineEvent>();
        long i = -1L;
        while (i < 160L) {
            double phase = (double)i / 16.0;
            long value1 = Math.abs((long)(Math.sin(phase) * 1024.0) + 1024L);
            long value2 = Math.abs((long)(Math.sin(phase + 0.6283185307179586) * 1024.0) + 1024L);
            long value3 = Math.abs((long)(Math.sin(phase + 1.2566370614359172) * 1024.0) + 1024L);
            long value4 = Math.abs((long)(Math.sin(phase + 1.8849555921538759) * 1024.0) + 1024L);
            events.add(new TimeLineEvent((ITimeGraphEntry)pulse, i, Arrays.asList(value1, value2, value3, value4)));
            ++i;
        }
        this.fEvents.put(pulse.getName(), events);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        @NonNull @NonNull Multimap regexes = super.getRegexes();
        if (regexes.containsKey((Object)2) && (this.fFilterRegex == null || this.fFilterRegex.isEmpty())) {
            regexes.removeAll((Object)2);
        }
        if (!regexes.containsKey((Object)2) && this.fFilterRegex != null && !this.fFilterRegex.isEmpty()) {
            regexes.put((Object)2, (Object)this.fFilterRegex);
        }
        return regexes;
    }

    public void setFilterRegex(String filterRegex) {
        this.fFilterRegex = filterRegex;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull IProgressMonitor monitor) {
        @NonNull List entryList = this.getEntryList(trace);
        if (entryList == null || entryList.isEmpty()) {
            this.addToEntryList(trace, this.fEntries);
        }
        this.refresh();
    }

    protected StubPresentationProvider getPresentationProvider() {
        StubPresentationProvider presentationProvider = this.fPresentationProvider;
        if (presentationProvider == null && super.getPresentationProvider() instanceof StubPresentationProvider) {
            return (StubPresentationProvider)super.getPresentationProvider();
        }
        return presentationProvider;
    }

    public void setPresentationProvider(StubPresentationProvider presentationProvider) {
        this.fPresentationProvider = presentationProvider;
        this.getTimeGraphViewer().setTimeGraphProvider((ITimeGraphPresentationProvider)presentationProvider);
        this.refresh();
    }

    protected @Nullable List<@NonNull ITimeEvent> getEventList(@NonNull TimeGraphEntry entry, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptyList();
        }
        List<@NonNull ITimeEvent> references = this.fEvents.get(entry.getName());
        ArrayList<@NonNull ITimeEvent> ret = new ArrayList<ITimeEvent>();
        if (references != null) {
            for (ITimeEvent ref : references) {
                long start = ref.getTime() + trace.getStartTime().toNanos();
                long end = start + ref.getDuration();
                if (start > endTime || end < startTime) continue;
                if (ref instanceof NullTimeEvent) {
                    ret.add((ITimeEvent)new NullTimeEvent(ref.getEntry(), ref.getTime() + trace.getStartTime().toNanos(), ref.getDuration()));
                    continue;
                }
                if (ref instanceof TimeLineEvent) {
                    ret.add((ITimeEvent)new TimeLineEvent(ref.getEntry(), ref.getTime() + trace.getStartTime().toNanos(), ((TimeLineEvent)ref).getValues()));
                    continue;
                }
                if (!(ref instanceof TimeEvent)) continue;
                ret.add((ITimeEvent)new TimeEvent(ref.getEntry(), ref.getTime() + trace.getStartTime().toNanos(), ref.getDuration(), ((TimeEvent)ref).getValue()));
            }
        }
        entry.setEventList(ret);
        return ret;
    }

    protected @NonNull List<String> getMarkerCategories() {
        return Collections.singletonList(MARKER_GROUP);
    }

    protected @Nullable List<@NonNull ILinkEvent> getLinkList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new TimeLinkEvent((ITimeGraphEntry)this.fHead1, (ITimeGraphEntry)this.fRow2, 75L + trace.getStartTime().toNanos(), 15L));
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptyList();
        }
        long start = trace.getStartTime().toNanos();
        return Arrays.asList(new MarkerEvent((ITimeGraphEntry)this.fHead1, 120L + start, 50L, MARKER_GROUP, new RGBA(33, 33, 33, 33), "Wind", true), new MarkerEvent((ITimeGraphEntry)this.fRow4, 20L + start, 60L, MARKER_GROUP, new RGBA(22, 33, 44, 22), "Speed", false), new MarkerEvent((ITimeGraphEntry)this.fRow2, 20L + start, 0L, MARKER_GROUP, new RGBA(22, 33, 44, 22), "", false, 0), new MarkerEvent((ITimeGraphEntry)this.fRow2, 26L + start, 0L, MARKER_GROUP, new RGBA(22, 33, 44, 22), "", false, 1), new MarkerEvent((ITimeGraphEntry)this.fRow2, 32L + start, 0L, MARKER_GROUP, new RGBA(22, 33, 44, 22), "", false, 2), new MarkerEvent((ITimeGraphEntry)this.fRow2, 38L + start, 0L, MARKER_GROUP, new RGBA(22, 33, 44, 22), "", false, 3), new MarkerEvent((ITimeGraphEntry)this.fRow2, 44L + start, 0L, MARKER_GROUP, new RGBA(22, 33, 44, 22), "", false, 4), new MarkerEvent((ITimeGraphEntry)this.fRow2, 50L + start, 0L, MARKER_GROUP, new RGBA(22, 33, 44, 22), "", true, 5));
    }

    public TmfTimeRange getWindowRange() {
        return new TmfTimeRange(TmfTimestamp.fromNanos((long)this.getTimeGraphViewer().getTime0()), TmfTimestamp.fromNanos((long)this.getTimeGraphViewer().getTime1()));
    }
}

